/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.Destructible;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.Initializable;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.PostCollectionRecreateEventListener;
import org.hibernate.event.PostCollectionRemoveEventListener;
import org.hibernate.event.PostCollectionUpdateEventListener;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreCollectionRecreateEventListener;
import org.hibernate.event.PreCollectionRemoveEventListener;
import org.hibernate.event.PreCollectionUpdateEventListener;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEventListener;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.event.def.DefaultAutoFlushEventListener;
import org.hibernate.event.def.DefaultDeleteEventListener;
import org.hibernate.event.def.DefaultDirtyCheckEventListener;
import org.hibernate.event.def.DefaultEvictEventListener;
import org.hibernate.event.def.DefaultFlushEntityEventListener;
import org.hibernate.event.def.DefaultFlushEventListener;
import org.hibernate.event.def.DefaultInitializeCollectionEventListener;
import org.hibernate.event.def.DefaultLoadEventListener;
import org.hibernate.event.def.DefaultLockEventListener;
import org.hibernate.event.def.DefaultMergeEventListener;
import org.hibernate.event.def.DefaultPersistEventListener;
import org.hibernate.event.def.DefaultPersistOnFlushEventListener;
import org.hibernate.event.def.DefaultPostLoadEventListener;
import org.hibernate.event.def.DefaultPreLoadEventListener;
import org.hibernate.event.def.DefaultRefreshEventListener;
import org.hibernate.event.def.DefaultReplicateEventListener;
import org.hibernate.event.def.DefaultSaveEventListener;
import org.hibernate.event.def.DefaultSaveOrUpdateCopyEventListener;
import org.hibernate.event.def.DefaultSaveOrUpdateEventListener;
import org.hibernate.event.def.DefaultUpdateEventListener;
import org.hibernate.util.Cloneable;

public class EventListeners
extends Cloneable
implements Serializable {
    private LoadEventListener[] loadEventListeners = new LoadEventListener[]{new DefaultLoadEventListener()};
    private SaveOrUpdateEventListener[] saveOrUpdateEventListeners = new SaveOrUpdateEventListener[]{new DefaultSaveOrUpdateEventListener()};
    private MergeEventListener[] mergeEventListeners = new MergeEventListener[]{new DefaultMergeEventListener()};
    private PersistEventListener[] persistEventListeners = new PersistEventListener[]{new DefaultPersistEventListener()};
    private PersistEventListener[] persistOnFlushEventListeners = new PersistEventListener[]{new DefaultPersistOnFlushEventListener()};
    private ReplicateEventListener[] replicateEventListeners = new ReplicateEventListener[]{new DefaultReplicateEventListener()};
    private DeleteEventListener[] deleteEventListeners = new DeleteEventListener[]{new DefaultDeleteEventListener()};
    private AutoFlushEventListener[] autoFlushEventListeners = new AutoFlushEventListener[]{new DefaultAutoFlushEventListener()};
    private DirtyCheckEventListener[] dirtyCheckEventListeners = new DirtyCheckEventListener[]{new DefaultDirtyCheckEventListener()};
    private FlushEventListener[] flushEventListeners = new FlushEventListener[]{new DefaultFlushEventListener()};
    private EvictEventListener[] evictEventListeners = new EvictEventListener[]{new DefaultEvictEventListener()};
    private LockEventListener[] lockEventListeners = new LockEventListener[]{new DefaultLockEventListener()};
    private RefreshEventListener[] refreshEventListeners = new RefreshEventListener[]{new DefaultRefreshEventListener()};
    private FlushEntityEventListener[] flushEntityEventListeners = new FlushEntityEventListener[]{new DefaultFlushEntityEventListener()};
    private InitializeCollectionEventListener[] initializeCollectionEventListeners = new InitializeCollectionEventListener[]{new DefaultInitializeCollectionEventListener()};
    private PostLoadEventListener[] postLoadEventListeners = new PostLoadEventListener[]{new DefaultPostLoadEventListener()};
    private PreLoadEventListener[] preLoadEventListeners = new PreLoadEventListener[]{new DefaultPreLoadEventListener()};
    private PreDeleteEventListener[] preDeleteEventListeners = new PreDeleteEventListener[0];
    private PreUpdateEventListener[] preUpdateEventListeners = new PreUpdateEventListener[0];
    private PreInsertEventListener[] preInsertEventListeners = new PreInsertEventListener[0];
    private PostDeleteEventListener[] postDeleteEventListeners = new PostDeleteEventListener[0];
    private PostUpdateEventListener[] postUpdateEventListeners = new PostUpdateEventListener[0];
    private PostInsertEventListener[] postInsertEventListeners = new PostInsertEventListener[0];
    private PostDeleteEventListener[] postCommitDeleteEventListeners = new PostDeleteEventListener[0];
    private PostUpdateEventListener[] postCommitUpdateEventListeners = new PostUpdateEventListener[0];
    private PostInsertEventListener[] postCommitInsertEventListeners = new PostInsertEventListener[0];
    private PreCollectionRecreateEventListener[] preCollectionRecreateEventListeners = new PreCollectionRecreateEventListener[0];
    private PostCollectionRecreateEventListener[] postCollectionRecreateEventListeners = new PostCollectionRecreateEventListener[0];
    private PreCollectionRemoveEventListener[] preCollectionRemoveEventListeners = new PreCollectionRemoveEventListener[0];
    private PostCollectionRemoveEventListener[] postCollectionRemoveEventListeners = new PostCollectionRemoveEventListener[0];
    private PreCollectionUpdateEventListener[] preCollectionUpdateEventListeners = new PreCollectionUpdateEventListener[0];
    private PostCollectionUpdateEventListener[] postCollectionUpdateEventListeners = new PostCollectionUpdateEventListener[0];
    private SaveOrUpdateEventListener[] saveEventListeners = new SaveOrUpdateEventListener[]{new DefaultSaveEventListener()};
    private SaveOrUpdateEventListener[] updateEventListeners = new SaveOrUpdateEventListener[]{new DefaultUpdateEventListener()};
    private MergeEventListener[] saveOrUpdateCopyEventListeners = new MergeEventListener[]{new DefaultSaveOrUpdateCopyEventListener()};
    private static Map eventInterfaceFromType = new HashMap();

    public Class getListenerClassFor(String string) {
        Class clazz = (Class)eventInterfaceFromType.get(string);
        if (clazz == null) {
            throw new MappingException("Unrecognized listener type [" + string + "]");
        }
        return clazz;
    }

    private void processListeners(ListenerProcesser listenerProcesser) {
        Field[] fieldArray = this.getClass().getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Object[] objectArray;
            try {
                Object object = fieldArray[i].get(this);
                if (!(object instanceof Object[])) continue;
                objectArray = (Object[])object;
            }
            catch (Throwable throwable) {
                throw new HibernateException("could not init listeners", throwable);
            }
            int n = objectArray.length;
            for (int j = 0; j < n; ++j) {
                listenerProcesser.processListener(objectArray[j]);
            }
        }
    }

    public void initializeListeners(final Configuration configuration) {
        try {
            this.processListeners(new ListenerProcesser(){

                public void processListener(Object object) {
                    if (object instanceof Initializable) {
                        ((Initializable)object).initialize(configuration);
                    }
                }
            });
        }
        catch (Exception exception) {
            throw new HibernateException("could not init listeners", exception);
        }
    }

    public void destroyListeners() {
        try {
            this.processListeners(new ListenerProcesser(){

                public void processListener(Object object) {
                    if (object instanceof Destructible) {
                        ((Destructible)object).cleanup();
                    }
                }
            });
        }
        catch (Exception exception) {
            throw new HibernateException("could not destruct listeners", exception);
        }
    }

    public LoadEventListener[] getLoadEventListeners() {
        return this.loadEventListeners;
    }

    public void setLoadEventListeners(LoadEventListener[] loadEventListenerArray) {
        this.loadEventListeners = loadEventListenerArray;
    }

    public ReplicateEventListener[] getReplicateEventListeners() {
        return this.replicateEventListeners;
    }

    public void setReplicateEventListeners(ReplicateEventListener[] replicateEventListenerArray) {
        this.replicateEventListeners = replicateEventListenerArray;
    }

    public DeleteEventListener[] getDeleteEventListeners() {
        return this.deleteEventListeners;
    }

    public void setDeleteEventListeners(DeleteEventListener[] deleteEventListenerArray) {
        this.deleteEventListeners = deleteEventListenerArray;
    }

    public AutoFlushEventListener[] getAutoFlushEventListeners() {
        return this.autoFlushEventListeners;
    }

    public void setAutoFlushEventListeners(AutoFlushEventListener[] autoFlushEventListenerArray) {
        this.autoFlushEventListeners = autoFlushEventListenerArray;
    }

    public DirtyCheckEventListener[] getDirtyCheckEventListeners() {
        return this.dirtyCheckEventListeners;
    }

    public void setDirtyCheckEventListeners(DirtyCheckEventListener[] dirtyCheckEventListenerArray) {
        this.dirtyCheckEventListeners = dirtyCheckEventListenerArray;
    }

    public FlushEventListener[] getFlushEventListeners() {
        return this.flushEventListeners;
    }

    public void setFlushEventListeners(FlushEventListener[] flushEventListenerArray) {
        this.flushEventListeners = flushEventListenerArray;
    }

    public EvictEventListener[] getEvictEventListeners() {
        return this.evictEventListeners;
    }

    public void setEvictEventListeners(EvictEventListener[] evictEventListenerArray) {
        this.evictEventListeners = evictEventListenerArray;
    }

    public LockEventListener[] getLockEventListeners() {
        return this.lockEventListeners;
    }

    public void setLockEventListeners(LockEventListener[] lockEventListenerArray) {
        this.lockEventListeners = lockEventListenerArray;
    }

    public RefreshEventListener[] getRefreshEventListeners() {
        return this.refreshEventListeners;
    }

    public void setRefreshEventListeners(RefreshEventListener[] refreshEventListenerArray) {
        this.refreshEventListeners = refreshEventListenerArray;
    }

    public InitializeCollectionEventListener[] getInitializeCollectionEventListeners() {
        return this.initializeCollectionEventListeners;
    }

    public void setInitializeCollectionEventListeners(InitializeCollectionEventListener[] initializeCollectionEventListenerArray) {
        this.initializeCollectionEventListeners = initializeCollectionEventListenerArray;
    }

    public FlushEntityEventListener[] getFlushEntityEventListeners() {
        return this.flushEntityEventListeners;
    }

    public void setFlushEntityEventListeners(FlushEntityEventListener[] flushEntityEventListenerArray) {
        this.flushEntityEventListeners = flushEntityEventListenerArray;
    }

    public SaveOrUpdateEventListener[] getSaveOrUpdateEventListeners() {
        return this.saveOrUpdateEventListeners;
    }

    public void setSaveOrUpdateEventListeners(SaveOrUpdateEventListener[] saveOrUpdateEventListenerArray) {
        this.saveOrUpdateEventListeners = saveOrUpdateEventListenerArray;
    }

    public MergeEventListener[] getMergeEventListeners() {
        return this.mergeEventListeners;
    }

    public void setMergeEventListeners(MergeEventListener[] mergeEventListenerArray) {
        this.mergeEventListeners = mergeEventListenerArray;
    }

    public PersistEventListener[] getPersistEventListeners() {
        return this.persistEventListeners;
    }

    public void setPersistEventListeners(PersistEventListener[] persistEventListenerArray) {
        this.persistEventListeners = persistEventListenerArray;
    }

    public PersistEventListener[] getPersistOnFlushEventListeners() {
        return this.persistOnFlushEventListeners;
    }

    public void setPersistOnFlushEventListeners(PersistEventListener[] persistEventListenerArray) {
        this.persistOnFlushEventListeners = persistEventListenerArray;
    }

    public MergeEventListener[] getSaveOrUpdateCopyEventListeners() {
        return this.saveOrUpdateCopyEventListeners;
    }

    public void setSaveOrUpdateCopyEventListeners(MergeEventListener[] mergeEventListenerArray) {
        this.saveOrUpdateCopyEventListeners = mergeEventListenerArray;
    }

    public SaveOrUpdateEventListener[] getSaveEventListeners() {
        return this.saveEventListeners;
    }

    public void setSaveEventListeners(SaveOrUpdateEventListener[] saveOrUpdateEventListenerArray) {
        this.saveEventListeners = saveOrUpdateEventListenerArray;
    }

    public SaveOrUpdateEventListener[] getUpdateEventListeners() {
        return this.updateEventListeners;
    }

    public void setUpdateEventListeners(SaveOrUpdateEventListener[] saveOrUpdateEventListenerArray) {
        this.updateEventListeners = saveOrUpdateEventListenerArray;
    }

    public PostLoadEventListener[] getPostLoadEventListeners() {
        return this.postLoadEventListeners;
    }

    public void setPostLoadEventListeners(PostLoadEventListener[] postLoadEventListenerArray) {
        this.postLoadEventListeners = postLoadEventListenerArray;
    }

    public PreLoadEventListener[] getPreLoadEventListeners() {
        return this.preLoadEventListeners;
    }

    public void setPreLoadEventListeners(PreLoadEventListener[] preLoadEventListenerArray) {
        this.preLoadEventListeners = preLoadEventListenerArray;
    }

    public PreCollectionRecreateEventListener[] getPreCollectionRecreateEventListeners() {
        return this.preCollectionRecreateEventListeners;
    }

    public void setPreCollectionRecreateEventListeners(PreCollectionRecreateEventListener[] preCollectionRecreateEventListenerArray) {
        this.preCollectionRecreateEventListeners = preCollectionRecreateEventListenerArray;
    }

    public PreCollectionRemoveEventListener[] getPreCollectionRemoveEventListeners() {
        return this.preCollectionRemoveEventListeners;
    }

    public void setPreCollectionRemoveEventListeners(PreCollectionRemoveEventListener[] preCollectionRemoveEventListenerArray) {
        this.preCollectionRemoveEventListeners = preCollectionRemoveEventListenerArray;
    }

    public PreCollectionUpdateEventListener[] getPreCollectionUpdateEventListeners() {
        return this.preCollectionUpdateEventListeners;
    }

    public void setPreCollectionUpdateEventListeners(PreCollectionUpdateEventListener[] preCollectionUpdateEventListenerArray) {
        this.preCollectionUpdateEventListeners = preCollectionUpdateEventListenerArray;
    }

    public PostDeleteEventListener[] getPostDeleteEventListeners() {
        return this.postDeleteEventListeners;
    }

    public PostInsertEventListener[] getPostInsertEventListeners() {
        return this.postInsertEventListeners;
    }

    public PostUpdateEventListener[] getPostUpdateEventListeners() {
        return this.postUpdateEventListeners;
    }

    public void setPostDeleteEventListeners(PostDeleteEventListener[] postDeleteEventListenerArray) {
        this.postDeleteEventListeners = postDeleteEventListenerArray;
    }

    public void setPostInsertEventListeners(PostInsertEventListener[] postInsertEventListenerArray) {
        this.postInsertEventListeners = postInsertEventListenerArray;
    }

    public void setPostUpdateEventListeners(PostUpdateEventListener[] postUpdateEventListenerArray) {
        this.postUpdateEventListeners = postUpdateEventListenerArray;
    }

    public PostCollectionRecreateEventListener[] getPostCollectionRecreateEventListeners() {
        return this.postCollectionRecreateEventListeners;
    }

    public void setPostCollectionRecreateEventListeners(PostCollectionRecreateEventListener[] postCollectionRecreateEventListenerArray) {
        this.postCollectionRecreateEventListeners = postCollectionRecreateEventListenerArray;
    }

    public PostCollectionRemoveEventListener[] getPostCollectionRemoveEventListeners() {
        return this.postCollectionRemoveEventListeners;
    }

    public void setPostCollectionRemoveEventListeners(PostCollectionRemoveEventListener[] postCollectionRemoveEventListenerArray) {
        this.postCollectionRemoveEventListeners = postCollectionRemoveEventListenerArray;
    }

    public PostCollectionUpdateEventListener[] getPostCollectionUpdateEventListeners() {
        return this.postCollectionUpdateEventListeners;
    }

    public void setPostCollectionUpdateEventListeners(PostCollectionUpdateEventListener[] postCollectionUpdateEventListenerArray) {
        this.postCollectionUpdateEventListeners = postCollectionUpdateEventListenerArray;
    }

    public PreDeleteEventListener[] getPreDeleteEventListeners() {
        return this.preDeleteEventListeners;
    }

    public void setPreDeleteEventListeners(PreDeleteEventListener[] preDeleteEventListenerArray) {
        this.preDeleteEventListeners = preDeleteEventListenerArray;
    }

    public PreInsertEventListener[] getPreInsertEventListeners() {
        return this.preInsertEventListeners;
    }

    public void setPreInsertEventListeners(PreInsertEventListener[] preInsertEventListenerArray) {
        this.preInsertEventListeners = preInsertEventListenerArray;
    }

    public PreUpdateEventListener[] getPreUpdateEventListeners() {
        return this.preUpdateEventListeners;
    }

    public void setPreUpdateEventListeners(PreUpdateEventListener[] preUpdateEventListenerArray) {
        this.preUpdateEventListeners = preUpdateEventListenerArray;
    }

    public PostDeleteEventListener[] getPostCommitDeleteEventListeners() {
        return this.postCommitDeleteEventListeners;
    }

    public void setPostCommitDeleteEventListeners(PostDeleteEventListener[] postDeleteEventListenerArray) {
        this.postCommitDeleteEventListeners = postDeleteEventListenerArray;
    }

    public PostInsertEventListener[] getPostCommitInsertEventListeners() {
        return this.postCommitInsertEventListeners;
    }

    public void setPostCommitInsertEventListeners(PostInsertEventListener[] postInsertEventListenerArray) {
        this.postCommitInsertEventListeners = postInsertEventListenerArray;
    }

    public PostUpdateEventListener[] getPostCommitUpdateEventListeners() {
        return this.postCommitUpdateEventListeners;
    }

    public void setPostCommitUpdateEventListeners(PostUpdateEventListener[] postUpdateEventListenerArray) {
        this.postCommitUpdateEventListeners = postUpdateEventListenerArray;
    }

    static {
        eventInterfaceFromType.put("auto-flush", AutoFlushEventListener.class);
        eventInterfaceFromType.put("merge", MergeEventListener.class);
        eventInterfaceFromType.put("create", PersistEventListener.class);
        eventInterfaceFromType.put("create-onflush", PersistEventListener.class);
        eventInterfaceFromType.put("delete", DeleteEventListener.class);
        eventInterfaceFromType.put("dirty-check", DirtyCheckEventListener.class);
        eventInterfaceFromType.put("evict", EvictEventListener.class);
        eventInterfaceFromType.put("flush", FlushEventListener.class);
        eventInterfaceFromType.put("flush-entity", FlushEntityEventListener.class);
        eventInterfaceFromType.put("load", LoadEventListener.class);
        eventInterfaceFromType.put("load-collection", InitializeCollectionEventListener.class);
        eventInterfaceFromType.put("lock", LockEventListener.class);
        eventInterfaceFromType.put("refresh", RefreshEventListener.class);
        eventInterfaceFromType.put("replicate", ReplicateEventListener.class);
        eventInterfaceFromType.put("save-update", SaveOrUpdateEventListener.class);
        eventInterfaceFromType.put("save", SaveOrUpdateEventListener.class);
        eventInterfaceFromType.put("update", SaveOrUpdateEventListener.class);
        eventInterfaceFromType.put("pre-load", PreLoadEventListener.class);
        eventInterfaceFromType.put("pre-update", PreUpdateEventListener.class);
        eventInterfaceFromType.put("pre-delete", PreDeleteEventListener.class);
        eventInterfaceFromType.put("pre-insert", PreInsertEventListener.class);
        eventInterfaceFromType.put("pre-collection-recreate", PreCollectionRecreateEventListener.class);
        eventInterfaceFromType.put("pre-collection-remove", PreCollectionRemoveEventListener.class);
        eventInterfaceFromType.put("pre-collection-update", PreCollectionUpdateEventListener.class);
        eventInterfaceFromType.put("post-load", PostLoadEventListener.class);
        eventInterfaceFromType.put("post-update", PostUpdateEventListener.class);
        eventInterfaceFromType.put("post-delete", PostDeleteEventListener.class);
        eventInterfaceFromType.put("post-insert", PostInsertEventListener.class);
        eventInterfaceFromType.put("post-commit-update", PostUpdateEventListener.class);
        eventInterfaceFromType.put("post-commit-delete", PostDeleteEventListener.class);
        eventInterfaceFromType.put("post-commit-insert", PostInsertEventListener.class);
        eventInterfaceFromType.put("post-collection-recreate", PostCollectionRecreateEventListener.class);
        eventInterfaceFromType.put("post-collection-remove", PostCollectionRemoveEventListener.class);
        eventInterfaceFromType.put("post-collection-update", PostCollectionUpdateEventListener.class);
        eventInterfaceFromType = Collections.unmodifiableMap(eventInterfaceFromType);
    }

    private static interface ListenerProcesser {
        public void processListener(Object var1);
    }
}

