/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionRecreateAction;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.action.CollectionUpdateAction;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.ActionQueue;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.Collections;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.FlushEntityEvent;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.FlushEvent;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.Printer;
import org.hibernate.util.IdentityMap;
import org.hibernate.util.LazyIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlushingEventListener
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractFlushingEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushEverythingToExecutions(FlushEvent flushEvent) throws HibernateException {
        log.trace("flushing session");
        EventSource eventSource = flushEvent.getSession();
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        eventSource.getInterceptor().preFlush(new LazyIterator(persistenceContext.getEntitiesByKey()));
        this.prepareEntityFlushes(eventSource);
        this.prepareCollectionFlushes(eventSource);
        persistenceContext.setFlushing(true);
        try {
            this.flushEntities(flushEvent);
            this.flushCollections(eventSource);
        }
        finally {
            persistenceContext.setFlushing(false);
        }
        if (log.isDebugEnabled()) {
            log.debug("Flushed: " + eventSource.getActionQueue().numberOfInsertions() + " insertions, " + eventSource.getActionQueue().numberOfUpdates() + " updates, " + eventSource.getActionQueue().numberOfDeletions() + " deletions to " + persistenceContext.getEntityEntries().size() + " objects");
            log.debug("Flushed: " + eventSource.getActionQueue().numberOfCollectionCreations() + " (re)creations, " + eventSource.getActionQueue().numberOfCollectionUpdates() + " updates, " + eventSource.getActionQueue().numberOfCollectionRemovals() + " removals to " + persistenceContext.getCollectionEntries().size() + " collections");
            new Printer(eventSource.getFactory()).toString(persistenceContext.getEntitiesByKey().values().iterator(), eventSource.getEntityMode());
        }
    }

    private void prepareEntityFlushes(EventSource eventSource) throws HibernateException {
        log.debug("processing flush-time cascades");
        Map.Entry[] entryArray = IdentityMap.concurrentEntries(eventSource.getPersistenceContext().getEntityEntries());
        int n = entryArray.length;
        Object object = this.getAnything();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = entryArray[i];
            EntityEntry entityEntry = (EntityEntry)entry.getValue();
            Status status = entityEntry.getStatus();
            if (status != Status.MANAGED && status != Status.SAVING && status != Status.READ_ONLY) continue;
            this.cascadeOnFlush(eventSource, entityEntry.getPersister(), entry.getKey(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnFlush(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadingAction(), 0, eventSource).cascade(entityPersister, object, object2);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected Object getAnything() {
        return null;
    }

    protected CascadingAction getCascadingAction() {
        return CascadingAction.SAVE_UPDATE;
    }

    private void prepareCollectionFlushes(SessionImplementor sessionImplementor) throws HibernateException {
        log.debug("dirty checking collections");
        List list = IdentityMap.entries(sessionImplementor.getPersistenceContext().getCollectionEntries());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)list.get(i);
            ((CollectionEntry)entry.getValue()).preFlush((PersistentCollection)entry.getKey());
        }
    }

    private void flushEntities(FlushEvent flushEvent) throws HibernateException {
        log.trace("Flushing entities and processing referenced collections");
        EventSource eventSource = flushEvent.getSession();
        for (Map.Entry entry : IdentityMap.concurrentEntries(eventSource.getPersistenceContext().getEntityEntries())) {
            EntityEntry entityEntry = (EntityEntry)entry.getValue();
            Status status = entityEntry.getStatus();
            if (status == Status.LOADING || status == Status.GONE) continue;
            FlushEntityEvent flushEntityEvent = new FlushEntityEvent(eventSource, entry.getKey(), entityEntry);
            FlushEntityEventListener[] flushEntityEventListenerArray = eventSource.getListeners().getFlushEntityEventListeners();
            for (int i = 0; i < flushEntityEventListenerArray.length; ++i) {
                flushEntityEventListenerArray[i].onFlushEntity(flushEntityEvent);
            }
        }
        eventSource.getActionQueue().sortActions();
    }

    private void flushCollections(EventSource eventSource) throws HibernateException {
        Object object;
        log.trace("Processing unreferenced collections");
        List list = IdentityMap.entries(eventSource.getPersistenceContext().getCollectionEntries());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = (Map.Entry)list.get(i);
            object = (CollectionEntry)entry.getValue();
            if (((CollectionEntry)object).isReached() || ((CollectionEntry)object).isIgnore()) continue;
            Collections.processUnreachableCollection((PersistentCollection)entry.getKey(), eventSource);
        }
        log.trace("Scheduling collection removes/(re)creates/updates");
        list = IdentityMap.entries(eventSource.getPersistenceContext().getCollectionEntries());
        n = list.size();
        ActionQueue actionQueue = eventSource.getActionQueue();
        for (int i = 0; i < n; ++i) {
            object = (Map.Entry)list.get(i);
            PersistentCollection persistentCollection = (PersistentCollection)object.getKey();
            CollectionEntry collectionEntry = (CollectionEntry)object.getValue();
            if (collectionEntry.isDorecreate()) {
                eventSource.getInterceptor().onCollectionRecreate(persistentCollection, collectionEntry.getCurrentKey());
                actionQueue.addAction(new CollectionRecreateAction(persistentCollection, collectionEntry.getCurrentPersister(), collectionEntry.getCurrentKey(), (SessionImplementor)eventSource));
            }
            if (collectionEntry.isDoremove()) {
                eventSource.getInterceptor().onCollectionRemove(persistentCollection, collectionEntry.getLoadedKey());
                actionQueue.addAction(new CollectionRemoveAction(persistentCollection, collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), collectionEntry.isSnapshotEmpty(persistentCollection), (SessionImplementor)eventSource));
            }
            if (!collectionEntry.isDoupdate()) continue;
            eventSource.getInterceptor().onCollectionUpdate(persistentCollection, collectionEntry.getLoadedKey());
            actionQueue.addAction(new CollectionUpdateAction(persistentCollection, collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), collectionEntry.isSnapshotEmpty(persistentCollection), eventSource));
        }
        actionQueue.sortCollectionActions();
    }

    protected void performExecutions(EventSource eventSource) throws HibernateException {
        log.trace("executing flush");
        try {
            eventSource.getJDBCContext().getConnectionManager().flushBeginning();
            eventSource.getActionQueue().prepareActions();
            eventSource.getActionQueue().executeActions();
        }
        catch (HibernateException hibernateException) {
            log.error("Could not synchronize database state with session", hibernateException);
            throw hibernateException;
        }
        finally {
            eventSource.getJDBCContext().getConnectionManager().flushEnding();
        }
    }

    protected void postFlush(SessionImplementor sessionImplementor) throws HibernateException {
        log.trace("post flush");
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        persistenceContext.getCollectionsByKey().clear();
        persistenceContext.getBatchFetchQueue().clearSubselects();
        for (Map.Entry entry : persistenceContext.getCollectionEntries().entrySet()) {
            CollectionEntry collectionEntry = (CollectionEntry)entry.getValue();
            PersistentCollection persistentCollection = (PersistentCollection)entry.getKey();
            collectionEntry.postFlush(persistentCollection);
            if (collectionEntry.getLoadedPersister() == null) {
                persistenceContext.getCollectionEntries().remove(persistentCollection);
                continue;
            }
            CollectionKey collectionKey = new CollectionKey(collectionEntry.getLoadedPersister(), collectionEntry.getLoadedKey(), sessionImplementor.getEntityMode());
            persistenceContext.getCollectionsByKey().put(collectionKey, persistentCollection);
        }
        sessionImplementor.getInterceptor().postFlush(new LazyIterator(persistenceContext.getEntitiesByKey()));
    }
}

