/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectDeletedException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractReassociateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractLockUpgradeEventListener
extends AbstractReassociateEventListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractLockUpgradeEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeLock(Object object, EntityEntry entityEntry, LockOptions lockOptions, EventSource eventSource) {
        SoftLock softLock;
        CacheKey cacheKey;
        LockMode lockMode = lockOptions.getLockMode();
        if (!lockMode.greaterThan(entityEntry.getLockMode())) return;
        if (entityEntry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        EntityPersister entityPersister = entityEntry.getPersister();
        if (log.isTraceEnabled()) {
            log.trace("locking " + MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()) + " in mode: " + lockMode);
        }
        if (entityPersister.hasCache()) {
            cacheKey = new CacheKey(entityEntry.getId(), entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), eventSource.getEntityMode(), eventSource.getFactory());
            softLock = entityPersister.getCacheAccessStrategy().lockItem(cacheKey, entityEntry.getVersion());
        } else {
            cacheKey = null;
            softLock = null;
        }
        try {
            if (entityPersister.isVersioned() && lockMode == LockMode.FORCE) {
                Object object2 = entityPersister.forceVersionIncrement(entityEntry.getId(), entityEntry.getVersion(), eventSource);
                entityEntry.forceLocked(object, object2);
            } else {
                entityPersister.lock(entityEntry.getId(), entityEntry.getVersion(), object, lockOptions, (SessionImplementor)eventSource);
            }
            entityEntry.setLockMode(lockMode);
            if (!entityPersister.hasCache()) return;
        }
        catch (Throwable throwable) {
            if (!entityPersister.hasCache()) throw throwable;
            entityPersister.getCacheAccessStrategy().unlockItem(cacheKey, softLock);
            throw throwable;
        }
        entityPersister.getCacheAccessStrategy().unlockItem(cacheKey, softLock);
    }
}

