/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.LockMode;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.AbstractEvent;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.OnLockVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractReassociateEventListener
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractReassociateEventListener.class);

    protected final EntityEntry reassociate(AbstractEvent abstractEvent, Object object, Serializable serializable, EntityPersister entityPersister) {
        if (log.isTraceEnabled()) {
            log.trace("reassociating transient instance: " + MessageHelper.infoString(entityPersister, serializable, abstractEvent.getSession().getFactory()));
        }
        EventSource eventSource = abstractEvent.getSession();
        EntityKey entityKey = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
        eventSource.getPersistenceContext().checkUniqueness(entityKey, object);
        Object[] objectArray = entityPersister.getPropertyValues(object, eventSource.getEntityMode());
        TypeHelper.deepCopy(objectArray, entityPersister.getPropertyTypes(), entityPersister.getPropertyUpdateability(), objectArray, eventSource);
        Object object2 = Versioning.getVersion(objectArray, entityPersister);
        EntityEntry entityEntry = eventSource.getPersistenceContext().addEntity(object, entityPersister.isMutable() ? Status.MANAGED : Status.READ_ONLY, objectArray, entityKey, object2, LockMode.NONE, true, entityPersister, false, true);
        new OnLockVisitor(eventSource, serializable, object).process(object, entityPersister);
        entityPersister.afterReassociate(object, eventSource);
        return entityEntry;
    }
}

