/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.action.Executable;
import org.hibernate.classic.Lifecycle;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractReassociateEventListener;
import org.hibernate.event.def.WrapVisitor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaveEventListener
extends AbstractReassociateEventListener {
    protected static final int PERSISTENT = 0;
    protected static final int TRANSIENT = 1;
    protected static final int DETACHED = 2;
    protected static final int DELETED = 3;
    private static final Logger log = LoggerFactory.getLogger(AbstractSaveEventListener.class);

    protected Serializable saveWithRequestedId(Object object, Serializable serializable, String string, Object object2, EventSource eventSource) {
        return this.performSave(object, serializable, eventSource.getEntityPersister(string, object), false, object2, eventSource, true);
    }

    protected Serializable saveWithGeneratedId(Object object, String string, Object object2, EventSource eventSource, boolean bl) {
        EntityPersister entityPersister = eventSource.getEntityPersister(string, object);
        Serializable serializable = entityPersister.getIdentifierGenerator().generate(eventSource, object);
        if (serializable == null) {
            throw new IdentifierGenerationException("null id generated for:" + object.getClass());
        }
        if (serializable == IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR) {
            return eventSource.getIdentifier(object);
        }
        if (serializable == IdentifierGeneratorHelper.POST_INSERT_INDICATOR) {
            return this.performSave(object, null, entityPersister, true, object2, eventSource, bl);
        }
        if (log.isDebugEnabled()) {
            log.debug("generated identifier: " + entityPersister.getIdentifierType().toLoggableString(serializable, eventSource.getFactory()) + ", using strategy: " + entityPersister.getIdentifierGenerator().getClass().getName());
        }
        return this.performSave(object, serializable, entityPersister, false, object2, eventSource, true);
    }

    protected Serializable performSave(Object object, Serializable serializable, EntityPersister entityPersister, boolean bl, Object object2, EventSource eventSource, boolean bl2) {
        EntityKey entityKey;
        if (log.isTraceEnabled()) {
            log.trace("saving " + MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
        }
        if (!bl) {
            entityKey = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            Object object3 = eventSource.getPersistenceContext().getEntity(entityKey);
            if (object3 != null) {
                if (eventSource.getPersistenceContext().getEntry(object3).getStatus() == Status.DELETED) {
                    eventSource.forceFlush(eventSource.getPersistenceContext().getEntry(object3));
                } else {
                    throw new NonUniqueObjectException(serializable, entityPersister.getEntityName());
                }
            }
            entityPersister.setIdentifier(object, serializable, eventSource);
        } else {
            entityKey = null;
        }
        if (this.invokeSaveLifecycle(object, entityPersister, eventSource)) {
            return serializable;
        }
        return this.performSaveOrReplicate(object, entityKey, entityPersister, bl, object2, eventSource, bl2);
    }

    protected boolean invokeSaveLifecycle(Object object, EntityPersister entityPersister, EventSource eventSource) {
        if (entityPersister.implementsLifecycle(eventSource.getEntityMode())) {
            log.debug("calling onSave()");
            if (((Lifecycle)object).onSave(eventSource)) {
                log.debug("insertion vetoed by onSave()");
                return true;
            }
        }
        return false;
    }

    protected void validate(Object object, EntityPersister entityPersister, EventSource eventSource) {
        if (entityPersister.implementsValidatable(eventSource.getEntityMode())) {
            ((Validatable)object).validate();
        }
    }

    protected Serializable performSaveOrReplicate(Object object, EntityKey entityKey, EntityPersister entityPersister, boolean bl, Object object2, EventSource eventSource, boolean bl2) {
        Object object3;
        this.validate(object, entityPersister, eventSource);
        Serializable serializable = entityKey == null ? null : entityKey.getIdentifier();
        boolean bl3 = eventSource.getJDBCContext().isTransactionInProgress();
        boolean bl4 = !bl3 && !bl2;
        eventSource.getPersistenceContext().addEntry(object, Status.SAVING, null, null, serializable, null, LockMode.WRITE, bl, entityPersister, false, false);
        this.cascadeBeforeSave(eventSource, entityPersister, object, object2);
        if (bl && !bl4) {
            log.trace("executing insertions");
            eventSource.getActionQueue().executeInserts();
        }
        Object[] objectArray = entityPersister.getPropertyValuesToInsert(object, this.getMergeMap(object2), eventSource);
        Type[] typeArray = entityPersister.getPropertyTypes();
        boolean bl5 = this.substituteValuesIfNecessary(object, serializable, objectArray, entityPersister, eventSource);
        if (entityPersister.hasCollections()) {
            boolean bl6 = bl5 = bl5 || this.visitCollectionsBeforeSave(object, serializable, objectArray, typeArray, eventSource);
        }
        if (bl5) {
            entityPersister.setPropertyValues(object, objectArray, eventSource.getEntityMode());
        }
        TypeHelper.deepCopy(objectArray, typeArray, entityPersister.getPropertyUpdateability(), objectArray, eventSource);
        new ForeignKeys.Nullifier(object, false, bl, eventSource).nullifyTransientReferences(objectArray, typeArray);
        new Nullability(eventSource).checkNullability(objectArray, entityPersister, false);
        if (bl) {
            object3 = new EntityIdentityInsertAction(objectArray, object, entityPersister, eventSource, bl4);
            if (!bl4) {
                log.debug("executing identity-insert immediately");
                eventSource.getActionQueue().execute((Executable)object3);
                serializable = ((EntityIdentityInsertAction)object3).getGeneratedId();
                entityKey = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
                eventSource.getPersistenceContext().checkUniqueness(entityKey, object);
            } else {
                log.debug("delaying identity-insert due to no transaction in progress");
                eventSource.getActionQueue().addAction((EntityIdentityInsertAction)object3);
                entityKey = ((EntityIdentityInsertAction)object3).getDelayedEntityKey();
            }
        }
        object3 = Versioning.getVersion(objectArray, entityPersister);
        eventSource.getPersistenceContext().addEntity(object, entityPersister.isMutable() ? Status.MANAGED : Status.READ_ONLY, objectArray, entityKey, object3, LockMode.WRITE, bl, entityPersister, this.isVersionIncrementDisabled(), false);
        if (!bl) {
            eventSource.getActionQueue().addAction(new EntityInsertAction(serializable, objectArray, object, object3, entityPersister, eventSource));
        }
        this.cascadeAfterSave(eventSource, entityPersister, object, object2);
        this.markInterceptorDirty(object, entityPersister, eventSource);
        return serializable;
    }

    private void markInterceptorDirty(Object object, EntityPersister entityPersister, EventSource eventSource) {
        if (FieldInterceptionHelper.isInstrumented(object)) {
            FieldInterceptor fieldInterceptor = FieldInterceptionHelper.injectFieldInterceptor(object, entityPersister.getEntityName(), null, eventSource);
            fieldInterceptor.dirty();
        }
    }

    protected Map getMergeMap(Object object) {
        return null;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollectionsBeforeSave(Object object, Serializable serializable, Object[] objectArray, Type[] typeArray, EventSource eventSource) {
        WrapVisitor wrapVisitor = new WrapVisitor(eventSource);
        wrapVisitor.processEntityPropertyValues(objectArray, typeArray);
        return wrapVisitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object object, Serializable serializable, Object[] objectArray, EntityPersister entityPersister, SessionImplementor sessionImplementor) {
        boolean bl = sessionImplementor.getInterceptor().onSave(object, serializable, objectArray, entityPersister.getPropertyNames(), entityPersister.getPropertyTypes());
        if (entityPersister.isVersioned()) {
            bl = Versioning.seedVersion(objectArray, entityPersister.getVersionProperty(), entityPersister.getVersionType(), sessionImplementor) || bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 2, eventSource).cascade(entityPersister, object, object2);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 1, eventSource).cascade(entityPersister, object, object2);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected abstract CascadingAction getCascadeAction();

    protected int getEntityState(Object object, String string, EntityEntry entityEntry, SessionImplementor sessionImplementor) {
        if (entityEntry != null) {
            if (entityEntry.getStatus() != Status.DELETED) {
                if (log.isTraceEnabled()) {
                    log.trace("persistent instance of: " + this.getLoggableName(string, object));
                }
                return 0;
            }
            if (log.isTraceEnabled()) {
                log.trace("deleted instance of: " + this.getLoggableName(string, object));
            }
            return 3;
        }
        if (ForeignKeys.isTransient(string, object, this.getAssumedUnsaved(), sessionImplementor)) {
            if (log.isTraceEnabled()) {
                log.trace("transient instance of: " + this.getLoggableName(string, object));
            }
            return 1;
        }
        if (log.isTraceEnabled()) {
            log.trace("detached instance of: " + this.getLoggableName(string, object));
        }
        return 2;
    }

    protected String getLoggableName(String string, Object object) {
        return string == null ? object.getClass().getName() : string;
    }

    protected Boolean getAssumedUnsaved() {
        return null;
    }
}

