/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.event.AutoFlushEvent;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractFlushingEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAutoFlushEventListener
extends AbstractFlushingEventListener
implements AutoFlushEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultAutoFlushEventListener.class);

    public void onAutoFlush(AutoFlushEvent autoFlushEvent) throws HibernateException {
        EventSource eventSource = autoFlushEvent.getSession();
        if (this.flushMightBeNeeded(eventSource)) {
            int n = eventSource.getActionQueue().numberOfCollectionRemovals();
            this.flushEverythingToExecutions(autoFlushEvent);
            if (this.flushIsReallyNeeded(autoFlushEvent, eventSource)) {
                log.trace("Need to execute flush");
                this.performExecutions(eventSource);
                this.postFlush(eventSource);
                if (eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
                    eventSource.getFactory().getStatisticsImplementor().flush();
                }
            } else {
                log.trace("Dont need to execute flush");
                eventSource.getActionQueue().clearFromFlushNeededCheck(n);
            }
            autoFlushEvent.setFlushRequired(this.flushIsReallyNeeded(autoFlushEvent, eventSource));
        }
    }

    private boolean flushIsReallyNeeded(AutoFlushEvent autoFlushEvent, EventSource eventSource) {
        return eventSource.getActionQueue().areTablesToBeUpdated(autoFlushEvent.getQuerySpaces()) || eventSource.getFlushMode() == FlushMode.ALWAYS;
    }

    private boolean flushMightBeNeeded(EventSource eventSource) {
        return !eventSource.getFlushMode().lessThan(FlushMode.AUTO) && eventSource.getDontFlushFromFind() == 0 && (eventSource.getPersistenceContext().getEntityEntries().size() > 0 || eventSource.getPersistenceContext().getCollectionEntries().size() > 0);
    }
}

