/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.TransientObjectException;
import org.hibernate.action.EntityDeleteAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.Status;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.OnUpdateVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.hibernate.util.IdentitySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeleteEventListener
implements DeleteEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeleteEventListener.class);

    public void onDelete(DeleteEvent deleteEvent) throws HibernateException {
        this.onDelete(deleteEvent, new IdentitySet());
    }

    public void onDelete(DeleteEvent deleteEvent, Set set) throws HibernateException {
        Object object;
        Serializable serializable;
        EntityPersister entityPersister;
        Object object2;
        EventSource eventSource = deleteEvent.getSession();
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(object2 = persistenceContext.unproxyAndReassociate(deleteEvent.getObject()));
        if (entityEntry == null) {
            log.trace("entity was not persistent in delete processing");
            entityPersister = eventSource.getEntityPersister(deleteEvent.getEntityName(), object2);
            if (ForeignKeys.isTransient(entityPersister.getEntityName(), object2, null, eventSource)) {
                this.deleteTransientEntity(eventSource, object2, deleteEvent.isCascadeDeleteEnabled(), entityPersister, set);
                return;
            }
            this.performDetachedEntityDeletionCheck(deleteEvent);
            serializable = entityPersister.getIdentifier(object2, eventSource);
            if (serializable == null) {
                throw new TransientObjectException("the detached instance passed to delete() had a null identifier");
            }
            EntityKey entityKey = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            persistenceContext.checkUniqueness(entityKey, object2);
            new OnUpdateVisitor(eventSource, serializable, object2).process(object2, entityPersister);
            object = entityPersister.getVersion(object2, eventSource.getEntityMode());
            entityEntry = persistenceContext.addEntity(object2, entityPersister.isMutable() ? Status.MANAGED : Status.READ_ONLY, entityPersister.getPropertyValues(object2, eventSource.getEntityMode()), entityKey, object, LockMode.NONE, true, entityPersister, false, false);
        } else {
            log.trace("deleting a persistent instance");
            if (entityEntry.getStatus() == Status.DELETED || entityEntry.getStatus() == Status.GONE) {
                log.trace("object was already deleted");
                return;
            }
            entityPersister = entityEntry.getPersister();
            serializable = entityEntry.getId();
            object = entityEntry.getVersion();
        }
        if (this.invokeDeleteLifecycle(eventSource, object2, entityPersister)) {
            return;
        }
        this.deleteEntity(eventSource, object2, entityEntry, deleteEvent.isCascadeDeleteEnabled(), entityPersister, set);
        if (eventSource.getFactory().getSettings().isIdentifierRollbackEnabled()) {
            entityPersister.resetIdentifier(object2, serializable, object, eventSource);
        }
    }

    protected void performDetachedEntityDeletionCheck(DeleteEvent deleteEvent) {
    }

    protected void deleteTransientEntity(EventSource eventSource, Object object, boolean bl, EntityPersister entityPersister, Set set) {
        log.info("handling transient entity in delete processing");
        if (set.contains(object)) {
            log.trace("already handled transient entity; skipping");
            return;
        }
        set.add(object);
        this.cascadeBeforeDelete(eventSource, entityPersister, object, null, set);
        this.cascadeAfterDelete(eventSource, entityPersister, object, set);
    }

    protected final void deleteEntity(EventSource eventSource, Object object, EntityEntry entityEntry, boolean bl, EntityPersister entityPersister, Set set) {
        if (log.isTraceEnabled()) {
            log.trace("deleting " + MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()));
        }
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        Type[] typeArray = entityPersister.getPropertyTypes();
        Object object2 = entityEntry.getVersion();
        Object[] objectArray = entityEntry.getLoadedState() == null ? entityPersister.getPropertyValues(object, eventSource.getEntityMode()) : entityEntry.getLoadedState();
        Object[] objectArray2 = this.createDeletedState(entityPersister, objectArray, eventSource);
        entityEntry.setDeletedState(objectArray2);
        eventSource.getInterceptor().onDelete(object, entityEntry.getId(), objectArray2, entityPersister.getPropertyNames(), typeArray);
        persistenceContext.setEntryStatus(entityEntry, Status.DELETED);
        EntityKey entityKey = new EntityKey(entityEntry.getId(), entityPersister, eventSource.getEntityMode());
        this.cascadeBeforeDelete(eventSource, entityPersister, object, entityEntry, set);
        new ForeignKeys.Nullifier(object, true, false, eventSource).nullifyTransientReferences(entityEntry.getDeletedState(), typeArray);
        new Nullability(eventSource).checkNullability(entityEntry.getDeletedState(), entityPersister, true);
        persistenceContext.getNullifiableEntityKeys().add(entityKey);
        eventSource.getActionQueue().addAction(new EntityDeleteAction(entityEntry.getId(), objectArray2, object2, object, entityPersister, bl, eventSource));
        this.cascadeAfterDelete(eventSource, entityPersister, object, set);
    }

    private Object[] createDeletedState(EntityPersister entityPersister, Object[] objectArray, EventSource eventSource) {
        Type[] typeArray = entityPersister.getPropertyTypes();
        Object[] objectArray2 = new Object[typeArray.length];
        boolean[] blArray = new boolean[typeArray.length];
        Arrays.fill(blArray, true);
        TypeHelper.deepCopy(objectArray, typeArray, blArray, objectArray2, eventSource);
        return objectArray2;
    }

    protected boolean invokeDeleteLifecycle(EventSource eventSource, Object object, EntityPersister entityPersister) {
        if (entityPersister.implementsLifecycle(eventSource.getEntityMode())) {
            log.debug("calling onDelete()");
            if (((Lifecycle)object).onDelete(eventSource)) {
                log.debug("deletion vetoed by onDelete()");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeDelete(EventSource eventSource, EntityPersister entityPersister, Object object, EntityEntry entityEntry, Set set) throws HibernateException {
        CacheMode cacheMode = eventSource.getCacheMode();
        eventSource.setCacheMode(CacheMode.GET);
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.DELETE, 1, eventSource).cascade(entityPersister, object, set);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
            eventSource.setCacheMode(cacheMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterDelete(EventSource eventSource, EntityPersister entityPersister, Object object, Set set) throws HibernateException {
        CacheMode cacheMode = eventSource.getCacheMode();
        eventSource.setCacheMode(CacheMode.GET);
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.DELETE, 2, eventSource).cascade(entityPersister, object, set);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
            eventSource.setCacheMode(cacheMode);
        }
    }
}

