/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.HibernateException;
import org.hibernate.event.DirtyCheckEvent;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.def.AbstractFlushingEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDirtyCheckEventListener
extends AbstractFlushingEventListener
implements DirtyCheckEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultDirtyCheckEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDirtyCheck(DirtyCheckEvent dirtyCheckEvent) throws HibernateException {
        int n = dirtyCheckEvent.getSession().getActionQueue().numberOfCollectionRemovals();
        try {
            this.flushEverythingToExecutions(dirtyCheckEvent);
            boolean bl = dirtyCheckEvent.getSession().getActionQueue().hasAnyQueuedActions();
            log.debug(bl ? "session dirty" : "session not dirty");
            dirtyCheckEvent.setDirty(bl);
        }
        finally {
            dirtyCheckEvent.getSession().getActionQueue().clearFromFlushNeededCheck(n);
        }
    }
}

