/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.action.DelayedPostInsertIdentifier;
import org.hibernate.action.EntityUpdateAction;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.FlushEntityEvent;
import org.hibernate.event.FlushEntityEventListener;
import org.hibernate.event.def.DirtyCollectionSearchVisitor;
import org.hibernate.event.def.FlushVisitor;
import org.hibernate.event.def.WrapVisitor;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlushEntityEventListener
implements FlushEntityEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultFlushEntityEventListener.class);

    public void checkId(Object object, EntityPersister entityPersister, Serializable serializable, EntityMode entityMode, SessionImplementor sessionImplementor) throws HibernateException {
        if (serializable != null && serializable instanceof DelayedPostInsertIdentifier) {
            return;
        }
        if (entityPersister.canExtractIdOutOfEntity()) {
            Serializable serializable2 = entityPersister.getIdentifier(object, sessionImplementor);
            if (serializable == null) {
                throw new AssertionFailure("null id in " + entityPersister.getEntityName() + " entry (don't flush the Session after an exception occurs)");
            }
            if (!entityPersister.getIdentifierType().isEqual(serializable, serializable2, entityMode, sessionImplementor.getFactory())) {
                throw new HibernateException("identifier of an instance of " + entityPersister.getEntityName() + " was altered from " + serializable + " to " + serializable2);
            }
        }
    }

    private void checkNaturalId(EntityPersister entityPersister, EntityEntry entityEntry, Object[] objectArray, Object[] objectArray2, EntityMode entityMode, SessionImplementor sessionImplementor) {
        if (entityPersister.hasNaturalIdentifier() && entityEntry.getStatus() != Status.READ_ONLY) {
            Object[] objectArray3 = null;
            Type[] typeArray = entityPersister.getPropertyTypes();
            int[] nArray = entityPersister.getNaturalIdentifierProperties();
            boolean[] blArray = entityPersister.getPropertyUpdateability();
            for (int i = 0; i < nArray.length; ++i) {
                Object object;
                int n = nArray[i];
                if (blArray[n]) continue;
                if (objectArray2 == null) {
                    if (objectArray3 == null) {
                        objectArray3 = sessionImplementor.getPersistenceContext().getNaturalIdSnapshot(entityEntry.getId(), entityPersister);
                    }
                    object = objectArray3[i];
                } else {
                    object = objectArray2[n];
                }
                if (typeArray[n].isEqual(objectArray[n], object, entityMode)) continue;
                throw new HibernateException("immutable natural identifier of an instance of " + entityPersister.getEntityName() + " was altered");
            }
        }
    }

    public void onFlushEntity(FlushEntityEvent flushEntityEvent) throws HibernateException {
        Object object = flushEntityEvent.getEntity();
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EventSource eventSource = flushEntityEvent.getSession();
        EntityPersister entityPersister = entityEntry.getPersister();
        Status status = entityEntry.getStatus();
        EntityMode entityMode = eventSource.getEntityMode();
        Type[] typeArray = entityPersister.getPropertyTypes();
        boolean bl = entityEntry.requiresDirtyCheck(object);
        Object[] objectArray = this.getValues(object, entityEntry, entityMode, bl, eventSource);
        flushEntityEvent.setPropertyValues(objectArray);
        boolean bl2 = this.wrapCollections(eventSource, entityPersister, typeArray, objectArray);
        if (this.isUpdateNecessary(flushEntityEvent, bl)) {
            boolean bl3 = bl2 = this.scheduleUpdate(flushEntityEvent) || bl2;
        }
        if (status != Status.DELETED) {
            if (bl2) {
                entityPersister.setPropertyValues(object, objectArray, entityMode);
            }
            if (entityPersister.hasCollections()) {
                new FlushVisitor(eventSource, object).processEntityPropertyValues(objectArray, typeArray);
            }
        }
    }

    private Object[] getValues(Object object, EntityEntry entityEntry, EntityMode entityMode, boolean bl, SessionImplementor sessionImplementor) {
        Object[] objectArray;
        Object[] objectArray2 = entityEntry.getLoadedState();
        Status status = entityEntry.getStatus();
        EntityPersister entityPersister = entityEntry.getPersister();
        if (status == Status.DELETED) {
            objectArray = entityEntry.getDeletedState();
        } else if (!bl && objectArray2 != null) {
            objectArray = objectArray2;
        } else {
            this.checkId(object, entityPersister, entityEntry.getId(), entityMode, sessionImplementor);
            objectArray = entityPersister.getPropertyValues(object, entityMode);
            this.checkNaturalId(entityPersister, entityEntry, objectArray, objectArray2, entityMode, sessionImplementor);
        }
        return objectArray;
    }

    private boolean wrapCollections(EventSource eventSource, EntityPersister entityPersister, Type[] typeArray, Object[] objectArray) {
        if (entityPersister.hasCollections()) {
            WrapVisitor wrapVisitor = new WrapVisitor(eventSource);
            wrapVisitor.processEntityPropertyValues(objectArray, typeArray);
            return wrapVisitor.isSubstitutionRequired();
        }
        return false;
    }

    private boolean isUpdateNecessary(FlushEntityEvent flushEntityEvent, boolean bl) {
        Status status = flushEntityEvent.getEntityEntry().getStatus();
        if (bl || status == Status.DELETED) {
            this.dirtyCheck(flushEntityEvent);
            if (this.isUpdateNecessary(flushEntityEvent)) {
                return true;
            }
            FieldInterceptionHelper.clearDirty(flushEntityEvent.getEntity());
            return false;
        }
        return this.hasDirtyCollections(flushEntityEvent, flushEntityEvent.getEntityEntry().getPersister(), status);
    }

    private boolean scheduleUpdate(FlushEntityEvent flushEntityEvent) {
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EventSource eventSource = flushEntityEvent.getSession();
        Object object = flushEntityEvent.getEntity();
        Status status = entityEntry.getStatus();
        EntityMode entityMode = eventSource.getEntityMode();
        EntityPersister entityPersister = entityEntry.getPersister();
        Object[] objectArray = flushEntityEvent.getPropertyValues();
        if (log.isTraceEnabled()) {
            if (status == Status.DELETED) {
                if (!entityPersister.isMutable()) {
                    log.trace("Updating immutable, deleted entity: " + MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()));
                } else if (!entityEntry.isModifiableEntity()) {
                    log.trace("Updating non-modifiable, deleted entity: " + MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()));
                } else {
                    log.trace("Updating deleted entity: " + MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()));
                }
            } else {
                log.trace("Updating entity: " + MessageHelper.infoString(entityPersister, entityEntry.getId(), eventSource.getFactory()));
            }
        }
        boolean bl = !entityEntry.isBeingReplicated() ? this.handleInterception(flushEntityEvent) : false;
        this.validate(object, entityPersister, status, entityMode);
        Object object2 = this.getNextVersion(flushEntityEvent);
        int[] nArray = flushEntityEvent.getDirtyProperties();
        if (flushEntityEvent.isDirtyCheckPossible() && nArray == null) {
            if (!bl && !flushEntityEvent.hasDirtyCollection()) {
                throw new AssertionFailure("dirty, but no dirty properties");
            }
            nArray = ArrayHelper.EMPTY_INT_ARRAY;
        }
        new Nullability(eventSource).checkNullability(objectArray, entityPersister, true);
        eventSource.getActionQueue().addAction(new EntityUpdateAction(entityEntry.getId(), objectArray, nArray, flushEntityEvent.hasDirtyCollection(), status == Status.DELETED && !entityEntry.isModifiableEntity() ? entityPersister.getPropertyValues(object, entityMode) : entityEntry.getLoadedState(), entityEntry.getVersion(), object2, object, entityEntry.getRowId(), entityPersister, eventSource));
        return bl;
    }

    protected void validate(Object object, EntityPersister entityPersister, Status status, EntityMode entityMode) {
        if (status == Status.MANAGED && entityPersister.implementsValidatable(entityMode)) {
            ((Validatable)object).validate();
        }
    }

    protected boolean handleInterception(FlushEntityEvent flushEntityEvent) {
        Object[] objectArray;
        EventSource eventSource = flushEntityEvent.getSession();
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EntityPersister entityPersister = entityEntry.getPersister();
        Object object = flushEntityEvent.getEntity();
        boolean bl = this.invokeInterceptor(eventSource, object, entityEntry, objectArray = flushEntityEvent.getPropertyValues(), entityPersister);
        if (bl && flushEntityEvent.isDirtyCheckPossible() && !flushEntityEvent.isDirtyCheckHandledByInterceptor()) {
            int[] nArray = flushEntityEvent.hasDatabaseSnapshot() ? entityPersister.findModified(flushEntityEvent.getDatabaseSnapshot(), objectArray, object, eventSource) : entityPersister.findDirty(objectArray, entityEntry.getLoadedState(), object, eventSource);
            flushEntityEvent.setDirtyProperties(nArray);
        }
        return bl;
    }

    protected boolean invokeInterceptor(SessionImplementor sessionImplementor, Object object, EntityEntry entityEntry, Object[] objectArray, EntityPersister entityPersister) {
        return sessionImplementor.getInterceptor().onFlushDirty(object, entityEntry.getId(), objectArray, entityEntry.getLoadedState(), entityPersister.getPropertyNames(), entityPersister.getPropertyTypes());
    }

    private Object getNextVersion(FlushEntityEvent flushEntityEvent) throws HibernateException {
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EntityPersister entityPersister = entityEntry.getPersister();
        if (entityPersister.isVersioned()) {
            Object[] objectArray = flushEntityEvent.getPropertyValues();
            if (entityEntry.isBeingReplicated()) {
                return Versioning.getVersion(objectArray, entityPersister);
            }
            int[] nArray = flushEntityEvent.getDirtyProperties();
            boolean bl = this.isVersionIncrementRequired(flushEntityEvent, entityEntry, entityPersister, nArray);
            Object object = bl ? Versioning.increment(entityEntry.getVersion(), entityPersister.getVersionType(), flushEntityEvent.getSession()) : entityEntry.getVersion();
            Versioning.setVersion(objectArray, object, entityPersister);
            return object;
        }
        return null;
    }

    private boolean isVersionIncrementRequired(FlushEntityEvent flushEntityEvent, EntityEntry entityEntry, EntityPersister entityPersister, int[] nArray) {
        boolean bl = entityEntry.getStatus() != Status.DELETED && (nArray == null || Versioning.isVersionIncrementRequired(nArray, flushEntityEvent.hasDirtyCollection(), entityPersister.getPropertyVersionability()));
        return bl;
    }

    protected final boolean isUpdateNecessary(FlushEntityEvent flushEntityEvent) throws HibernateException {
        EntityPersister entityPersister = flushEntityEvent.getEntityEntry().getPersister();
        Status status = flushEntityEvent.getEntityEntry().getStatus();
        if (!flushEntityEvent.isDirtyCheckPossible()) {
            return true;
        }
        int[] nArray = flushEntityEvent.getDirtyProperties();
        if (nArray != null && nArray.length != 0) {
            return true;
        }
        return this.hasDirtyCollections(flushEntityEvent, entityPersister, status);
    }

    private boolean hasDirtyCollections(FlushEntityEvent flushEntityEvent, EntityPersister entityPersister, Status status) {
        if (this.isCollectionDirtyCheckNecessary(entityPersister, status)) {
            DirtyCollectionSearchVisitor dirtyCollectionSearchVisitor = new DirtyCollectionSearchVisitor(flushEntityEvent.getSession(), entityPersister.getPropertyVersionability());
            dirtyCollectionSearchVisitor.processEntityPropertyValues(flushEntityEvent.getPropertyValues(), entityPersister.getPropertyTypes());
            boolean bl = dirtyCollectionSearchVisitor.wasDirtyCollectionFound();
            flushEntityEvent.setHasDirtyCollection(bl);
            return bl;
        }
        return false;
    }

    private boolean isCollectionDirtyCheckNecessary(EntityPersister entityPersister, Status status) {
        return (status == Status.MANAGED || status == Status.READ_ONLY) && entityPersister.isVersioned() && entityPersister.hasCollections();
    }

    protected void dirtyCheck(FlushEntityEvent flushEntityEvent) throws HibernateException {
        boolean bl;
        boolean bl2;
        Object object = flushEntityEvent.getEntity();
        Object[] objectArray = flushEntityEvent.getPropertyValues();
        EventSource eventSource = flushEntityEvent.getSession();
        EntityEntry entityEntry = flushEntityEvent.getEntityEntry();
        EntityPersister entityPersister = entityEntry.getPersister();
        Serializable serializable = entityEntry.getId();
        Object[] objectArray2 = entityEntry.getLoadedState();
        int[] nArray = eventSource.getInterceptor().findDirty(object, serializable, objectArray, objectArray2, entityPersister.getPropertyNames(), entityPersister.getPropertyTypes());
        flushEntityEvent.setDatabaseSnapshot(null);
        if (nArray == null) {
            bl2 = false;
            boolean bl3 = bl = objectArray2 == null;
            if (!bl) {
                nArray = entityPersister.findDirty(objectArray, objectArray2, object, eventSource);
            } else if (entityEntry.getStatus() == Status.DELETED && !flushEntityEvent.getEntityEntry().isModifiableEntity()) {
                if (objectArray != entityEntry.getDeletedState()) {
                    throw new IllegalStateException("Entity has status Status.DELETED but values != entry.getDeletedState");
                }
                Object[] objectArray3 = entityPersister.getPropertyValues(flushEntityEvent.getEntity(), flushEntityEvent.getSession().getEntityMode());
                nArray = entityPersister.findDirty(entityEntry.getDeletedState(), objectArray3, object, eventSource);
                bl = false;
            } else {
                Object[] objectArray4 = this.getDatabaseSnapshot(eventSource, entityPersister, serializable);
                if (objectArray4 != null) {
                    nArray = entityPersister.findModified(objectArray4, objectArray, object, eventSource);
                    bl = false;
                    flushEntityEvent.setDatabaseSnapshot(objectArray4);
                }
            }
        } else {
            bl = false;
            bl2 = true;
        }
        this.logDirtyProperties(serializable, nArray, entityPersister);
        flushEntityEvent.setDirtyProperties(nArray);
        flushEntityEvent.setDirtyCheckHandledByInterceptor(bl2);
        flushEntityEvent.setDirtyCheckPossible(!bl);
    }

    private void logDirtyProperties(Serializable serializable, int[] nArray, EntityPersister entityPersister) {
        if (log.isTraceEnabled() && nArray != null && nArray.length > 0) {
            String[] stringArray = entityPersister.getPropertyNames();
            String[] stringArray2 = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                stringArray2[i] = stringArray[nArray[i]];
            }
            log.trace("Found dirty properties [{}] : {}", (Object)MessageHelper.infoString(entityPersister.getEntityName(), serializable), (Object)stringArray2);
        }
    }

    private Object[] getDatabaseSnapshot(SessionImplementor sessionImplementor, EntityPersister entityPersister, Serializable serializable) {
        if (entityPersister.isSelectBeforeUpdateRequired()) {
            Object[] objectArray = sessionImplementor.getPersistenceContext().getDatabaseSnapshot(serializable, entityPersister);
            if (objectArray == null) {
                if (sessionImplementor.getFactory().getStatistics().isStatisticsEnabled()) {
                    sessionImplementor.getFactory().getStatisticsImplementor().optimisticFailure(entityPersister.getEntityName());
                }
                throw new StaleObjectStateException(entityPersister.getEntityName(), serializable);
            }
            return objectArray;
        }
        EntityKey entityKey = new EntityKey(serializable, entityPersister, sessionImplementor.getEntityMode());
        return sessionImplementor.getPersistenceContext().getCachedDatabaseSnapshot(entityKey);
    }
}

