/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PropertyValueException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.TransientObjectException;
import org.hibernate.WrongClassException;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.event.def.EventCache;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMergeEventListener
extends AbstractSaveEventListener
implements MergeEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultMergeEventListener.class);

    protected Map getMergeMap(Object object) {
        return ((EventCache)object).invertMap();
    }

    public void onMerge(MergeEvent mergeEvent) throws HibernateException {
        EventCache eventCache = new EventCache();
        this.onMerge(mergeEvent, eventCache);
        EventCache eventCache2 = this.getTransientCopyCache(mergeEvent, eventCache);
        if (eventCache2.size() > 0) {
            this.retryMergeTransientEntities(mergeEvent, eventCache2, eventCache, true);
            eventCache2 = this.getTransientCopyCache(mergeEvent, eventCache);
            if (eventCache2.size() > 0) {
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = eventCache2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next().getKey();
                    String string = mergeEvent.getSession().guessEntityName(k);
                    hashSet.add(string);
                    log.trace("transient instance could not be processed by merge when checking nullability: " + string + "[" + k + "]");
                }
                if (this.isNullabilityCheckedGlobal(mergeEvent.getSession())) {
                    throw new TransientObjectException("one or more objects is an unsaved transient instance - save transient instance(s) before merging: " + hashSet);
                }
                log.trace("retry saving transient instances without checking nullability");
                this.retryMergeTransientEntities(mergeEvent, eventCache2, eventCache, false);
            }
        }
        eventCache.clear();
        eventCache = null;
    }

    protected EventCache getTransientCopyCache(MergeEvent mergeEvent, EventCache eventCache) {
        EventCache eventCache2 = new EventCache();
        for (Map.Entry entry : eventCache.entrySet()) {
            EntityEntry entityEntry;
            Object k = entry.getKey();
            Object object = entry.getValue();
            if (object instanceof HibernateProxy) {
                object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
            }
            if ((entityEntry = mergeEvent.getSession().getPersistenceContext().getEntry(object)) == null) {
                log.trace("transient instance could not be processed by merge: " + mergeEvent.getSession().guessEntityName(object) + "[" + k + "]");
                if (!this.isNullabilityCheckedGlobal(mergeEvent.getSession())) continue;
                throw new TransientObjectException("object is an unsaved transient instance - save the transient instance before merging: " + mergeEvent.getSession().guessEntityName(object));
            }
            if (entityEntry.getStatus() == Status.SAVING) {
                eventCache2.put(k, object, eventCache.isOperatedOn(k));
                continue;
            }
            if (entityEntry.getStatus() == Status.MANAGED || entityEntry.getStatus() == Status.READ_ONLY) continue;
            throw new AssertionFailure("Merged entity does not have status set to MANAGED or READ_ONLY; " + object + " status=" + entityEntry.getStatus());
        }
        return eventCache2;
    }

    protected void retryMergeTransientEntities(MergeEvent mergeEvent, Map map, EventCache eventCache, boolean bl) {
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            Object v = map.get(k);
            EntityEntry entityEntry = mergeEvent.getSession().getPersistenceContext().getEntry(v);
            this.mergeTransientEntity(k, entityEntry.getEntityName(), k == mergeEvent.getEntity() ? mergeEvent.getRequestedId() : entityEntry.getId(), mergeEvent.getSession(), eventCache, bl);
        }
    }

    public void onMerge(MergeEvent mergeEvent, Map map) throws HibernateException {
        EventCache eventCache = (EventCache)map;
        EventSource eventSource = mergeEvent.getSession();
        Object object = mergeEvent.getOriginal();
        if (object != null) {
            Object object2;
            if (object instanceof HibernateProxy) {
                LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
                if (lazyInitializer.isUninitialized()) {
                    log.trace("ignoring uninitialized proxy");
                    mergeEvent.setResult(eventSource.load(lazyInitializer.getEntityName(), lazyInitializer.getIdentifier()));
                    return;
                }
                object2 = lazyInitializer.getImplementation();
            } else {
                object2 = object;
            }
            if (eventCache.containsKey(object2) && eventCache.isOperatedOn(object2)) {
                log.trace("already in merge process");
                mergeEvent.setResult(object2);
            } else {
                EntityPersister entityPersister;
                Serializable serializable;
                if (eventCache.containsKey(object2)) {
                    log.trace("already in copyCache; setting in merge process");
                    eventCache.setOperatedOn(object2, true);
                }
                mergeEvent.setEntity(object2);
                int n = -1;
                EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object2);
                if (entityEntry == null && (serializable = (entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object2)).getIdentifier(object2, eventSource)) != null) {
                    EntityKey entityKey = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
                    Object object3 = eventSource.getPersistenceContext().getEntity(entityKey);
                    entityEntry = eventSource.getPersistenceContext().getEntry(object3);
                    if (entityEntry != null) {
                        n = 2;
                    }
                }
                if (n == -1) {
                    n = this.getEntityState(object2, mergeEvent.getEntityName(), entityEntry, eventSource);
                }
                switch (n) {
                    case 2: {
                        this.entityIsDetached(mergeEvent, eventCache);
                        break;
                    }
                    case 1: {
                        this.entityIsTransient(mergeEvent, eventCache);
                        break;
                    }
                    case 0: {
                        this.entityIsPersistent(mergeEvent, eventCache);
                        break;
                    }
                    default: {
                        throw new ObjectDeletedException("deleted instance passed to merge", null, this.getLoggableName(mergeEvent.getEntityName(), object2));
                    }
                }
            }
        }
    }

    protected void entityIsPersistent(MergeEvent mergeEvent, Map map) {
        log.trace("ignoring persistent instance");
        Object object = mergeEvent.getEntity();
        EventSource eventSource = mergeEvent.getSession();
        EntityPersister entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object);
        ((EventCache)map).put(object, object, true);
        this.cascadeOnMerge(eventSource, entityPersister, object, map);
        this.copyValues(entityPersister, object, object, eventSource, map);
        mergeEvent.setResult(object);
    }

    protected void entityIsTransient(MergeEvent mergeEvent, Map map) {
        log.trace("merging transient instance");
        Object object = mergeEvent.getEntity();
        EventSource eventSource = mergeEvent.getSession();
        EntityPersister entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object);
        String string = entityPersister.getEntityName();
        mergeEvent.setResult(this.mergeTransientEntity(object, string, mergeEvent.getRequestedId(), eventSource, map, true));
    }

    protected Object mergeTransientEntity(Object object, String string, Serializable serializable, EventSource eventSource, Map map) {
        return this.mergeTransientEntity(object, string, serializable, eventSource, map, true);
    }

    private Object mergeTransientEntity(Object object, String string, Serializable serializable, EventSource eventSource, Map map, boolean bl) {
        Serializable serializable2;
        log.trace("merging transient instance");
        EntityPersister entityPersister = eventSource.getEntityPersister(string, object);
        Serializable serializable3 = serializable2 = entityPersister.hasIdentifierProperty() ? entityPersister.getIdentifier(object, eventSource) : null;
        if (map.containsKey(object)) {
            entityPersister.setIdentifier(map.get(object), serializable2, eventSource);
        } else {
            ((EventCache)map).put(object, eventSource.instantiate(entityPersister, serializable2), true);
        }
        Object v = map.get(object);
        super.cascadeBeforeSave(eventSource, entityPersister, object, map);
        this.copyValues(entityPersister, object, v, eventSource, map, ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT);
        try {
            this.saveTransientEntity(v, string, serializable, eventSource, map, bl);
        }
        catch (PropertyValueException propertyValueException) {
            String string2 = propertyValueException.getPropertyName();
            Object object2 = entityPersister.getPropertyValue(v, string2, eventSource.getEntityMode());
            Object object3 = entityPersister.getPropertyValue(object, string2, eventSource.getEntityMode());
            Type type = entityPersister.getPropertyType(string2);
            EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(v);
            if (object2 == null || !type.isEntityType()) {
                log.trace("property '" + entityEntry.getEntityName() + "." + string2 + "' is null or not an entity; " + string2 + " =[" + object2 + "]");
                if (this.isNullabilityCheckedGlobal(eventSource)) {
                    throw propertyValueException;
                }
                this.saveTransientEntity(v, string, serializable, eventSource, map, false);
            }
            if (!map.containsKey(object3)) {
                log.trace("property '" + entityEntry.getEntityName() + "." + string2 + "' from original entity is not in copyCache; " + string2 + " =[" + object3 + "]");
                if (this.isNullabilityCheckedGlobal(eventSource)) {
                    throw propertyValueException;
                }
                this.saveTransientEntity(v, string, serializable, eventSource, map, false);
            }
            if (((EventCache)map).isOperatedOn(object3)) {
                log.trace("property '" + entityEntry.getEntityName() + "." + string2 + "' from original entity is in copyCache and is in the process of being merged; " + string2 + " =[" + object3 + "]");
            }
            log.trace("property '" + entityEntry.getEntityName() + "." + string2 + "' from original entity is in copyCache and is not in the process of being merged; " + string2 + " =[" + object3 + "]");
        }
        super.cascadeAfterSave(eventSource, entityPersister, object, map);
        this.copyValues(entityPersister, object, v, eventSource, map, ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        return v;
    }

    private boolean isNullabilityCheckedGlobal(EventSource eventSource) {
        return eventSource.getFactory().getSettings().isCheckNullability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTransientEntity(Object object, String string, Serializable serializable, EventSource eventSource, Map map, boolean bl) {
        boolean bl2 = eventSource.getFactory().getSettings().isCheckNullability();
        try {
            eventSource.getFactory().getSettings().setCheckNullability(bl);
            if (serializable == null) {
                this.saveWithGeneratedId(object, string, map, eventSource, false);
            } else {
                this.saveWithRequestedId(object, serializable, string, map, eventSource);
            }
        }
        finally {
            eventSource.getFactory().getSettings().setCheckNullability(bl2);
        }
    }

    protected void entityIsDetached(MergeEvent mergeEvent, Map map) {
        Object object;
        log.trace("merging detached instance");
        Object object2 = mergeEvent.getEntity();
        EventSource eventSource = mergeEvent.getSession();
        EntityPersister entityPersister = eventSource.getEntityPersister(mergeEvent.getEntityName(), object2);
        String string = entityPersister.getEntityName();
        Serializable serializable = mergeEvent.getRequestedId();
        if (serializable == null) {
            serializable = entityPersister.getIdentifier(object2, eventSource);
        } else {
            object = entityPersister.getIdentifier(object2, eventSource);
            if (!entityPersister.getIdentifierType().isEqual(serializable, object, eventSource.getEntityMode(), eventSource.getFactory())) {
                throw new HibernateException("merge requested with id not matching id of passed entity");
            }
        }
        object = eventSource.getFetchProfile();
        eventSource.setFetchProfile("merge");
        Serializable serializable2 = (Serializable)entityPersister.getIdentifierType().deepCopy(serializable, eventSource.getEntityMode(), eventSource.getFactory());
        Object object3 = eventSource.get(string, serializable2);
        eventSource.setFetchProfile((String)object);
        if (object3 == null) {
            this.entityIsTransient(mergeEvent, map);
        } else {
            ((EventCache)map).put(object2, object3, true);
            Object object4 = eventSource.getPersistenceContext().unproxy(object3);
            if (object4 == object2) {
                throw new AssertionFailure("entity was not detached");
            }
            if (!eventSource.getEntityName(object4).equals(string)) {
                throw new WrongClassException("class of the given object did not match class of persistent copy", mergeEvent.getRequestedId(), string);
            }
            if (this.isVersionChanged(object2, eventSource, entityPersister, object4)) {
                if (eventSource.getFactory().getStatistics().isStatisticsEnabled()) {
                    eventSource.getFactory().getStatisticsImplementor().optimisticFailure(string);
                }
                throw new StaleObjectStateException(string, serializable);
            }
            this.cascadeOnMerge(eventSource, entityPersister, object2, map);
            this.copyValues(entityPersister, object2, object4, eventSource, map);
            this.markInterceptorDirty(object2, object4);
            mergeEvent.setResult(object3);
        }
    }

    private void markInterceptorDirty(Object object, Object object2) {
        FieldInterceptor fieldInterceptor;
        if (FieldInterceptionHelper.isInstrumented(object) && (fieldInterceptor = FieldInterceptionHelper.extractFieldInterceptor(object2)) != null) {
            fieldInterceptor.dirty();
        }
    }

    private boolean isVersionChanged(Object object, EventSource eventSource, EntityPersister entityPersister, Object object2) {
        if (!entityPersister.isVersioned()) {
            return false;
        }
        boolean bl = !entityPersister.getVersionType().isSame(entityPersister.getVersion(object2, eventSource.getEntityMode()), entityPersister.getVersion(object, eventSource.getEntityMode()), eventSource.getEntityMode());
        return bl && this.existsInDatabase(object2, eventSource, entityPersister);
    }

    private boolean existsInDatabase(Object object, EventSource eventSource, EntityPersister entityPersister) {
        Serializable serializable;
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
        if (entityEntry == null && (serializable = entityPersister.getIdentifier(object, eventSource)) != null) {
            EntityKey entityKey = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            Object object2 = eventSource.getPersistenceContext().getEntity(entityKey);
            entityEntry = eventSource.getPersistenceContext().getEntry(object2);
        }
        if (entityEntry == null) {
            return false;
        }
        return entityEntry.isExistsInDatabase();
    }

    protected void copyValues(EntityPersister entityPersister, Object object, Object object2, SessionImplementor sessionImplementor, Map map) {
        Object[] objectArray = TypeHelper.replace(entityPersister.getPropertyValues(object, sessionImplementor.getEntityMode()), entityPersister.getPropertyValues(object2, sessionImplementor.getEntityMode()), entityPersister.getPropertyTypes(), sessionImplementor, object2, map);
        entityPersister.setPropertyValues(object2, objectArray, sessionImplementor.getEntityMode());
    }

    protected void copyValues(EntityPersister entityPersister, Object object, Object object2, SessionImplementor sessionImplementor, Map map, ForeignKeyDirection foreignKeyDirection) {
        Object[] objectArray = foreignKeyDirection == ForeignKeyDirection.FOREIGN_KEY_TO_PARENT ? TypeHelper.replaceAssociations(entityPersister.getPropertyValues(object, sessionImplementor.getEntityMode()), entityPersister.getPropertyValues(object2, sessionImplementor.getEntityMode()), entityPersister.getPropertyTypes(), sessionImplementor, object2, map, foreignKeyDirection) : TypeHelper.replace(entityPersister.getPropertyValues(object, sessionImplementor.getEntityMode()), entityPersister.getPropertyValues(object2, sessionImplementor.getEntityMode()), entityPersister.getPropertyTypes(), sessionImplementor, object2, map, foreignKeyDirection);
        entityPersister.setPropertyValues(object2, objectArray, sessionImplementor.getEntityMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeOnMerge(EventSource eventSource, EntityPersister entityPersister, Object object, Map map) {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 0, eventSource).cascade(entityPersister, object, map);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.MERGE;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.FALSE;
    }

    protected void cascadeAfterSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
    }

    protected void cascadeBeforeSave(EventSource eventSource, EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
    }
}

