/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.PersistentObjectException;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.EventSource;
import org.hibernate.event.PersistEvent;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.util.IdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistEventListener
extends AbstractSaveEventListener
implements PersistEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultPersistEventListener.class);

    public void onPersist(PersistEvent persistEvent) throws HibernateException {
        this.onPersist(persistEvent, IdentityMap.instantiate(10));
    }

    public void onPersist(PersistEvent persistEvent, Map map) throws HibernateException {
        EntityPersister entityPersister;
        Object object;
        Object object2;
        EventSource eventSource = persistEvent.getSession();
        Object object3 = persistEvent.getObject();
        if (object3 instanceof HibernateProxy) {
            object2 = ((HibernateProxy)object3).getHibernateLazyInitializer();
            if (object2.isUninitialized()) {
                if (object2.getSession() == eventSource) {
                    return;
                }
                throw new PersistentObjectException("uninitialized proxy passed to persist()");
            }
            object = object2.getImplementation();
        } else {
            object = object3;
        }
        if (persistEvent.getEntityName() != null) {
            object2 = persistEvent.getEntityName();
        } else {
            object2 = eventSource.bestGuessEntityName(object);
            persistEvent.setEntityName((String)object2);
        }
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object);
        int n = this.getEntityState(object, (String)object2, entityEntry, eventSource);
        if (n == 2 && ForeignGenerator.class.isInstance((entityPersister = eventSource.getFactory().getEntityPersister((String)object2)).getIdentifierGenerator())) {
            if (log.isDebugEnabled() && entityPersister.getIdentifier(object, eventSource) != null) {
                log.debug("Resetting entity id attribute to null for foreign generator");
            }
            entityPersister.setIdentifier(object, null, eventSource);
            n = this.getEntityState(object, (String)object2, entityEntry, eventSource);
        }
        switch (n) {
            case 2: {
                throw new PersistentObjectException("detached entity passed to persist: " + this.getLoggableName(persistEvent.getEntityName(), object));
            }
            case 0: {
                this.entityIsPersistent(persistEvent, map);
                break;
            }
            case 1: {
                this.entityIsTransient(persistEvent, map);
                break;
            }
            default: {
                throw new ObjectDeletedException("deleted entity passed to persist", null, this.getLoggableName(persistEvent.getEntityName(), object));
            }
        }
    }

    protected void entityIsPersistent(PersistEvent persistEvent, Map map) {
        log.trace("ignoring persistent instance");
        EventSource eventSource = persistEvent.getSession();
        Object object = eventSource.getPersistenceContext().unproxy(persistEvent.getObject());
        EntityPersister entityPersister = eventSource.getEntityPersister(persistEvent.getEntityName(), object);
        if (map.put(object, object) == null) {
            this.cascadeBeforeSave(eventSource, entityPersister, object, map);
            this.cascadeAfterSave(eventSource, entityPersister, object, map);
        }
    }

    protected void entityIsTransient(PersistEvent persistEvent, Map map) throws HibernateException {
        log.trace("saving transient instance");
        EventSource eventSource = persistEvent.getSession();
        Object object = eventSource.getPersistenceContext().unproxy(persistEvent.getObject());
        if (map.put(object, object) == null) {
            this.saveWithGeneratedId(object, persistEvent.getEntityName(), map, eventSource, false);
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.PERSIST;
    }

    protected Boolean getAssumedUnsaved() {
        return Boolean.TRUE;
    }
}

