/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.AssertionFailure;
import org.hibernate.LockMode;
import org.hibernate.action.EntityIncrementVersionProcess;
import org.hibernate.action.EntityVerifyVersionProcess;
import org.hibernate.classic.Lifecycle;
import org.hibernate.engine.EntityEntry;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class DefaultPostLoadEventListener
implements PostLoadEventListener {
    public void onPostLoad(PostLoadEvent postLoadEvent) {
        Object object = postLoadEvent.getEntity();
        EntityEntry entityEntry = postLoadEvent.getSession().getPersistenceContext().getEntry(object);
        if (entityEntry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        LockMode lockMode = entityEntry.getLockMode();
        if (LockMode.PESSIMISTIC_FORCE_INCREMENT.equals(lockMode)) {
            EntityPersister entityPersister = entityEntry.getPersister();
            Object object2 = entityPersister.forceVersionIncrement(entityEntry.getId(), entityEntry.getVersion(), postLoadEvent.getSession());
            entityEntry.forceLocked(object, object2);
        } else if (LockMode.OPTIMISTIC_FORCE_INCREMENT.equals(lockMode)) {
            EntityIncrementVersionProcess entityIncrementVersionProcess = new EntityIncrementVersionProcess(object, entityEntry);
            postLoadEvent.getSession().getActionQueue().registerProcess(entityIncrementVersionProcess);
        } else if (LockMode.OPTIMISTIC.equals(lockMode)) {
            EntityVerifyVersionProcess entityVerifyVersionProcess = new EntityVerifyVersionProcess(object, entityEntry);
            postLoadEvent.getSession().getActionQueue().registerProcess(entityVerifyVersionProcess);
        }
        if (postLoadEvent.getPersister().implementsLifecycle(postLoadEvent.getSession().getEntityMode())) {
            ((Lifecycle)postLoadEvent.getEntity()).onLoad(postLoadEvent.getSession(), postLoadEvent.getId());
        }
    }
}

