/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.PersistentObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.CacheKey;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.RefreshEvent;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.def.EvictVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.hibernate.util.IdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRefreshEventListener
implements RefreshEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultRefreshEventListener.class);

    public void onRefresh(RefreshEvent refreshEvent) throws HibernateException {
        this.onRefresh(refreshEvent, IdentityMap.instantiate(10));
    }

    public void onRefresh(RefreshEvent refreshEvent, Map map) {
        Object object;
        Serializable serializable;
        EntityPersister entityPersister;
        boolean bl;
        EventSource eventSource = refreshEvent.getSession();
        boolean bl2 = bl = !eventSource.contains(refreshEvent.getObject());
        if (eventSource.getPersistenceContext().reassociateIfUninitializedProxy(refreshEvent.getObject())) {
            if (bl) {
                eventSource.setReadOnly(refreshEvent.getObject(), eventSource.isDefaultReadOnly());
            }
            return;
        }
        Object object2 = eventSource.getPersistenceContext().unproxyAndReassociate(refreshEvent.getObject());
        if (map.containsKey(object2)) {
            log.trace("already refreshed");
            return;
        }
        EntityEntry entityEntry = eventSource.getPersistenceContext().getEntry(object2);
        if (entityEntry == null) {
            entityPersister = eventSource.getEntityPersister(null, object2);
            serializable = entityPersister.getIdentifier(object2, refreshEvent.getSession());
            if (log.isTraceEnabled()) {
                log.trace("refreshing transient " + MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
            }
            object = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            if (eventSource.getPersistenceContext().getEntry(object) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the Session: " + MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("refreshing " + MessageHelper.infoString(entityEntry.getPersister(), entityEntry.getId(), eventSource.getFactory()));
            }
            if (!entityEntry.isExistsInDatabase()) {
                throw new HibernateException("this instance does not yet exist as a row in the database");
            }
            entityPersister = entityEntry.getPersister();
            serializable = entityEntry.getId();
        }
        map.put(object2, object2);
        new Cascade(CascadingAction.REFRESH, 0, eventSource).cascade(entityPersister, object2, map);
        if (entityEntry != null) {
            object = new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            eventSource.getPersistenceContext().removeEntity((EntityKey)object);
            if (entityPersister.hasCollections()) {
                new EvictVisitor(eventSource).process(object2, entityPersister);
            }
        }
        if (entityPersister.hasCache()) {
            object = new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), eventSource.getEntityMode(), eventSource.getFactory());
            entityPersister.getCacheAccessStrategy().evict(object);
        }
        this.evictCachedCollections(entityPersister, serializable, eventSource.getFactory());
        object = eventSource.getFetchProfile();
        eventSource.setFetchProfile("refresh");
        Object object3 = entityPersister.load(serializable, object2, refreshEvent.getLockOptions(), (SessionImplementor)eventSource);
        if (object3 != null) {
            if (!entityPersister.isMutable()) {
                eventSource.setReadOnly(object3, true);
            } else {
                eventSource.setReadOnly(object3, entityEntry == null ? eventSource.isDefaultReadOnly() : entityEntry.isReadOnly());
            }
        }
        eventSource.setFetchProfile((String)object);
        UnresolvableObjectException.throwIfNull(object3, serializable, entityPersister.getEntityName());
    }

    private void evictCachedCollections(EntityPersister entityPersister, Serializable serializable, SessionFactoryImplementor sessionFactoryImplementor) {
        this.evictCachedCollections(entityPersister.getPropertyTypes(), serializable, sessionFactoryImplementor);
    }

    private void evictCachedCollections(Type[] typeArray, Serializable serializable, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        for (int i = 0; i < typeArray.length; ++i) {
            if (typeArray[i].isCollectionType()) {
                sessionFactoryImplementor.evictCollection(((CollectionType)typeArray[i]).getRole(), serializable);
                continue;
            }
            if (!typeArray[i].isComponentType()) continue;
            CompositeType compositeType = (CompositeType)typeArray[i];
            this.evictCachedCollections(compositeType.getSubtypes(), serializable, sessionFactoryImplementor);
        }
    }
}

