/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ReplicationMode;
import org.hibernate.TransientObjectException;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.EventSource;
import org.hibernate.event.ReplicateEvent;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.def.AbstractSaveEventListener;
import org.hibernate.event.def.OnReplicateVisitor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReplicateEventListener
extends AbstractSaveEventListener
implements ReplicateEventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultReplicateEventListener.class);

    public void onReplicate(ReplicateEvent replicateEvent) {
        EventSource eventSource = replicateEvent.getSession();
        if (eventSource.getPersistenceContext().reassociateIfUninitializedProxy(replicateEvent.getObject())) {
            log.trace("uninitialized proxy passed to replicate()");
            return;
        }
        Object object = eventSource.getPersistenceContext().unproxyAndReassociate(replicateEvent.getObject());
        if (eventSource.getPersistenceContext().isEntryFor(object)) {
            log.trace("ignoring persistent instance passed to replicate()");
            return;
        }
        EntityPersister entityPersister = eventSource.getEntityPersister(replicateEvent.getEntityName(), object);
        Serializable serializable = entityPersister.getIdentifier(object, eventSource);
        if (serializable == null) {
            throw new TransientObjectException("instance with null id passed to replicate()");
        }
        ReplicationMode replicationMode = replicateEvent.getReplicationMode();
        Object object2 = replicationMode == ReplicationMode.EXCEPTION ? null : entityPersister.getCurrentVersion(serializable, eventSource);
        if (object2 != null) {
            Object object3;
            boolean bl;
            if (log.isTraceEnabled()) {
                log.trace("found existing row for " + MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
            }
            if (bl = replicationMode.shouldOverwriteCurrentVersion(object, object3 = entityPersister.isVersioned() ? object2 : null, entityPersister.getVersion(object, eventSource.getEntityMode()), entityPersister.getVersionType())) {
                this.performReplication(object, serializable, object3, entityPersister, replicationMode, eventSource);
            } else {
                log.trace("no need to replicate");
            }
        } else {
            boolean bl;
            if (log.isTraceEnabled()) {
                log.trace("no existing row, replicating new instance " + MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
            }
            EntityKey entityKey = (bl = entityPersister.isIdentifierAssignedByInsert()) ? null : new EntityKey(serializable, entityPersister, eventSource.getEntityMode());
            this.performSaveOrReplicate(object, entityKey, entityPersister, bl, replicationMode, eventSource, true);
        }
    }

    protected boolean visitCollectionsBeforeSave(Object object, Serializable serializable, Object[] objectArray, Type[] typeArray, EventSource eventSource) {
        OnReplicateVisitor onReplicateVisitor = new OnReplicateVisitor(eventSource, serializable, object, false);
        onReplicateVisitor.processEntityPropertyValues(objectArray, typeArray);
        return super.visitCollectionsBeforeSave(object, serializable, objectArray, typeArray, eventSource);
    }

    protected boolean substituteValuesIfNecessary(Object object, Serializable serializable, Object[] objectArray, EntityPersister entityPersister, SessionImplementor sessionImplementor) {
        return false;
    }

    protected boolean isVersionIncrementDisabled() {
        return true;
    }

    private void performReplication(Object object, Serializable serializable, Object object2, EntityPersister entityPersister, ReplicationMode replicationMode, EventSource eventSource) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("replicating changes to " + MessageHelper.infoString(entityPersister, serializable, eventSource.getFactory()));
        }
        new OnReplicateVisitor(eventSource, serializable, object, true).process(object, entityPersister);
        eventSource.getPersistenceContext().addEntity(object, entityPersister.isMutable() ? Status.MANAGED : Status.READ_ONLY, null, new EntityKey(serializable, entityPersister, eventSource.getEntityMode()), object2, LockMode.NONE, true, entityPersister, true, false);
        this.cascadeAfterReplicate(object, entityPersister, replicationMode, eventSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeAfterReplicate(Object object, EntityPersister entityPersister, ReplicationMode replicationMode, EventSource eventSource) {
        eventSource.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingAction.REPLICATE, 0, eventSource).cascade(entityPersister, object, replicationMode);
        }
        finally {
            eventSource.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected CascadingAction getCascadeAction() {
        return CascadingAction.REPLICATE;
    }
}

