/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.def.DefaultSaveOrUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class DefaultUpdateEventListener
extends DefaultSaveOrUpdateEventListener {
    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        EntityEntry entityEntry = saveOrUpdateEvent.getSession().getPersistenceContext().getEntry(saveOrUpdateEvent.getEntity());
        if (entityEntry != null) {
            if (entityEntry.getStatus() == Status.DELETED) {
                throw new ObjectDeletedException("deleted instance passed to update()", null, saveOrUpdateEvent.getEntityName());
            }
            return this.entityIsPersistent(saveOrUpdateEvent);
        }
        this.entityIsDetached(saveOrUpdateEvent);
        return null;
    }

    protected Serializable getUpdateId(Object object, EntityPersister entityPersister, Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        if (serializable == null) {
            return super.getUpdateId(object, entityPersister, serializable, sessionImplementor);
        }
        entityPersister.setIdentifier(object, serializable, sessionImplementor);
        return serializable;
    }
}

