/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.util.IdentityMap;

class EventCache
implements Map {
    private Map entityToCopyMap = IdentityMap.instantiate(10);
    private Map entityToOperatedOnFlagMap = IdentityMap.instantiate(10);

    EventCache() {
    }

    public void clear() {
        this.entityToCopyMap.clear();
        this.entityToOperatedOnFlagMap.clear();
    }

    public boolean containsKey(Object object) {
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        return this.entityToCopyMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException("null copies are not supported by " + this.getClass().getName());
        }
        return this.entityToCopyMap.containsValue(object);
    }

    public Set entrySet() {
        return this.entityToCopyMap.entrySet();
    }

    public Object get(Object object) {
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        return this.entityToCopyMap.get(object);
    }

    public boolean isEmpty() {
        return this.entityToCopyMap.isEmpty();
    }

    public Set keySet() {
        return this.entityToCopyMap.keySet();
    }

    public Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException("null entities and copies are not supported by " + this.getClass().getName());
        }
        this.entityToOperatedOnFlagMap.put(object, Boolean.FALSE);
        return this.entityToCopyMap.put(object, object2);
    }

    Object put(Object object, Object object2, boolean bl) {
        if (object == null || object2 == null) {
            throw new NullPointerException("null entities and copies are not supported by " + this.getClass().getName());
        }
        this.entityToOperatedOnFlagMap.put(object, bl);
        return this.entityToCopyMap.put(object, object2);
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException("null entities and copies are not supported by " + this.getClass().getName());
            }
            this.entityToCopyMap.put(entry.getKey(), entry.getValue());
            this.entityToOperatedOnFlagMap.put(entry.getKey(), Boolean.FALSE);
        }
    }

    public Object remove(Object object) {
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        this.entityToOperatedOnFlagMap.remove(object);
        return this.entityToCopyMap.remove(object);
    }

    public int size() {
        return this.entityToCopyMap.size();
    }

    public Collection values() {
        return this.entityToCopyMap.values();
    }

    public boolean isOperatedOn(Object object) {
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        return (Boolean)this.entityToOperatedOnFlagMap.get(object);
    }

    void setOperatedOn(Object object, boolean bl) {
        if (object == null) {
            throw new NullPointerException("null entities are not supported by " + this.getClass().getName());
        }
        if (!this.entityToOperatedOnFlagMap.containsKey(object) || !this.entityToCopyMap.containsKey(object)) {
            throw new AssertionFailure("called EventCache.setOperatedOn() for entity not found in EventCache");
        }
        this.entityToOperatedOnFlagMap.put(object, bl);
    }

    public Map invertMap() {
        return IdentityMap.invert(this.entityToCopyMap);
    }
}

