/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.Collections;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractVisitor;
import org.hibernate.type.CollectionType;

public class FlushVisitor
extends AbstractVisitor {
    private Object owner;

    Object processCollection(Object object, CollectionType collectionType) throws HibernateException {
        if (object == CollectionType.UNFETCHED_COLLECTION) {
            return null;
        }
        if (object != null) {
            PersistentCollection persistentCollection = collectionType.hasHolder(this.getSession().getEntityMode()) ? this.getSession().getPersistenceContext().getCollectionHolder(object) : (PersistentCollection)object;
            Collections.processReachableCollection(persistentCollection, collectionType, this.owner, this.getSession());
        }
        return null;
    }

    FlushVisitor(EventSource eventSource, Object object) {
        super(eventSource);
        this.owner = object;
    }
}

