/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;

public abstract class ProxyVisitor
extends AbstractVisitor {
    public ProxyVisitor(EventSource eventSource) {
        super(eventSource);
    }

    Object processEntity(Object object, EntityType entityType) throws HibernateException {
        if (object != null) {
            this.getSession().getPersistenceContext().reassociateIfUninitializedProxy(object);
        }
        return null;
    }

    protected static boolean isOwnerUnchanged(PersistentCollection persistentCollection, CollectionPersister collectionPersister, Serializable serializable) {
        return ProxyVisitor.isCollectionSnapshotValid(persistentCollection) && collectionPersister.getRole().equals(persistentCollection.getRole()) && serializable.equals(persistentCollection.getKey());
    }

    private static boolean isCollectionSnapshotValid(PersistentCollection persistentCollection) {
        return persistentCollection != null && persistentCollection.getRole() != null && persistentCollection.getKey() != null;
    }

    protected void reattachCollection(PersistentCollection persistentCollection, CollectionType collectionType) throws HibernateException {
        if (persistentCollection.wasInitialized()) {
            CollectionPersister collectionPersister = this.getSession().getFactory().getCollectionPersister(collectionType.getRole());
            this.getSession().getPersistenceContext().addInitializedDetachedCollection(collectionPersister, persistentCollection);
        } else {
            if (!ProxyVisitor.isCollectionSnapshotValid(persistentCollection)) {
                throw new HibernateException("could not reassociate uninitialized transient collection");
            }
            CollectionPersister collectionPersister = this.getSession().getFactory().getCollectionPersister(persistentCollection.getRole());
            this.getSession().getPersistenceContext().addUninitializedDetachedCollection(collectionPersister, persistentCollection);
        }
    }
}

