/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.exception;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.JDBCException;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.DataException;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.ViolatedConstraintNameExtracter;

public class CacheSQLStateConverter
implements SQLExceptionConverter {
    private ViolatedConstraintNameExtracter extracter;
    private static final Set SQL_GRAMMAR_CATEGORIES = new HashSet();
    private static final Set DATA_CATEGORIES = new HashSet();
    private static final Set INTEGRITY_VIOLATION_CATEGORIES = new HashSet();
    private static final Set CONNECTION_CATEGORIES = new HashSet();

    public CacheSQLStateConverter(ViolatedConstraintNameExtracter violatedConstraintNameExtracter) {
        this.extracter = violatedConstraintNameExtracter;
    }

    public JDBCException convert(SQLException sQLException, String string, String string2) {
        String string3 = JDBCExceptionHelper.extractSqlStateClassCode(sQLException);
        Integer n = new Integer(JDBCExceptionHelper.extractErrorCode(sQLException));
        if (string3 != null) {
            if (SQL_GRAMMAR_CATEGORIES.contains(string3)) {
                return new SQLGrammarException(string, sQLException, string2);
            }
            if (INTEGRITY_VIOLATION_CATEGORIES.contains(n)) {
                String string4 = this.extracter.extractConstraintName(sQLException);
                return new ConstraintViolationException(string, sQLException, string2, string4);
            }
            if (CONNECTION_CATEGORIES.contains(string3)) {
                return new JDBCConnectionException(string, sQLException, string2);
            }
            if (DATA_CATEGORIES.contains(string3)) {
                return new DataException(string, sQLException, string2);
            }
        }
        return this.handledNonSpecificException(sQLException, string, string2);
    }

    protected JDBCException handledNonSpecificException(SQLException sQLException, String string, String string2) {
        return new GenericJDBCException(string, sQLException, string2);
    }

    static {
        SQL_GRAMMAR_CATEGORIES.add("07");
        SQL_GRAMMAR_CATEGORIES.add("37");
        SQL_GRAMMAR_CATEGORIES.add("42");
        SQL_GRAMMAR_CATEGORIES.add("65");
        SQL_GRAMMAR_CATEGORIES.add("S0");
        SQL_GRAMMAR_CATEGORIES.add("20");
        DATA_CATEGORIES.add("22");
        DATA_CATEGORIES.add("21");
        DATA_CATEGORIES.add("02");
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(119));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(120));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(121));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(122));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(123));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(124));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(125));
        INTEGRITY_VIOLATION_CATEGORIES.add(new Integer(127));
        CONNECTION_CATEGORIES.add("08");
    }
}

