/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.RecognitionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCounter
implements ParseErrorHandler {
    private Logger log = LoggerFactory.getLogger(ErrorCounter.class);
    private Logger hqlLog = LoggerFactory.getLogger("org.hibernate.hql.PARSER");
    private List errorList = new ArrayList();
    private List warningList = new ArrayList();
    private List recognitionExceptions = new ArrayList();

    public void reportError(RecognitionException recognitionException) {
        this.reportError(recognitionException.toString());
        this.recognitionExceptions.add(recognitionException);
        if (this.log.isDebugEnabled()) {
            this.log.debug(recognitionException.toString(), recognitionException);
        }
    }

    public void reportError(String string) {
        this.hqlLog.error(string);
        this.errorList.add(string);
    }

    public int getErrorCount() {
        return this.errorList.size();
    }

    public void reportWarning(String string) {
        this.hqlLog.debug(string);
        this.warningList.add(string);
    }

    private String getErrorString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.errorList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void throwQueryException() throws QueryException {
        if (this.getErrorCount() > 0) {
            if (this.recognitionExceptions.size() > 0) {
                throw QuerySyntaxException.convert((RecognitionException)this.recognitionExceptions.get(0));
            }
            throw new QueryException(this.getErrorString());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("throwQueryException() : no errors");
        }
    }
}

