/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTFactory;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.engine.ParameterBinder;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.antlr.HqlSqlBaseWalker;
import org.hibernate.hql.antlr.SqlGeneratorBase;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.ErrorCounter;
import org.hibernate.hql.ast.ErrorReporter;
import org.hibernate.hql.ast.HqlParser;
import org.hibernate.hql.ast.InvalidWithClauseException;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.QueryTranslatorImpl;
import org.hibernate.hql.ast.SqlASTFactory;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.tree.AggregateNode;
import org.hibernate.hql.ast.tree.AssignmentSpecification;
import org.hibernate.hql.ast.tree.CollectionFunction;
import org.hibernate.hql.ast.tree.ConstructorNode;
import org.hibernate.hql.ast.tree.DeleteStatement;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromElementFactory;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.tree.IdentNode;
import org.hibernate.hql.ast.tree.IndexNode;
import org.hibernate.hql.ast.tree.InsertStatement;
import org.hibernate.hql.ast.tree.IntoClause;
import org.hibernate.hql.ast.tree.MethodNode;
import org.hibernate.hql.ast.tree.OperatorNode;
import org.hibernate.hql.ast.tree.ParameterContainer;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.ResolvableNode;
import org.hibernate.hql.ast.tree.RestrictableStatement;
import org.hibernate.hql.ast.tree.ResultVariableRefNode;
import org.hibernate.hql.ast.tree.SelectClause;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.UpdateStatement;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.AliasGenerator;
import org.hibernate.hql.ast.util.JoinProcessor;
import org.hibernate.hql.ast.util.LiteralProcessor;
import org.hibernate.hql.ast.util.NodeTraverser;
import org.hibernate.hql.ast.util.SessionFactoryHelper;
import org.hibernate.hql.ast.util.SyntheticAndFactory;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.param.CollectionFilterKeyParameterSpecification;
import org.hibernate.param.NamedParameterSpecification;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.param.PositionalParameterSpecification;
import org.hibernate.param.VersionTypeSeedParameterSpecification;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.DbTimestampType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;
import org.hibernate.usertype.UserVersionType;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HqlSqlWalker
extends HqlSqlBaseWalker
implements ErrorReporter,
ParameterBinder.NamedParameterSource {
    private static final Logger log = LoggerFactory.getLogger(HqlSqlWalker.class);
    private final QueryTranslatorImpl queryTranslatorImpl;
    private final HqlParser hqlParser;
    private final SessionFactoryHelper sessionFactoryHelper;
    private final Map tokenReplacements;
    private final AliasGenerator aliasGenerator = new AliasGenerator();
    private final LiteralProcessor literalProcessor;
    private final ParseErrorHandler parseErrorHandler;
    private final ASTPrinter printer;
    private final String collectionFilterRole;
    private FromClause currentFromClause = null;
    private SelectClause selectClause;
    private Map<String, SelectExpression> selectExpressionsByResultVariable = new HashMap<String, SelectExpression>();
    private Set querySpaces = new HashSet();
    private int parameterCount;
    private Map namedParameters = new HashMap();
    private ArrayList parameters = new ArrayList();
    private int numberOfParametersInSetClause;
    private int positionalParameterCount;
    private ArrayList assignmentSpecifications = new ArrayList();
    private int impliedJoinType;
    private int traceDepth = 0;

    public HqlSqlWalker(QueryTranslatorImpl queryTranslatorImpl, SessionFactoryImplementor sessionFactoryImplementor, HqlParser hqlParser, Map map, String string) {
        this.setASTFactory(new SqlASTFactory(this));
        this.parseErrorHandler = new ErrorCounter();
        this.queryTranslatorImpl = queryTranslatorImpl;
        this.sessionFactoryHelper = new SessionFactoryHelper(sessionFactoryImplementor);
        this.literalProcessor = new LiteralProcessor(this);
        this.tokenReplacements = map;
        this.collectionFilterRole = string;
        this.hqlParser = hqlParser;
        this.printer = new ASTPrinter(SqlTokenTypes.class);
    }

    public void traceIn(String string, AST aST) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        String string3 = string + " (" + this.buildTraceNodeName(aST) + ")";
        log.trace(string2 + string3);
    }

    private String buildTraceNodeName(AST aST) {
        return aST == null ? "???" : aST.getText() + " [" + this.printer.getTokenTypeName(aST.getType()) + "]";
    }

    public void traceOut(String string, AST aST) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        log.trace(string2 + string);
    }

    protected void prepareFromClauseInputTree(AST aST) {
        if (!this.isSubQuery() && this.isFilter()) {
            QueryableCollection queryableCollection = this.sessionFactoryHelper.getCollectionPersister(this.collectionFilterRole);
            Type type = queryableCollection.getElementType();
            if (!type.isEntityType()) {
                throw new QueryException("collection of values in filter: this");
            }
            String string = queryableCollection.getElementPersister().getEntityName();
            ASTFactory aSTFactory = this.hqlParser.getASTFactory();
            AST aST2 = ASTUtil.create(aSTFactory, 76, string);
            ASTUtil.createSibling(aSTFactory, 72, "this", aST2);
            aST.addChild(aST2);
            if (log.isDebugEnabled()) {
                log.debug("prepareFromClauseInputTree() : Filter - Added 'this' as a from element...");
            }
            this.queryTranslatorImpl.showHqlAst(this.hqlParser.getAST());
            Type type2 = this.sessionFactoryHelper.requireQueryableCollection(this.collectionFilterRole).getKeyType();
            ParameterNode parameterNode = (ParameterNode)this.astFactory.create(123, "?");
            CollectionFilterKeyParameterSpecification collectionFilterKeyParameterSpecification = new CollectionFilterKeyParameterSpecification(this.collectionFilterRole, type2, this.positionalParameterCount++);
            parameterNode.setHqlParameterSpecification(collectionFilterKeyParameterSpecification);
            this.parameters.add(collectionFilterKeyParameterSpecification);
        }
    }

    public boolean isFilter() {
        return this.collectionFilterRole != null;
    }

    public String getCollectionFilterRole() {
        return this.collectionFilterRole;
    }

    public SessionFactoryHelper getSessionFactoryHelper() {
        return this.sessionFactoryHelper;
    }

    public Map getTokenReplacements() {
        return this.tokenReplacements;
    }

    public AliasGenerator getAliasGenerator() {
        return this.aliasGenerator;
    }

    public FromClause getCurrentFromClause() {
        return this.currentFromClause;
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public void reportError(RecognitionException recognitionException) {
        this.parseErrorHandler.reportError(recognitionException);
    }

    public void reportError(String string) {
        this.parseErrorHandler.reportError(string);
    }

    public void reportWarning(String string) {
        this.parseErrorHandler.reportWarning(string);
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected AST createFromElement(String string, AST aST, AST aST2) throws SemanticException {
        FromElement fromElement = this.currentFromClause.addFromElement(string, aST);
        fromElement.setAllPropertyFetch(aST2 != null);
        return fromElement;
    }

    protected AST createFromFilterElement(AST aST, AST aST2) throws SemanticException {
        FromElement fromElement = this.currentFromClause.addFromElement(aST.getText(), aST2);
        FromClause fromClause = fromElement.getFromClause();
        QueryableCollection queryableCollection = this.sessionFactoryHelper.getCollectionPersister(this.collectionFilterRole);
        String[] stringArray = queryableCollection.getKeyColumnNames();
        String string = queryableCollection.isOneToMany() ? fromElement.getTableAlias() : fromClause.getAliasGenerator().createName(this.collectionFilterRole);
        JoinSequence joinSequence = this.sessionFactoryHelper.createJoinSequence();
        joinSequence.setRoot(queryableCollection, string);
        if (!queryableCollection.isOneToMany()) {
            joinSequence.addJoin((AssociationType)queryableCollection.getElementType(), fromElement.getTableAlias(), 0, queryableCollection.getElementColumnNames(string));
        }
        joinSequence.addCondition(string, stringArray, " = ?");
        fromElement.setJoinSequence(joinSequence);
        fromElement.setFilter(true);
        if (log.isDebugEnabled()) {
            log.debug("createFromFilterElement() : processed filter FROM element.");
        }
        return fromElement;
    }

    protected void createFromJoinElement(AST aST, AST aST2, int n, AST aST3, AST aST4, AST aST5) throws SemanticException {
        FromElement fromElement;
        boolean bl;
        boolean bl2 = bl = aST3 != null;
        if (bl && this.isSubQuery()) {
            throw new QueryException("fetch not allowed in subquery from-elements");
        }
        if (aST.getType() != 15) {
            throw new SemanticException("Path expected for join!");
        }
        DotNode dotNode = (DotNode)aST;
        int n2 = JoinProcessor.toHibernateJoinType(n);
        dotNode.setJoinType(n2);
        dotNode.setFetch(bl);
        dotNode.resolve(true, false, aST2 == null ? null : aST2.getText());
        if (dotNode.getDataType() != null && dotNode.getDataType().isComponentType()) {
            FromElementFactory fromElementFactory = new FromElementFactory(this.getCurrentFromClause(), dotNode.getLhs().getFromElement(), dotNode.getPropertyPath(), aST2 == null ? null : aST2.getText(), null, false);
            fromElement = fromElementFactory.createComponentJoin((ComponentType)dotNode.getDataType());
        } else {
            fromElement = dotNode.getImpliedJoin();
            fromElement.setAllPropertyFetch(aST4 != null);
            if (aST5 != null) {
                if (bl) {
                    throw new SemanticException("with-clause not allowed on fetched associations; use filters");
                }
                this.handleWithFragment(fromElement, aST5);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("createFromJoinElement() : " + this.getASTPrinter().showAsString(fromElement, "-- join tree --"));
        }
    }

    private void handleWithFragment(FromElement fromElement, AST aST) throws SemanticException {
        try {
            Object object;
            this.withClause(aST);
            AST aST2 = this.returnAST;
            if (log.isDebugEnabled()) {
                log.debug("handleWithFragment() : " + this.getASTPrinter().showAsString(aST2, "-- with clause --"));
            }
            WithClauseVisitor withClauseVisitor = new WithClauseVisitor(fromElement);
            NodeTraverser nodeTraverser = new NodeTraverser(withClauseVisitor);
            nodeTraverser.traverseDepthFirst(aST2);
            String string = withClauseVisitor.getJoinAlias();
            if (string == null) {
                string = fromElement.getCollectionTableAlias();
            } else {
                object = withClauseVisitor.getReferencedFromElement();
                if (object != fromElement) {
                    throw new InvalidWithClauseException("with-clause expressions did not reference from-clause element to which the with-clause was associated");
                }
            }
            object = new SqlGenerator(this.getSessionFactoryHelper().getFactory());
            ((SqlGeneratorBase)object).whereExpr(aST2.getFirstChild());
            fromElement.setWithClauseFragment(string, "(" + ((SqlGenerator)object).getSQL() + ")");
        }
        catch (SemanticException semanticException) {
            throw semanticException;
        }
        catch (InvalidWithClauseException invalidWithClauseException) {
            throw invalidWithClauseException;
        }
        catch (Exception exception) {
            throw new SemanticException(exception.getMessage());
        }
    }

    protected void pushFromClause(AST aST, AST aST2) {
        FromClause fromClause = (FromClause)aST;
        fromClause.setParentFromClause(this.currentFromClause);
        this.currentFromClause = fromClause;
    }

    private void popFromClause() {
        this.currentFromClause = this.currentFromClause.getParentFromClause();
    }

    protected void lookupAlias(AST aST) throws SemanticException {
        FromElement fromElement = this.currentFromClause.getFromElement(aST.getText());
        FromReferenceNode fromReferenceNode = (FromReferenceNode)aST;
        fromReferenceNode.setFromElement(fromElement);
    }

    protected void setImpliedJoinType(int n) {
        this.impliedJoinType = JoinProcessor.toHibernateJoinType(n);
    }

    public int getImpliedJoinType() {
        return this.impliedJoinType;
    }

    protected AST lookupProperty(AST aST, boolean bl, boolean bl2) throws SemanticException {
        DotNode dotNode = (DotNode)aST;
        FromReferenceNode fromReferenceNode = dotNode.getLhs();
        AST aST2 = fromReferenceNode.getNextSibling();
        switch (aST2.getType()) {
            case 17: 
            case 27: {
                if (log.isDebugEnabled()) {
                    log.debug("lookupProperty() " + dotNode.getPath() + " => " + aST2.getText() + "(" + fromReferenceNode.getPath() + ")");
                }
                CollectionFunction collectionFunction = (CollectionFunction)aST2;
                collectionFunction.setFirstChild(fromReferenceNode);
                fromReferenceNode.setNextSibling(null);
                dotNode.setFirstChild(collectionFunction);
                this.resolve(fromReferenceNode);
                collectionFunction.resolve(bl2);
                return collectionFunction;
            }
        }
        dotNode.resolveFirstChild();
        return dotNode;
    }

    protected boolean isNonQualifiedPropertyRef(AST aST) {
        String string = aST.getText();
        if (this.currentFromClause.isFromElementAlias(string)) {
            return false;
        }
        List list = this.currentFromClause.getExplicitFromElements();
        if (list.size() == 1) {
            FromElement fromElement = (FromElement)list.get(0);
            try {
                log.trace("attempting to resolve property [" + string + "] as a non-qualified ref");
                return fromElement.getPropertyMapping(string).toType(string) != null;
            }
            catch (QueryException queryException) {
                // empty catch block
            }
        }
        return false;
    }

    protected AST lookupNonQualifiedProperty(AST aST) throws SemanticException {
        FromElement fromElement = (FromElement)this.currentFromClause.getExplicitFromElements().get(0);
        AST aST2 = this.generateSyntheticDotNodeForNonQualifiedPropertyRef(aST, fromElement);
        return this.lookupProperty(aST2, false, this.getCurrentClauseType() == 45);
    }

    private AST generateSyntheticDotNodeForNonQualifiedPropertyRef(AST aST, FromElement fromElement) {
        AST aST2 = this.getASTFactory().create(15, "{non-qualified-property-ref}");
        ((DotNode)aST2).setPropertyPath(((FromReferenceNode)aST).getPath());
        IdentNode identNode = (IdentNode)this.getASTFactory().create(126, "{synthetic-alias}");
        identNode.setFromElement(fromElement);
        identNode.setResolved();
        aST2.setFirstChild(identNode);
        aST2.addChild(aST);
        return aST2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQuery(AST aST, AST aST2) throws SemanticException {
        if (log.isDebugEnabled()) {
            log.debug("processQuery() : " + aST2.toStringTree());
        }
        try {
            boolean bl;
            QueryNode queryNode = (QueryNode)aST2;
            boolean bl2 = bl = aST != null && aST.getNumberOfChildren() > 0;
            if (!bl) {
                this.createSelectClauseFromFromClause(queryNode);
            } else {
                this.useSelectClause(aST);
            }
            JoinProcessor joinProcessor = new JoinProcessor(this);
            joinProcessor.processJoins(queryNode);
            for (FromElement fromElement : queryNode.getFromClause().getProjectionList()) {
                String string;
                if (!fromElement.isFetch() || fromElement.getQueryableCollection() == null) continue;
                if (fromElement.getQueryableCollection().hasOrdering()) {
                    string = fromElement.getQueryableCollection().getSQLOrderByString(fromElement.getCollectionTableAlias());
                    queryNode.getOrderByClause().addOrderFragment(string);
                }
                if (!fromElement.getQueryableCollection().hasManyToManyOrdering()) continue;
                string = fromElement.getQueryableCollection().getManyToManyOrderByString(fromElement.getTableAlias());
                queryNode.getOrderByClause().addOrderFragment(string);
            }
        }
        finally {
            this.popFromClause();
        }
    }

    protected void postProcessDML(RestrictableStatement restrictableStatement) throws SemanticException {
        restrictableStatement.getFromClause().resolve();
        FromElement fromElement = (FromElement)restrictableStatement.getFromClause().getFromElements().get(0);
        Queryable queryable = fromElement.getQueryable();
        fromElement.setText(queryable.getTableName());
        if (queryable.getDiscriminatorType() != null || !this.queryTranslatorImpl.getEnabledFilters().isEmpty()) {
            new SyntheticAndFactory(this).addDiscriminatorWhereFragment(restrictableStatement, queryable, this.queryTranslatorImpl.getEnabledFilters(), fromElement.getTableAlias());
        }
    }

    protected void postProcessUpdate(AST aST) throws SemanticException {
        UpdateStatement updateStatement = (UpdateStatement)aST;
        this.postProcessDML(updateStatement);
    }

    protected void postProcessDelete(AST aST) throws SemanticException {
        this.postProcessDML((DeleteStatement)aST);
    }

    public static boolean supportsIdGenWithBulkInsertion(IdentifierGenerator identifierGenerator) {
        return SequenceGenerator.class.isAssignableFrom(identifierGenerator.getClass()) || PostInsertIdentifierGenerator.class.isAssignableFrom(identifierGenerator.getClass());
    }

    protected void postProcessInsert(AST aST) throws SemanticException, QueryException {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        InsertStatement insertStatement = (InsertStatement)aST;
        insertStatement.validate();
        SelectClause selectClause = insertStatement.getSelectClause();
        Queryable queryable = insertStatement.getIntoClause().getQueryable();
        if (!insertStatement.getIntoClause().isExplicitIdInsertion()) {
            IdentifierGenerator identifierGenerator = queryable.getIdentifierGenerator();
            if (!HqlSqlWalker.supportsIdGenWithBulkInsertion(identifierGenerator)) {
                throw new QueryException("can only generate ids as part of bulk insert with either sequence or post-insert style generators");
            }
            object3 = null;
            if (SequenceGenerator.class.isAssignableFrom(identifierGenerator.getClass())) {
                object2 = (String)((SequenceGenerator)identifierGenerator).generatorKey();
                object = this.sessionFactoryHelper.getFactory().getDialect().getSelectSequenceNextValString((String)object2);
                object3 = this.getASTFactory().create(142, (String)object);
            }
            if (object3 != null) {
                object2 = selectClause.getFirstChild();
                selectClause.setFirstChild((AST)object3);
                object3.setNextSibling((AST)object2);
                insertStatement.getIntoClause().prependIdColumnSpec();
            }
        }
        boolean bl2 = bl = queryable.isVersioned() && !insertStatement.getIntoClause().isExplicitVersionInsertion() && queryable.isVersionPropertyInsertable();
        if (bl) {
            object3 = queryable.getVersionType();
            object2 = null;
            if (this.sessionFactoryHelper.getFactory().getDialect().supportsParametersInInsertSelect()) {
                object = object3.sqlTypes(this.sessionFactoryHelper.getFactory());
                if (object == null || ((int[])object).length == 0) {
                    throw new IllegalStateException(object3.getClass() + ".sqlTypes() returns null or empty array");
                }
                if (((int[])object).length > 1) {
                    throw new IllegalStateException(object3.getClass() + ".sqlTypes() returns > 1 element; only single-valued versions are allowed.");
                }
                object2 = this.getASTFactory().create(123, "?");
                VersionTypeSeedParameterSpecification versionTypeSeedParameterSpecification = new VersionTypeSeedParameterSpecification((VersionType)object3);
                ((ParameterNode)object2).setHqlParameterSpecification(versionTypeSeedParameterSpecification);
                this.parameters.add(0, versionTypeSeedParameterSpecification);
                if (this.sessionFactoryHelper.getFactory().getDialect().requiresCastingOfParametersInSelectClause()) {
                    MethodNode methodNode = (MethodNode)this.getASTFactory().create(81, "(");
                    AST aST2 = this.getASTFactory().create(126, "cast");
                    methodNode.addChild(aST2);
                    methodNode.initializeMethodNode(aST2, true);
                    AST aST3 = this.getASTFactory().create(75, "exprList");
                    aST2.setNextSibling(aST3);
                    aST3.addChild((AST)object2);
                    object2.setNextSibling(this.getASTFactory().create(126, this.sessionFactoryHelper.getFactory().getDialect().getTypeName((int)object[0])));
                    this.processFunction(methodNode, true);
                    object2 = methodNode;
                }
            } else if (this.isIntegral((Type)object3)) {
                try {
                    object = object3.seed(null);
                    object2 = this.getASTFactory().create(142, object.toString());
                }
                catch (Throwable throwable) {
                    throw new QueryException("could not determine seed value for version on bulk insert [" + object3 + "]");
                }
            } else if (this.isDatabaseGeneratedTimestamp((Type)object3)) {
                object = this.sessionFactoryHelper.getFactory().getDialect().getCurrentTimestampSQLFunctionName();
                object2 = this.getASTFactory().create(142, (String)object);
            } else {
                throw new QueryException("cannot handle version type [" + object3 + "] on bulk inserts with dialects not supporting parameters in insert-select statements");
            }
            object = selectClause.getFirstChild();
            selectClause.setFirstChild((AST)object2);
            object2.setNextSibling((AST)object);
            insertStatement.getIntoClause().prependVersionColumnSpec();
        }
        if (insertStatement.getIntoClause().isDiscriminated()) {
            object3 = insertStatement.getIntoClause().getQueryable().getDiscriminatorSQLValue();
            object2 = this.getASTFactory().create(142, (String)object3);
            insertStatement.getSelectClause().addChild((AST)object2);
        }
    }

    private boolean isDatabaseGeneratedTimestamp(Type type) {
        return DbTimestampType.class.isAssignableFrom(type.getClass());
    }

    private boolean isIntegral(Type type) {
        return Long.class.isAssignableFrom(type.getReturnedClass()) || Integer.class.isAssignableFrom(type.getReturnedClass()) || Long.TYPE.isAssignableFrom(type.getReturnedClass()) || Integer.TYPE.isAssignableFrom(type.getReturnedClass());
    }

    private void useSelectClause(AST aST) throws SemanticException {
        this.selectClause = (SelectClause)aST;
        this.selectClause.initializeExplicitSelectClause(this.currentFromClause);
    }

    private void createSelectClauseFromFromClause(QueryNode queryNode) throws SemanticException {
        AST aST = this.astFactory.create(137, "{derived select clause}");
        FromClause fromClause = queryNode.getFromClause();
        queryNode.setFirstChild(aST);
        aST.setNextSibling(fromClause);
        this.selectClause = (SelectClause)aST;
        this.selectClause.initializeDerivedSelectClause(this.currentFromClause);
        if (log.isDebugEnabled()) {
            log.debug("Derived SELECT clause created.");
        }
    }

    protected void resolve(AST aST) throws SemanticException {
        if (aST != null) {
            ResolvableNode resolvableNode = (ResolvableNode)((Object)aST);
            if (this.isInFunctionCall()) {
                resolvableNode.resolveInFunctionCall(false, true);
            } else {
                resolvableNode.resolve(false, true);
            }
        }
    }

    protected void resolveSelectExpression(AST aST) throws SemanticException {
        int n = aST.getType();
        switch (n) {
            case 15: {
                DotNode dotNode = (DotNode)aST;
                dotNode.resolveSelectExpression();
                break;
            }
            case 140: {
                FromReferenceNode fromReferenceNode = (FromReferenceNode)aST;
                fromReferenceNode.resolve(false, false);
                FromElement fromElement = fromReferenceNode.getFromElement();
                if (fromElement == null) break;
                fromElement.setIncludeSubclasses(true);
                break;
            }
        }
    }

    protected void beforeSelectClause() throws SemanticException {
        FromClause fromClause = this.getCurrentFromClause();
        List list = fromClause.getFromElements();
        for (FromElement fromElement : list) {
            fromElement.setIncludeSubclasses(false);
        }
    }

    protected AST generatePositionalParameter(AST aST) throws SemanticException {
        if (this.namedParameters.size() > 0) {
            throw new SemanticException("cannot define positional parameter after any named parameters have been defined");
        }
        ParameterNode parameterNode = (ParameterNode)this.astFactory.create(123, "?");
        PositionalParameterSpecification positionalParameterSpecification = new PositionalParameterSpecification(aST.getLine(), aST.getColumn(), this.positionalParameterCount++);
        parameterNode.setHqlParameterSpecification(positionalParameterSpecification);
        this.parameters.add(positionalParameterSpecification);
        return parameterNode;
    }

    protected AST generateNamedParameter(AST aST, AST aST2) throws SemanticException {
        String string = aST2.getText();
        this.trackNamedParameterPositions(string);
        ParameterNode parameterNode = (ParameterNode)this.astFactory.create(148, string);
        parameterNode.setText("?");
        NamedParameterSpecification namedParameterSpecification = new NamedParameterSpecification(aST.getLine(), aST.getColumn(), string);
        parameterNode.setHqlParameterSpecification(namedParameterSpecification);
        this.parameters.add(namedParameterSpecification);
        return parameterNode;
    }

    private void trackNamedParameterPositions(String string) {
        Integer n = new Integer(this.parameterCount++);
        Object v = this.namedParameters.get(string);
        if (v == null) {
            this.namedParameters.put(string, n);
        } else if (v instanceof Integer) {
            ArrayList<Object> arrayList = new ArrayList<Object>(4);
            arrayList.add(v);
            arrayList.add(n);
            this.namedParameters.put(string, arrayList);
        } else {
            ((ArrayList)v).add(n);
        }
    }

    protected void processConstant(AST aST) throws SemanticException {
        this.literalProcessor.processConstant(aST, true);
    }

    protected void processBoolean(AST aST) throws SemanticException {
        this.literalProcessor.processBoolean(aST);
    }

    protected void processNumericLiteral(AST aST) {
        this.literalProcessor.processNumeric(aST);
    }

    protected void processIndex(AST aST) throws SemanticException {
        IndexNode indexNode = (IndexNode)aST;
        indexNode.resolve(true, true);
    }

    protected void processFunction(AST aST, boolean bl) throws SemanticException {
        MethodNode methodNode = (MethodNode)aST;
        methodNode.resolve(bl);
    }

    protected void processAggregation(AST aST, boolean bl) throws SemanticException {
        AggregateNode aggregateNode = (AggregateNode)aST;
        aggregateNode.resolve();
    }

    protected void processConstructor(AST aST) throws SemanticException {
        ConstructorNode constructorNode = (ConstructorNode)aST;
        constructorNode.prepare();
    }

    protected void setAlias(AST aST, AST aST2) {
        ((SelectExpression)((Object)aST)).setAlias(aST2.getText());
        if (!this.isSubQuery()) {
            this.selectExpressionsByResultVariable.put(aST2.getText(), (SelectExpression)((Object)aST));
        }
    }

    protected boolean isOrderExpressionResultVariableRef(AST aST) throws SemanticException {
        return !this.isSubQuery() && aST.getType() == 126 && this.selectExpressionsByResultVariable.containsKey(aST.getText());
    }

    protected void handleResultVariableRef(AST aST) throws SemanticException {
        if (this.isSubQuery()) {
            throw new SemanticException("References to result variables in subqueries are not supported.");
        }
        ((ResultVariableRefNode)aST).setSelectExpression(this.selectExpressionsByResultVariable.get(aST.getText()));
    }

    public int[] getNamedParameterLocations(String string) throws QueryException {
        Object v = this.namedParameters.get(string);
        if (v == null) {
            QueryException queryException = new QueryException("Named parameter does not appear in Query: " + string);
            queryException.setQueryString(this.queryTranslatorImpl.getQueryString());
            throw queryException;
        }
        if (v instanceof Integer) {
            return new int[]{(Integer)v};
        }
        return ArrayHelper.toIntArray((ArrayList)v);
    }

    public void addQuerySpaces(Serializable[] serializableArray) {
        this.querySpaces.addAll(Arrays.asList(serializableArray));
    }

    public Type[] getReturnTypes() {
        return this.selectClause.getQueryReturnTypes();
    }

    public String[] getReturnAliases() {
        return this.selectClause.getQueryReturnAliases();
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public FromClause getFinalFromClause() {
        FromClause fromClause = this.currentFromClause;
        while (fromClause.getParentFromClause() != null) {
            fromClause = fromClause.getParentFromClause();
        }
        return fromClause;
    }

    public boolean isShallowQuery() {
        return this.getStatementType() == 29 || this.queryTranslatorImpl.isShallowQuery();
    }

    public Map getEnabledFilters() {
        return this.queryTranslatorImpl.getEnabledFilters();
    }

    public LiteralProcessor getLiteralProcessor() {
        return this.literalProcessor;
    }

    public ASTPrinter getASTPrinter() {
        return this.printer;
    }

    public ArrayList getParameters() {
        return this.parameters;
    }

    public int getNumberOfParametersInSetClause() {
        return this.numberOfParametersInSetClause;
    }

    protected void evaluateAssignment(AST aST) throws SemanticException {
        this.prepareLogicOperator(aST);
        Queryable queryable = this.getCurrentFromClause().getFromElement().getQueryable();
        this.evaluateAssignment(aST, queryable, -1);
    }

    private void evaluateAssignment(AST aST, Queryable queryable, int n) {
        if (queryable.isMultiTable()) {
            AssignmentSpecification assignmentSpecification = new AssignmentSpecification(aST, queryable);
            if (n >= 0) {
                this.assignmentSpecifications.add(n, assignmentSpecification);
            } else {
                this.assignmentSpecifications.add(assignmentSpecification);
            }
            this.numberOfParametersInSetClause += assignmentSpecification.getParameters().length;
        }
    }

    public ArrayList getAssignmentSpecifications() {
        return this.assignmentSpecifications;
    }

    protected AST createIntoClause(String string, AST aST) throws SemanticException {
        Queryable queryable = (Queryable)this.getSessionFactoryHelper().requireClassPersister(string);
        IntoClause intoClause = (IntoClause)this.getASTFactory().create(30, queryable.getEntityName());
        intoClause.setFirstChild(aST);
        intoClause.initialize(queryable);
        this.addQuerySpaces(queryable.getQuerySpaces());
        return intoClause;
    }

    protected void prepareVersioned(AST aST, AST aST2) throws SemanticException {
        UpdateStatement updateStatement = (UpdateStatement)aST;
        FromClause fromClause = updateStatement.getFromClause();
        if (aST2 != null) {
            Object object;
            Queryable queryable = fromClause.getFromElement().getQueryable();
            if (!queryable.isVersioned()) {
                throw new SemanticException("increment option specified for update of non-versioned entity");
            }
            VersionType versionType = queryable.getVersionType();
            if (versionType instanceof UserVersionType) {
                throw new SemanticException("user-defined version types not supported for increment option");
            }
            AST aST3 = this.getASTFactory().create(102, "=");
            AST aST4 = this.generateVersionPropertyNode(queryable);
            aST3.setFirstChild(aST4);
            AST aST5 = null;
            if (this.isTimestampBasedVersion(versionType)) {
                aST5 = this.getASTFactory().create(123, "?");
                object = new VersionTypeSeedParameterSpecification(versionType);
                ((ParameterNode)aST5).setHqlParameterSpecification((ParameterSpecification)object);
                this.parameters.add(0, object);
            } else {
                aST5 = this.getASTFactory().create(115, "+");
                aST5.setFirstChild(this.generateVersionPropertyNode(queryable));
                aST5.addChild(this.getASTFactory().create(126, "1"));
            }
            aST3.addChild(aST5);
            this.evaluateAssignment(aST3, queryable, 0);
            object = updateStatement.getSetClause();
            AST aST6 = object.getFirstChild();
            object.setFirstChild(aST3);
            aST3.setNextSibling(aST6);
        }
    }

    private boolean isTimestampBasedVersion(VersionType versionType) {
        Class clazz = versionType.getReturnedClass();
        return Date.class.isAssignableFrom(clazz) || Calendar.class.isAssignableFrom(clazz);
    }

    private AST generateVersionPropertyNode(Queryable queryable) throws SemanticException {
        String string = queryable.getPropertyNames()[queryable.getVersionProperty()];
        AST aST = this.getASTFactory().create(126, string);
        AST aST2 = this.lookupNonQualifiedProperty(aST);
        this.resolve(aST2);
        return aST2;
    }

    protected void prepareLogicOperator(AST aST) throws SemanticException {
        ((OperatorNode)((Object)aST)).initialize();
    }

    protected void prepareArithmeticOperator(AST aST) throws SemanticException {
        ((OperatorNode)((Object)aST)).initialize();
    }

    protected void validateMapPropertyExpression(AST aST) throws SemanticException {
        try {
            FromReferenceNode fromReferenceNode = (FromReferenceNode)aST;
            QueryableCollection queryableCollection = fromReferenceNode.getFromElement().getQueryableCollection();
            if (!Map.class.isAssignableFrom(queryableCollection.getCollectionType().getReturnedClass())) {
                throw new SemanticException("node did not reference a map");
            }
        }
        catch (SemanticException semanticException) {
            throw semanticException;
        }
        catch (Throwable throwable) {
            throw new SemanticException("node did not reference a map");
        }
    }

    public static void panic() {
        throw new QueryException("TreeWalker: panic");
    }

    private static class WithClauseVisitor
    implements NodeTraverser.VisitationStrategy {
        private final FromElement joinFragment;
        private FromElement referencedFromElement;
        private String joinAlias;

        public WithClauseVisitor(FromElement fromElement) {
            this.joinFragment = fromElement;
        }

        public void visit(AST aST) {
            if (aST instanceof DotNode) {
                DotNode dotNode = (DotNode)aST;
                FromElement fromElement = dotNode.getFromElement();
                if (this.referencedFromElement != null) {
                    if (fromElement != this.referencedFromElement) {
                        throw new HibernateException("with-clause referenced two different from-clause elements");
                    }
                } else {
                    this.referencedFromElement = fromElement;
                    this.joinAlias = this.extractAppliedAlias(dotNode);
                    if (!this.joinAlias.equals(this.referencedFromElement.getTableAlias())) {
                        throw new InvalidWithClauseException("with clause can only reference columns in the driving table");
                    }
                }
            } else if (aST instanceof ParameterNode) {
                this.applyParameterSpecification(((ParameterNode)aST).getHqlParameterSpecification());
            } else if (aST instanceof ParameterContainer) {
                this.applyParameterSpecifications((ParameterContainer)((Object)aST));
            }
        }

        private void applyParameterSpecifications(ParameterContainer parameterContainer) {
            if (parameterContainer.hasEmbeddedParameters()) {
                ParameterSpecification[] parameterSpecificationArray = parameterContainer.getEmbeddedParameters();
                for (int i = 0; i < parameterSpecificationArray.length; ++i) {
                    this.applyParameterSpecification(parameterSpecificationArray[i]);
                }
            }
        }

        private void applyParameterSpecification(ParameterSpecification parameterSpecification) {
            this.joinFragment.addEmbeddedParameter(parameterSpecification);
        }

        private String extractAppliedAlias(DotNode dotNode) {
            return dotNode.getText().substring(0, dotNode.getText().indexOf(46));
        }

        public FromElement getReferencedFromElement() {
            return this.referencedFromElement;
        }

        public String getJoinAlias() {
            return this.joinAlias;
        }
    }
}

