/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.antlr.SqlGeneratorBase;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.ErrorCounter;
import org.hibernate.hql.ast.ErrorReporter;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FunctionNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterContainer;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlGenerator
extends SqlGeneratorBase
implements ErrorReporter {
    private static final Logger log = LoggerFactory.getLogger(SqlGenerator.class);
    public static boolean REGRESSION_STYLE_CROSS_JOINS = false;
    private SqlWriter writer = new DefaultWriter();
    private ParseErrorHandler parseErrorHandler;
    private SessionFactoryImplementor sessionFactory;
    private LinkedList<SqlWriter> outputStack = new LinkedList();
    private final ASTPrinter printer = new ASTPrinter(SqlTokenTypes.class);
    private List collectedParameters = new ArrayList();
    private int traceDepth = 0;

    public void traceIn(String string, AST aST) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
        String string3 = string + " (" + this.buildTraceNodeName(aST) + ")";
        log.trace(string2 + string3);
    }

    private String buildTraceNodeName(AST aST) {
        return aST == null ? "???" : aST.getText() + " [" + this.printer.getTokenTypeName(aST.getType()) + "]";
    }

    public void traceOut(String string, AST aST) {
        if (this.inputState.guessing > 0) {
            return;
        }
        String string2 = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
        log.trace(string2 + string);
    }

    public List getCollectedParameters() {
        return this.collectedParameters;
    }

    protected void out(String string) {
        this.writer.clause(string);
    }

    protected void out(AST aST) {
        ParameterSpecification[] parameterSpecificationArray;
        if (aST instanceof Node) {
            this.out(((Node)aST).getRenderText(this.sessionFactory));
        } else {
            super.out(aST);
        }
        if (aST instanceof ParameterNode) {
            this.collectedParameters.add(((ParameterNode)aST).getHqlParameterSpecification());
        } else if (aST instanceof ParameterContainer && ((ParameterContainer)((Object)aST)).hasEmbeddedParameters() && (parameterSpecificationArray = ((ParameterContainer)((Object)aST)).getEmbeddedParameters()) != null) {
            this.collectedParameters.addAll(Arrays.asList(parameterSpecificationArray));
        }
    }

    protected void commaBetweenParameters(String string) {
        this.writer.commaBetweenParameters(string);
    }

    public void reportError(RecognitionException recognitionException) {
        this.parseErrorHandler.reportError(recognitionException);
    }

    public void reportError(String string) {
        this.parseErrorHandler.reportError(string);
    }

    public void reportWarning(String string) {
        this.parseErrorHandler.reportWarning(string);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public SqlGenerator(SessionFactoryImplementor sessionFactoryImplementor) {
        this.parseErrorHandler = new ErrorCounter();
        this.sessionFactory = sessionFactoryImplementor;
    }

    public String getSQL() {
        return this.getStringBuffer().toString();
    }

    protected void optionalSpace() {
        int n = this.getLastChar();
        switch (n) {
            case -1: {
                return;
            }
            case 32: {
                return;
            }
            case 41: {
                return;
            }
            case 40: {
                return;
            }
        }
        this.out(" ");
    }

    protected void beginFunctionTemplate(AST aST, AST aST2) {
        FunctionNode functionNode = (FunctionNode)((Object)aST);
        SQLFunction sQLFunction = functionNode.getSQLFunction();
        if (sQLFunction == null) {
            super.beginFunctionTemplate(aST, aST2);
        } else {
            this.outputStack.addFirst(this.writer);
            this.writer = new FunctionArguments();
        }
    }

    protected void endFunctionTemplate(AST aST) {
        FunctionNode functionNode = (FunctionNode)((Object)aST);
        SQLFunction sQLFunction = functionNode.getSQLFunction();
        if (sQLFunction == null) {
            super.endFunctionTemplate(aST);
        } else {
            Type type = functionNode.getFirstArgumentType();
            FunctionArguments functionArguments = (FunctionArguments)this.writer;
            this.writer = this.outputStack.removeFirst();
            this.out(sQLFunction.render(type, functionArguments.getArgs(), this.sessionFactory));
        }
    }

    public static void panic() {
        throw new QueryException("TreeWalker: panic");
    }

    protected void fromFragmentSeparator(AST aST) {
        FromElement fromElement;
        AST aST2 = aST.getNextSibling();
        if (aST2 == null || !this.hasText(aST)) {
            return;
        }
        FromElement fromElement2 = (FromElement)aST;
        for (fromElement = (FromElement)aST2; fromElement != null && !this.hasText(fromElement); fromElement = (FromElement)fromElement.getNextSibling()) {
        }
        if (fromElement == null) {
            return;
        }
        if (!this.hasText(fromElement)) {
            return;
        }
        if (fromElement.getRealOrigin() == fromElement2 || fromElement.getRealOrigin() != null && fromElement.getRealOrigin() == fromElement2.getRealOrigin()) {
            if (fromElement.getJoinSequence() != null && fromElement.getJoinSequence().isThetaStyle()) {
                this.writeCrossJoinSeparator();
            } else {
                this.out(" ");
            }
        } else {
            this.writeCrossJoinSeparator();
        }
    }

    private void writeCrossJoinSeparator() {
        if (REGRESSION_STYLE_CROSS_JOINS) {
            this.out(", ");
        } else {
            this.out(this.sessionFactory.getDialect().getCrossJoinSeparator());
        }
    }

    protected void nestedFromFragment(AST aST, AST aST2) {
        if (aST != null && this.hasText(aST)) {
            if (aST2 != null && this.hasText(aST2)) {
                FromElement fromElement = (FromElement)aST2;
                FromElement fromElement2 = (FromElement)aST;
                if (fromElement2.getRealOrigin() == fromElement) {
                    if (fromElement2.getJoinSequence() != null && fromElement2.getJoinSequence().isThetaStyle()) {
                        this.out(", ");
                    } else {
                        this.out(" ");
                    }
                } else {
                    this.out(", ");
                }
            }
            this.out(aST);
        }
    }

    class DefaultWriter
    implements SqlWriter {
        DefaultWriter() {
        }

        public void clause(String string) {
            SqlGenerator.this.getStringBuffer().append(string);
        }

        public void commaBetweenParameters(String string) {
            SqlGenerator.this.getStringBuffer().append(string);
        }
    }

    class FunctionArguments
    implements SqlWriter {
        private int argInd;
        private final List<String> args = new ArrayList<String>(3);

        FunctionArguments() {
        }

        public void clause(String string) {
            if (this.argInd == this.args.size()) {
                this.args.add(string);
            } else {
                this.args.set(this.argInd, this.args.get(this.argInd) + string);
            }
        }

        public void commaBetweenParameters(String string) {
            ++this.argInd;
        }

        public List getArgs() {
            return this.args;
        }
    }

    static interface SqlWriter {
        public void clause(String var1);

        public void commaBetweenParameters(String var1);
    }
}

