/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.transaction.IsolatedWork;
import org.hibernate.engine.transaction.Isolater;
import org.hibernate.event.EventSource;
import org.hibernate.hql.antlr.SqlGeneratorBase;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.StatementExecutor;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InsertSelect;
import org.hibernate.sql.Select;
import org.hibernate.sql.SelectFragment;
import org.hibernate.util.JDBCExceptionReporter;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatementExecutor
implements StatementExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStatementExecutor.class);
    private final Logger log;
    private final HqlSqlWalker walker;
    private List idSelectParameterSpecifications = Collections.EMPTY_LIST;
    private static JDBCExceptionReporter.WarningHandler CREATION_WARNING_HANDLER = new JDBCExceptionReporter.WarningHandlerLoggingSupport(){

        public boolean doProcess() {
            return LOG.isDebugEnabled();
        }

        public void prepare(SQLWarning sQLWarning) {
            LOG.debug("Warnings creating temp table", sQLWarning);
        }

        protected void logWarning(String string, String string2) {
            LOG.debug(string);
            LOG.debug(string2);
        }
    };

    public AbstractStatementExecutor(HqlSqlWalker hqlSqlWalker, Logger logger) {
        this.walker = hqlSqlWalker;
        this.log = logger;
    }

    protected HqlSqlWalker getWalker() {
        return this.walker;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.walker.getSessionFactoryHelper().getFactory();
    }

    protected List getIdSelectParameterSpecifications() {
        return this.idSelectParameterSpecifications;
    }

    protected abstract Queryable[] getAffectedQueryables();

    protected String generateIdInsertSelect(Queryable queryable, String string, AST aST) {
        Object object;
        Select select = new Select(this.getFactory().getDialect());
        SelectFragment selectFragment = new SelectFragment().addColumns(string, queryable.getIdentifierColumnNames(), queryable.getIdentifierColumnNames());
        select.setSelectClause(selectFragment.toFragmentString().substring(2));
        String string2 = queryable.getTableName();
        String string3 = queryable.fromJoinFragment(string, true, false);
        String string4 = queryable.whereJoinFragment(string, true, false);
        select.setFromClause(string2 + ' ' + string + string3);
        if (string4 == null) {
            string4 = "";
        } else if ((string4 = string4.trim()).startsWith("and")) {
            string4 = string4.substring(4);
        }
        String string5 = "";
        if (aST.getNumberOfChildren() != 0) {
            try {
                object = new SqlGenerator(this.getFactory());
                ((SqlGeneratorBase)object).whereClause(aST);
                string5 = ((SqlGenerator)object).getSQL().substring(7);
                this.idSelectParameterSpecifications = ((SqlGenerator)object).getCollectedParameters();
            }
            catch (RecognitionException recognitionException) {
                throw new HibernateException("Unable to generate id select for DML operation", recognitionException);
            }
            if (string4.length() > 0) {
                string4 = string4 + " and ";
            }
        }
        select.setWhereClause(string4 + string5);
        object = new InsertSelect(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            ((InsertSelect)object).setComment("insert-select for " + queryable.getEntityName() + " ids");
        }
        ((InsertSelect)object).setTableName(queryable.getTemporaryIdTableName());
        ((InsertSelect)object).setSelect(select);
        return ((InsertSelect)object).toStatementString();
    }

    protected String generateIdSubselect(Queryable queryable) {
        return "select " + StringHelper.join(", ", queryable.getIdentifierColumnNames()) + " from " + queryable.getTemporaryIdTableName();
    }

    protected void createTemporaryTableIfNecessary(final Queryable queryable, SessionImplementor sessionImplementor) {
        IsolatedWork isolatedWork = new IsolatedWork(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doWork(Connection connection) throws HibernateException {
                try {
                    Statement statement = connection.createStatement();
                    try {
                        statement.executeUpdate(queryable.getTemporaryIdTableDDL());
                        JDBCExceptionReporter.handleAndClearWarnings(statement, CREATION_WARNING_HANDLER);
                    }
                    finally {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Exception exception) {
                    AbstractStatementExecutor.this.log.debug("unable to create temporary id table [" + exception.getMessage() + "]");
                }
            }
        };
        if (this.shouldIsolateTemporaryTableDDL()) {
            if (this.getFactory().getSettings().isDataDefinitionInTransactionSupported()) {
                Isolater.doIsolatedWork(isolatedWork, sessionImplementor);
            } else {
                Isolater.doNonTransactedWork(isolatedWork, sessionImplementor);
            }
        } else {
            isolatedWork.doWork(sessionImplementor.getJDBCContext().getConnectionManager().getConnection());
            sessionImplementor.getJDBCContext().getConnectionManager().afterStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void dropTemporaryTableIfNecessary(final Queryable queryable, final SessionImplementor sessionImplementor) {
        PreparedStatement preparedStatement;
        if (this.getFactory().getDialect().dropTemporaryTableAfterUse()) {
            IsolatedWork isolatedWork = new IsolatedWork(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void doWork(Connection connection) throws HibernateException {
                    String string = sessionImplementor.getFactory().getSettings().getDialect().getDropTemporaryTableString() + ' ' + queryable.getTemporaryIdTableName();
                    try {
                        Statement statement = connection.createStatement();
                        try {
                            statement = connection.createStatement();
                            statement.executeUpdate(string);
                        }
                        finally {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Exception exception) {
                        AbstractStatementExecutor.this.log.warn("unable to drop temporary id table after use [" + exception.getMessage() + "]");
                    }
                }
            };
            if (this.shouldIsolateTemporaryTableDDL()) {
                if (this.getFactory().getSettings().isDataDefinitionInTransactionSupported()) {
                    Isolater.doIsolatedWork(isolatedWork, sessionImplementor);
                    return;
                } else {
                    Isolater.doNonTransactedWork(isolatedWork, sessionImplementor);
                }
                return;
            } else {
                isolatedWork.doWork(sessionImplementor.getJDBCContext().getConnectionManager().getConnection());
                sessionImplementor.getJDBCContext().getConnectionManager().afterStatement();
            }
            return;
        } else {
            preparedStatement = null;
            preparedStatement = sessionImplementor.getBatcher().prepareStatement("delete from " + queryable.getTemporaryIdTableName());
            preparedStatement.executeUpdate();
            if (preparedStatement == null) return;
            try {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
                return;
            }
            catch (Throwable throwable) {}
        }
        return;
        catch (Throwable throwable) {
            try {
                this.log.warn("unable to cleanup temporary id table after use [" + throwable + "]");
                if (preparedStatement == null) return;
            }
            catch (Throwable throwable2) {
                if (preparedStatement == null) throw throwable2;
                try {
                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable2;
            }
            try {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
                return;
            }
            catch (Throwable throwable4) {}
            return;
        }
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor sessionImplementor) {
        BulkOperationCleanupAction bulkOperationCleanupAction = new BulkOperationCleanupAction(sessionImplementor, this.getAffectedQueryables());
        if (sessionImplementor.isEventSource()) {
            ((EventSource)sessionImplementor).getActionQueue().addAction(bulkOperationCleanupAction);
        } else {
            bulkOperationCleanupAction.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, sessionImplementor);
        }
    }

    protected boolean shouldIsolateTemporaryTableDDL() {
        Boolean bl = this.getFactory().getDialect().performTemporaryTableDDLInIsolation();
        if (bl != null) {
            return bl;
        }
        return this.getFactory().getSettings().isDataDefinitionImplicitCommit();
    }
}

