/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.AbstractStatementExecutor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicExecutor
extends AbstractStatementExecutor {
    private static final Logger log = LoggerFactory.getLogger(BasicExecutor.class);
    private final Queryable persister;
    private final String sql;
    private final List parameterSpecifications;

    public BasicExecutor(HqlSqlWalker hqlSqlWalker, Queryable queryable) {
        super(hqlSqlWalker, log);
        this.persister = queryable;
        try {
            SqlGenerator sqlGenerator = new SqlGenerator(this.getFactory());
            sqlGenerator.statement(hqlSqlWalker.getAST());
            this.sql = sqlGenerator.getSQL();
            sqlGenerator.getParseErrorHandler().throwQueryException();
            this.parameterSpecifications = sqlGenerator.getCollectedParameters();
        }
        catch (RecognitionException recognitionException) {
            throw QuerySyntaxException.convert(recognitionException);
        }
    }

    public String[] getSqlStatements() {
        return new String[]{this.sql};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        int n;
        block8: {
            this.coordinateSharedCacheCleanup(sessionImplementor);
            PreparedStatement preparedStatement = null;
            RowSelection rowSelection = queryParameters.getRowSelection();
            try {
                preparedStatement = sessionImplementor.getBatcher().prepareStatement(this.sql);
                Iterator iterator = this.parameterSpecifications.iterator();
                int n2 = 1;
                while (iterator.hasNext()) {
                    ParameterSpecification parameterSpecification = (ParameterSpecification)iterator.next();
                    n2 += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n2);
                }
                if (rowSelection != null && rowSelection.getTimeout() != null) {
                    preparedStatement.setQueryTimeout(rowSelection.getTimeout());
                }
                n = preparedStatement.executeUpdate();
                if (preparedStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    }
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not execute update query", this.sql);
                }
            }
            sessionImplementor.getBatcher().closeStatement(preparedStatement);
        }
        return n;
    }

    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

