/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.exec.AbstractStatementExecutor;
import org.hibernate.hql.ast.tree.DeleteStatement;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Delete;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableDeleteExecutor
extends AbstractStatementExecutor {
    private static final Logger log = LoggerFactory.getLogger(MultiTableDeleteExecutor.class);
    private final Queryable persister;
    private final String idInsertSelect;
    private final String[] deletes;

    public MultiTableDeleteExecutor(HqlSqlWalker hqlSqlWalker) {
        super(hqlSqlWalker, log);
        if (!hqlSqlWalker.getSessionFactoryHelper().getFactory().getDialect().supportsTemporaryTables()) {
            throw new HibernateException("cannot doAfterTransactionCompletion multi-table deletes using dialect not supporting temp tables");
        }
        DeleteStatement deleteStatement = (DeleteStatement)hqlSqlWalker.getAST();
        FromElement fromElement = deleteStatement.getFromClause().getFromElement();
        String string = fromElement.getTableAlias();
        this.persister = fromElement.getQueryable();
        this.idInsertSelect = this.generateIdInsertSelect(this.persister, string, deleteStatement.getWhereClause());
        log.trace("Generated ID-INSERT-SELECT SQL (multi-table delete) : " + this.idInsertSelect);
        String[] stringArray = this.persister.getConstraintOrderedTableNameClosure();
        String[][] stringArray2 = this.persister.getContraintOrderedTableKeyColumnClosure();
        String string2 = this.generateIdSubselect(this.persister);
        this.deletes = new String[stringArray.length];
        for (int i = stringArray.length - 1; i >= 0; --i) {
            Delete delete = new Delete().setTableName(stringArray[i]).setWhere("(" + StringHelper.join(", ", stringArray2[i]) + ") IN (" + string2 + ")");
            if (this.getFactory().getSettings().isCommentsEnabled()) {
                delete.setComment("bulk delete");
            }
            this.deletes[i] = delete.toStatementString();
        }
    }

    public String[] getSqlStatements() {
        return this.deletes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        this.coordinateSharedCacheCleanup(sessionImplementor);
        this.createTemporaryTableIfNecessary(this.persister, sessionImplementor);
        try {
            int n;
            PreparedStatement preparedStatement = null;
            int n2 = 0;
            try {
                try {
                    preparedStatement = sessionImplementor.getBatcher().prepareStatement(this.idInsertSelect);
                    Iterator iterator = this.getIdSelectParameterSpecifications().iterator();
                    int n3 = 1;
                    while (iterator.hasNext()) {
                        ParameterSpecification parameterSpecification = (ParameterSpecification)iterator.next();
                        n3 += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n3);
                    }
                    n2 = preparedStatement.executeUpdate();
                }
                finally {
                    if (preparedStatement != null) {
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not insert/select ids for bulk delete", this.idInsertSelect);
            }
            for (n = 0; n < this.deletes.length; ++n) {
                try {
                    try {
                        preparedStatement = sessionImplementor.getBatcher().prepareStatement(this.deletes[n]);
                        preparedStatement.executeUpdate();
                        continue;
                    }
                    finally {
                        if (preparedStatement != null) {
                            sessionImplementor.getBatcher().closeStatement(preparedStatement);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "error performing bulk delete", this.deletes[n]);
                }
            }
            n = n2;
            return n;
        }
        finally {
            this.dropTemporaryTableIfNecessary(this.persister, sessionImplementor);
        }
    }

    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

