/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.collections.AST;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.tree.UnaryLogicOperatorNode;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public abstract class AbstractNullnessCheckNode
extends UnaryLogicOperatorNode {
    public void initialize() {
        Type type = AbstractNullnessCheckNode.extractDataType(this.getOperand());
        if (type == null) {
            return;
        }
        SessionFactoryImplementor sessionFactoryImplementor = this.getSessionFactoryHelper().getFactory();
        int n = type.getColumnSpan(sessionFactoryImplementor);
        if (n > 1) {
            this.mutateRowValueConstructorSyntax(n);
        }
    }

    protected abstract int getExpansionConnectorType();

    protected abstract String getExpansionConnectorText();

    private void mutateRowValueConstructorSyntax(int n) {
        int n2 = this.getType();
        String string = this.getText();
        int n3 = this.getExpansionConnectorType();
        String string2 = this.getExpansionConnectorText();
        this.setType(n3);
        this.setText(string2);
        String[] stringArray = AbstractNullnessCheckNode.extractMutationTexts(this.getOperand(), n);
        AST aST = this;
        for (int i = n - 1; i > 0; --i) {
            AST aST2;
            AST aST3;
            AST aST4;
            if (i == 1) {
                aST4 = this.getASTFactory().create(n2, string);
                aST3 = this.getASTFactory().create(142, stringArray[0]);
                aST4.setFirstChild(aST3);
                aST.setFirstChild(aST4);
                aST2 = this.getASTFactory().create(n2, string);
                AST aST5 = this.getASTFactory().create(142, stringArray[1]);
                aST2.setFirstChild(aST5);
                aST4.setNextSibling(aST2);
                continue;
            }
            aST4 = this.getASTFactory().create(n2, string);
            aST3 = this.getASTFactory().create(142, stringArray[i]);
            aST4.setFirstChild(aST3);
            aST2 = this.getASTFactory().create(n3, string2);
            aST.setFirstChild(aST2);
            aST2.setNextSibling(aST4);
            aST = aST2;
        }
    }

    private static Type extractDataType(Node node) {
        Type type = null;
        if (node instanceof SqlNode) {
            type = ((SqlNode)node).getDataType();
        }
        if (type == null && node instanceof ExpectedTypeAwareNode) {
            type = ((ExpectedTypeAwareNode)((Object)node)).getExpectedType();
        }
        return type;
    }

    private static String[] extractMutationTexts(Node node, int n) {
        if (node instanceof ParameterNode) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "?";
            }
            return stringArray;
        }
        if (node.getType() == 92) {
            String[] stringArray = new String[node.getNumberOfChildren()];
            int n2 = 0;
            for (AST aST = node.getFirstChild(); aST != null; aST = aST.getNextSibling()) {
                stringArray[n2++] = aST.getText();
            }
            return stringArray;
        }
        if (node instanceof SqlNode) {
            String[] stringArray;
            String string = node.getText();
            if (string.startsWith("(")) {
                string = string.substring(1);
            }
            if (string.endsWith(")")) {
                string = string.substring(0, string.length() - 1);
            }
            if (n != (stringArray = StringHelper.split(", ", string)).length) {
                throw new HibernateException("SqlNode's text did not reference expected number of columns");
            }
            return stringArray;
        }
        throw new HibernateException("dont know how to extract row value elements from node : " + node);
    }
}

