/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.hql.ast.tree.AbstractSelectExpression;
import org.hibernate.hql.ast.tree.FunctionNode;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.util.ColumnHelper;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateNode
extends AbstractSelectExpression
implements SelectExpression,
FunctionNode {
    private static final Logger log = LoggerFactory.getLogger(AggregateNode.class);
    private SQLFunction sqlFunction;

    public SQLFunction getSQLFunction() {
        return this.sqlFunction;
    }

    public void resolve() {
        this.resolveFunction();
    }

    private SQLFunction resolveFunction() {
        if (this.sqlFunction == null) {
            String string = this.getText();
            this.sqlFunction = this.getSessionFactoryHelper().findSQLFunction(this.getText());
            if (this.sqlFunction == null) {
                log.info("Could not resolve aggregate function {}; using standard definition", (Object)string);
                this.sqlFunction = new StandardSQLFunction(string);
            }
        }
        return this.sqlFunction;
    }

    public Type getFirstArgumentType() {
        AST aST = this.getFirstChild();
        while (aST != null) {
            if (!(aST instanceof SqlNode)) continue;
            Type type = ((SqlNode)aST).getDataType();
            if (type != null) {
                return type;
            }
            aST = aST.getNextSibling();
        }
        return null;
    }

    public Type getDataType() {
        return this.getSessionFactoryHelper().findFunctionReturnType(this.getText(), this.resolveFunction(), this.getFirstChild());
    }

    public void setScalarColumnText(int n) throws SemanticException {
        ColumnHelper.generateSingleScalarColumn(this, n);
    }

    public boolean isScalar() throws SemanticException {
        return true;
    }
}

