/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.collections.AST;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.QueryException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;

public class AssignmentSpecification {
    private final Set tableNames;
    private final ParameterSpecification[] hqlParameters;
    private final AST eq;
    private final SessionFactoryImplementor factory;
    private String sqlAssignmentString;

    public AssignmentSpecification(AST aST, Queryable queryable) {
        int n;
        Object object;
        Object object2;
        if (aST.getType() != 102) {
            throw new QueryException("assignment in set-clause not associated with equals");
        }
        this.eq = aST;
        this.factory = queryable.getFactory();
        DotNode dotNode = (DotNode)aST.getFirstChild();
        SqlNode sqlNode = (SqlNode)dotNode.getNextSibling();
        this.validateLhs(dotNode);
        String string = dotNode.getPropertyPath();
        HashSet<String> hashSet = new HashSet<String>();
        if (queryable instanceof UnionSubclassEntityPersister) {
            object2 = (UnionSubclassEntityPersister)queryable;
            object = queryable.getConstraintOrderedTableNameClosure();
            n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                hashSet.add(object[i]);
            }
        } else {
            hashSet.add(queryable.getSubclassTableName(queryable.getSubclassPropertyTableNumber(string)));
        }
        this.tableNames = Collections.unmodifiableSet(hashSet);
        if (sqlNode == null) {
            this.hqlParameters = new ParameterSpecification[0];
        } else if (AssignmentSpecification.isParam(sqlNode)) {
            this.hqlParameters = new ParameterSpecification[]{((ParameterNode)sqlNode).getHqlParameterSpecification()};
        } else {
            object2 = ASTUtil.collectChildren(sqlNode, new ASTUtil.IncludePredicate(){

                public boolean include(AST aST) {
                    return AssignmentSpecification.isParam(aST);
                }
            });
            this.hqlParameters = new ParameterSpecification[object2.size()];
            object = object2.iterator();
            n = 0;
            while (object.hasNext()) {
                this.hqlParameters[n++] = ((ParameterNode)object.next()).getHqlParameterSpecification();
            }
        }
    }

    public boolean affectsTable(String string) {
        return this.tableNames.contains(string);
    }

    public ParameterSpecification[] getParameters() {
        return this.hqlParameters;
    }

    public String getSqlAssignmentFragment() {
        if (this.sqlAssignmentString == null) {
            try {
                SqlGenerator sqlGenerator = new SqlGenerator(this.factory);
                sqlGenerator.comparisonExpr(this.eq, false);
                this.sqlAssignmentString = sqlGenerator.getSQL();
            }
            catch (Throwable throwable) {
                throw new QueryException("cannot interpret set-clause assignment");
            }
        }
        return this.sqlAssignmentString;
    }

    private static boolean isParam(AST aST) {
        return aST.getType() == 123 || aST.getType() == 148;
    }

    private void validateLhs(FromReferenceNode fromReferenceNode) {
        if (!fromReferenceNode.isResolved()) {
            throw new UnsupportedOperationException("cannot validate assignablity of unresolved node");
        }
        if (fromReferenceNode.getDataType().isCollectionType()) {
            throw new QueryException("collections not assignable in update statements");
        }
        if (fromReferenceNode.getDataType().isComponentType()) {
            throw new QueryException("Components currently not assignable in update statements");
        }
        if (fromReferenceNode.getDataType().isEntityType()) {
            // empty if block
        }
        if (fromReferenceNode.getImpliedJoin() != null || fromReferenceNode.getFromElement().isImplied()) {
            throw new QueryException("Implied join paths are not assignable in update statements");
        }
    }
}

