/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.HqlSqlWalkerNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlFragment;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class BinaryLogicOperatorNode
extends HqlSqlWalkerNode
implements BinaryOperatorNode {
    public void initialize() throws SemanticException {
        Node node = this.getLeftHandOperand();
        if (node == null) {
            throw new SemanticException("left-hand operand of a binary operator was null");
        }
        Node node2 = this.getRightHandOperand();
        if (node2 == null) {
            throw new SemanticException("right-hand operand of a binary operator was null");
        }
        Type type = this.extractDataType(node);
        Type type2 = this.extractDataType(node2);
        if (type == null) {
            type = type2;
        }
        if (type2 == null) {
            type2 = type;
        }
        if (ExpectedTypeAwareNode.class.isAssignableFrom(node.getClass())) {
            ((ExpectedTypeAwareNode)((Object)node)).setExpectedType(type2);
        }
        if (ExpectedTypeAwareNode.class.isAssignableFrom(node2.getClass())) {
            ((ExpectedTypeAwareNode)((Object)node2)).setExpectedType(type);
        }
        this.mutateRowValueConstructorSyntaxesIfNecessary(type, type2);
    }

    protected final void mutateRowValueConstructorSyntaxesIfNecessary(Type type, Type type2) {
        SessionFactoryImplementor sessionFactoryImplementor = this.getSessionFactoryHelper().getFactory();
        if (type != null && type2 != null) {
            int n = this.getColumnSpan(type, sessionFactoryImplementor);
            if (n != this.getColumnSpan(type2, sessionFactoryImplementor)) {
                throw new TypeMismatchException("left and right hand sides of a binary logic operator were incompatibile [" + type.getName() + " : " + type2.getName() + "]");
            }
            if (n > 1 && !sessionFactoryImplementor.getDialect().supportsRowValueConstructorSyntax()) {
                this.mutateRowValueConstructorSyntax(n);
            }
        }
    }

    private int getColumnSpan(Type type, SessionFactoryImplementor sessionFactoryImplementor) {
        int n = type.getColumnSpan(sessionFactoryImplementor);
        if (n == 0 && type instanceof OneToOneType) {
            n = ((OneToOneType)type).getIdentifierOrUniqueKeyType(sessionFactoryImplementor).getColumnSpan(sessionFactoryImplementor);
        }
        return n;
    }

    private void mutateRowValueConstructorSyntax(int n) {
        int n2 = this.getType();
        String string = this.getText();
        this.setType(6);
        this.setText("AND");
        String[] stringArray = BinaryLogicOperatorNode.extractMutationTexts(this.getLeftHandOperand(), n);
        String[] stringArray2 = BinaryLogicOperatorNode.extractMutationTexts(this.getRightHandOperand(), n);
        ParameterSpecification parameterSpecification = this.getLeftHandOperand() == null || !ParameterNode.class.isInstance(this.getLeftHandOperand()) ? null : ((ParameterNode)this.getLeftHandOperand()).getHqlParameterSpecification();
        ParameterSpecification parameterSpecification2 = this.getRightHandOperand() == null || !ParameterNode.class.isInstance(this.getRightHandOperand()) ? null : ((ParameterNode)this.getRightHandOperand()).getHqlParameterSpecification();
        this.translate(n, n2, string, stringArray, stringArray2, parameterSpecification, parameterSpecification2, this);
    }

    protected void translate(int n, int n2, String string, String[] stringArray, String[] stringArray2, ParameterSpecification parameterSpecification, ParameterSpecification parameterSpecification2, AST aST) {
        for (int i = n - 1; i > 0; --i) {
            AST aST2;
            AST aST3;
            AST aST4;
            AST aST5;
            if (i == 1) {
                aST5 = this.getASTFactory().create(n2, string);
                aST4 = this.getASTFactory().create(142, stringArray[0]);
                aST3 = this.getASTFactory().create(142, stringArray2[0]);
                aST5.setFirstChild(aST4);
                aST4.setNextSibling(aST3);
                aST.setFirstChild(aST5);
                aST2 = this.getASTFactory().create(n2, string);
                AST aST6 = this.getASTFactory().create(142, stringArray[1]);
                AST aST7 = this.getASTFactory().create(142, stringArray2[1]);
                aST2.setFirstChild(aST6);
                aST6.setNextSibling(aST7);
                aST5.setNextSibling(aST2);
                SqlFragment sqlFragment = (SqlFragment)aST4;
                if (parameterSpecification != null) {
                    sqlFragment.addEmbeddedParameter(parameterSpecification);
                }
                if (parameterSpecification2 == null) continue;
                sqlFragment.addEmbeddedParameter(parameterSpecification2);
                continue;
            }
            aST5 = this.getASTFactory().create(n2, string);
            aST4 = this.getASTFactory().create(142, stringArray[i]);
            aST3 = this.getASTFactory().create(142, stringArray2[i]);
            aST5.setFirstChild(aST4);
            aST4.setNextSibling(aST3);
            aST2 = this.getASTFactory().create(6, "AND");
            aST.setFirstChild(aST2);
            aST2.setNextSibling(aST5);
            aST = aST2;
        }
    }

    protected static String[] extractMutationTexts(Node node, int n) {
        if (node instanceof ParameterNode) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "?";
            }
            return stringArray;
        }
        if (node.getType() == 92) {
            String[] stringArray = new String[node.getNumberOfChildren()];
            int n2 = 0;
            for (AST aST = node.getFirstChild(); aST != null; aST = aST.getNextSibling()) {
                stringArray[n2++] = aST.getText();
            }
            return stringArray;
        }
        if (node instanceof SqlNode) {
            String[] stringArray;
            String string = node.getText();
            if (string.startsWith("(")) {
                string = string.substring(1);
            }
            if (string.endsWith(")")) {
                string = string.substring(0, string.length() - 1);
            }
            if (n != (stringArray = StringHelper.split(", ", string)).length) {
                throw new HibernateException("SqlNode's text did not reference expected number of columns");
            }
            return stringArray;
        }
        throw new HibernateException("dont know how to extract row value elements from node : " + node);
    }

    protected Type extractDataType(Node node) {
        Type type = null;
        if (node instanceof SqlNode) {
            type = ((SqlNode)node).getDataType();
        }
        if (type == null && node instanceof ExpectedTypeAwareNode) {
            type = ((ExpectedTypeAwareNode)((Object)node)).getExpectedType();
        }
        return type;
    }

    public Type getDataType() {
        return Hibernate.BOOLEAN;
    }

    public Node getLeftHandOperand() {
        return (Node)this.getFirstChild();
    }

    public Node getRightHandOperand() {
        return (Node)this.getFirstChild().getNextSibling();
    }
}

