/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import org.hibernate.QueryException;
import org.hibernate.hql.NameGenerator;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromElementType;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class ComponentJoin
extends FromElement {
    private final String componentPath;
    private final ComponentType componentType;
    private final String componentProperty;
    private final String columns;

    public ComponentJoin(FromClause fromClause, FromElement fromElement, String string, String string2, ComponentType componentType) {
        super(fromClause, fromElement, string);
        this.componentPath = string2;
        this.componentType = componentType;
        this.componentProperty = StringHelper.unqualify(string2);
        fromClause.addJoinByPathMap(string2, this);
        this.initializeComponentJoin(new ComponentFromElementType(this));
        String[] stringArray = fromElement.getPropertyMapping("").toColumns(this.getTableAlias(), this.componentProperty);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string3);
        }
        this.columns = stringBuffer.toString();
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public String getComponentProperty() {
        return this.componentProperty;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public Type getDataType() {
        return this.getComponentType();
    }

    public String getIdentityColumn() {
        return this.columns;
    }

    public String getDisplayText() {
        return "ComponentJoin{path=" + this.getComponentPath() + ", type=" + this.componentType.getReturnedClass() + "}";
    }

    protected PropertyMapping getBasePropertyMapping() {
        return this.getOrigin().getPropertyMapping("");
    }

    private final class ComponentPropertyMapping
    implements PropertyMapping {
        private ComponentPropertyMapping() {
        }

        public Type getType() {
            return ComponentJoin.this.getComponentType();
        }

        public Type toType(String string) throws QueryException {
            return ComponentJoin.this.getBasePropertyMapping().toType(this.getPropertyPath(string));
        }

        protected String getPropertyPath(String string) {
            return ComponentJoin.this.getComponentPath() + '.' + string;
        }

        public String[] toColumns(String string, String string2) throws QueryException {
            return ComponentJoin.this.getBasePropertyMapping().toColumns(string, this.getPropertyPath(string2));
        }

        public String[] toColumns(String string) throws QueryException, UnsupportedOperationException {
            return ComponentJoin.this.getBasePropertyMapping().toColumns(this.getPropertyPath(string));
        }
    }

    public class ComponentFromElementType
    extends FromElementType {
        private final PropertyMapping propertyMapping;

        public ComponentFromElementType(FromElement fromElement) {
            super(fromElement);
            this.propertyMapping = new ComponentPropertyMapping();
        }

        public Type getDataType() {
            return ComponentJoin.this.getComponentType();
        }

        public QueryableCollection getQueryableCollection() {
            return null;
        }

        public PropertyMapping getPropertyMapping(String string) {
            return this.propertyMapping;
        }

        public Type getPropertyType(String string, String string2) {
            int n = ComponentJoin.this.getComponentType().getPropertyIndex(string);
            return ComponentJoin.this.getComponentType().getSubtypes()[n];
        }

        public String renderScalarIdentifierSelect(int n) {
            String[] stringArray = ComponentJoin.this.getBasePropertyMapping().toColumns(ComponentJoin.this.getTableAlias(), ComponentJoin.this.getComponentProperty());
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (i > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string).append(" as ").append(NameGenerator.scalarName(n, i));
            }
            return stringBuffer.toString();
        }
    }
}

