/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.ASTFactory;
import antlr.SemanticException;
import antlr.collections.AST;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.tree.ComponentJoin;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.AliasGenerator;
import org.hibernate.hql.ast.util.PathHelper;
import org.hibernate.hql.ast.util.SessionFactoryHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromElementFactory
implements SqlTokenTypes {
    private static final Logger log = LoggerFactory.getLogger(FromElementFactory.class);
    private FromClause fromClause;
    private FromElement origin;
    private String path;
    private String classAlias;
    private String[] columns;
    private boolean implied;
    private boolean inElementsFunction;
    private boolean collection;
    private QueryableCollection queryableCollection;
    private CollectionType collectionType;

    public FromElementFactory(FromClause fromClause, FromElement fromElement, String string) {
        this.fromClause = fromClause;
        this.origin = fromElement;
        this.path = string;
        this.collection = false;
    }

    public FromElementFactory(FromClause fromClause, FromElement fromElement, String string, String string2, String[] stringArray, boolean bl) {
        this(fromClause, fromElement, string);
        this.classAlias = string2;
        this.columns = stringArray;
        this.implied = bl;
        this.collection = true;
    }

    FromElement addFromElement() throws SemanticException {
        Object object;
        FromElement fromElement;
        FromClause fromClause = this.fromClause.getParentFromClause();
        if (fromClause != null && (fromElement = fromClause.getFromElement((String)(object = PathHelper.getAlias(this.path)))) != null) {
            return this.createFromElementInSubselect(this.path, (String)object, fromElement, this.classAlias);
        }
        object = this.fromClause.getSessionFactoryHelper().requireClassPersister(this.path);
        fromElement = this.createAndAddFromElement(this.path, this.classAlias, (EntityPersister)object, (EntityType)((Queryable)object).getType(), null);
        this.fromClause.getWalker().addQuerySpaces(object.getQuerySpaces());
        return fromElement;
    }

    private FromElement createFromElementInSubselect(String string, String string2, FromElement fromElement, String string3) throws SemanticException {
        if (log.isDebugEnabled()) {
            log.debug("createFromElementInSubselect() : path = " + string);
        }
        FromElement fromElement2 = this.evaluateFromElementPath(string, string3);
        EntityPersister entityPersister = fromElement2.getEntityPersister();
        String string4 = null;
        boolean bl = string2.equals(fromElement.getClassAlias());
        string4 = bl ? fromElement2.getTableAlias() : null;
        if (fromElement2.getFromClause() != this.fromClause) {
            if (log.isDebugEnabled()) {
                log.debug("createFromElementInSubselect() : creating a new FROM element...");
            }
            fromElement2 = this.createFromElement(entityPersister);
            this.initializeAndAddFromElement(fromElement2, string, string3, entityPersister, (EntityType)((Queryable)entityPersister).getType(), string4);
        }
        if (log.isDebugEnabled()) {
            log.debug("createFromElementInSubselect() : " + string + " -> " + fromElement2);
        }
        return fromElement2;
    }

    private FromElement evaluateFromElementPath(String string, String string2) throws SemanticException {
        ASTFactory aSTFactory = this.fromClause.getASTFactory();
        FromReferenceNode fromReferenceNode = (FromReferenceNode)PathHelper.parsePath(string, aSTFactory);
        fromReferenceNode.recursiveResolve(0, false, string2, null);
        if (fromReferenceNode.getImpliedJoin() != null) {
            return fromReferenceNode.getImpliedJoin();
        }
        return fromReferenceNode.getFromElement();
    }

    FromElement createCollectionElementsJoin(QueryableCollection queryableCollection, String string) throws SemanticException {
        JoinSequence joinSequence = this.fromClause.getSessionFactoryHelper().createCollectionJoinSequence(queryableCollection, string);
        this.queryableCollection = queryableCollection;
        return this.createCollectionJoin(joinSequence, null);
    }

    FromElement createCollection(QueryableCollection queryableCollection, String string, int n, boolean bl, boolean bl2) throws SemanticException {
        FromElement fromElement;
        Object object;
        Object object2;
        boolean bl3;
        if (!this.collection) {
            throw new IllegalStateException("FromElementFactory not initialized for collections!");
        }
        this.inElementsFunction = bl2;
        this.queryableCollection = queryableCollection;
        this.collectionType = queryableCollection.getCollectionType();
        String string2 = this.fromClause.getAliasGenerator().createName(string);
        boolean bl4 = bl3 = this.fromClause.isSubQuery() && !this.implied;
        if (bl3 && ((object2 = this.fromClause.getFromElement((String)(object = StringHelper.root(this.path)))) == null || ((FromElement)object2).getFromClause() != this.fromClause)) {
            this.implied = true;
        }
        if (bl3 && DotNode.useThetaStyleImplicitJoins) {
            this.implied = true;
        }
        if ((object = queryableCollection.getElementType()).isEntityType()) {
            fromElement = this.createEntityAssociation(string, string2, n);
        } else if (object.isComponentType()) {
            object2 = this.createJoinSequence(string2, n);
            fromElement = this.createCollectionJoin((JoinSequence)object2, string2);
        } else {
            object2 = this.createJoinSequence(string2, n);
            fromElement = this.createCollectionJoin((JoinSequence)object2, string2);
        }
        fromElement.setRole(string);
        fromElement.setQueryableCollection(queryableCollection);
        if (this.implied) {
            fromElement.setIncludeSubclasses(false);
        }
        if (bl3) {
            fromElement.setInProjectionList(true);
        }
        if (bl) {
            fromElement.setFetch(true);
        }
        return fromElement;
    }

    FromElement createEntityJoin(String string, String string2, JoinSequence joinSequence, boolean bl, boolean bl2, EntityType entityType) throws SemanticException {
        FromElement fromElement = this.createJoin(string, string2, joinSequence, entityType, false);
        fromElement.setFetch(bl);
        EntityPersister entityPersister = fromElement.getEntityPersister();
        int n = entityPersister.getQuerySpaces().length;
        if (n > 1 && this.implied && !fromElement.useFromFragment()) {
            if (log.isDebugEnabled()) {
                log.debug("createEntityJoin() : Implied multi-table entity join");
            }
            fromElement.setUseFromFragment(true);
        }
        if (this.implied && bl2) {
            joinSequence.setUseThetaStyle(false);
            fromElement.setUseFromFragment(true);
            fromElement.setImpliedInFromClause(true);
        }
        if (fromElement.getWalker().isSubQuery() && (fromElement.getFromClause() != fromElement.getOrigin().getFromClause() || DotNode.useThetaStyleImplicitJoins)) {
            fromElement.setType(134);
            joinSequence.setUseThetaStyle(true);
            fromElement.setUseFromFragment(false);
        }
        return fromElement;
    }

    public FromElement createComponentJoin(ComponentType componentType) {
        return new ComponentJoin(this.fromClause, this.origin, this.classAlias, this.path, componentType);
    }

    FromElement createElementJoin(QueryableCollection queryableCollection) throws SemanticException {
        this.implied = true;
        this.inElementsFunction = true;
        Type type = queryableCollection.getElementType();
        if (!type.isEntityType()) {
            throw new IllegalArgumentException("Cannot create element join for a collection of non-entities!");
        }
        this.queryableCollection = queryableCollection;
        SessionFactoryHelper sessionFactoryHelper = this.fromClause.getSessionFactoryHelper();
        FromElement fromElement = null;
        String string = null;
        EntityPersister entityPersister = queryableCollection.getElementPersister();
        string = this.fromClause.getAliasGenerator().createName(entityPersister.getEntityName());
        String string2 = entityPersister.getEntityName();
        EntityPersister entityPersister2 = sessionFactoryHelper.requireClassPersister(string2);
        fromElement = this.createAndAddFromElement(string2, this.classAlias, entityPersister2, (EntityType)queryableCollection.getElementType(), string);
        if (this.implied) {
            fromElement.setIncludeSubclasses(false);
        }
        this.fromClause.addCollectionJoinFromElementByPath(this.path, fromElement);
        this.fromClause.getWalker().addQuerySpaces(entityPersister.getQuerySpaces());
        CollectionType collectionType = queryableCollection.getCollectionType();
        String string3 = collectionType.getRole();
        String string4 = this.origin.getTableAlias();
        String[] stringArray = sessionFactoryHelper.getCollectionElementColumns(string3, string4);
        AssociationType associationType = sessionFactoryHelper.getElementAssociationType(collectionType);
        int n = 0;
        JoinSequence joinSequence = sessionFactoryHelper.createJoinSequence(this.implied, associationType, string, n, stringArray);
        FromElement fromElement2 = this.initializeJoin(this.path, fromElement, joinSequence, stringArray, this.origin, false);
        fromElement2.setUseFromFragment(true);
        fromElement2.setCollectionTableAlias(string4);
        return fromElement2;
    }

    private FromElement createCollectionJoin(JoinSequence joinSequence, String string) throws SemanticException {
        String string2 = this.queryableCollection.getTableName();
        AST aST = this.createFromElement(string2);
        FromElement fromElement = (FromElement)aST;
        Type type = this.queryableCollection.getElementType();
        if (type.isCollectionType()) {
            throw new SemanticException("Collections of collections are not supported!");
        }
        fromElement.initializeCollection(this.fromClause, this.classAlias, string);
        fromElement.setType(136);
        fromElement.setIncludeSubclasses(false);
        fromElement.setCollectionJoin(true);
        fromElement.setJoinSequence(joinSequence);
        fromElement.setOrigin(this.origin, false);
        fromElement.setCollectionTableAlias(string);
        this.origin.setText("");
        this.origin.setCollectionJoin(true);
        this.fromClause.addCollectionJoinFromElementByPath(this.path, fromElement);
        this.fromClause.getWalker().addQuerySpaces(this.queryableCollection.getCollectionSpaces());
        return fromElement;
    }

    private FromElement createEntityAssociation(String string, String string2, int n) throws SemanticException {
        FromElement fromElement;
        Queryable queryable = (Queryable)this.queryableCollection.getElementPersister();
        String string3 = queryable.getEntityName();
        if (this.queryableCollection.isOneToMany()) {
            if (log.isDebugEnabled()) {
                log.debug("createEntityAssociation() : One to many - path = " + this.path + " role = " + string + " associatedEntityName = " + string3);
            }
            JoinSequence joinSequence = this.createJoinSequence(string2, n);
            fromElement = this.createJoin(string3, string2, joinSequence, (EntityType)this.queryableCollection.getElementType(), false);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("createManyToMany() : path = " + this.path + " role = " + string + " associatedEntityName = " + string3);
            }
            fromElement = this.createManyToMany(string, string3, string2, queryable, (EntityType)this.queryableCollection.getElementType(), n);
            this.fromClause.getWalker().addQuerySpaces(this.queryableCollection.getCollectionSpaces());
        }
        fromElement.setCollectionTableAlias(string2);
        return fromElement;
    }

    private FromElement createJoin(String string, String string2, JoinSequence joinSequence, EntityType entityType, boolean bl) throws SemanticException {
        EntityPersister entityPersister = this.fromClause.getSessionFactoryHelper().requireClassPersister(string);
        FromElement fromElement = this.createAndAddFromElement(string, this.classAlias, entityPersister, entityType, string2);
        return this.initializeJoin(this.path, fromElement, joinSequence, this.getColumns(), this.origin, bl);
    }

    private FromElement createManyToMany(String string, String string2, String string3, Queryable queryable, EntityType entityType, int n) throws SemanticException {
        FromElement fromElement;
        SessionFactoryHelper sessionFactoryHelper = this.fromClause.getSessionFactoryHelper();
        if (this.inElementsFunction) {
            JoinSequence joinSequence = this.createJoinSequence(string3, n);
            fromElement = this.createJoin(string2, string3, joinSequence, entityType, true);
        } else {
            String string4 = this.fromClause.getAliasGenerator().createName(queryable.getEntityName());
            String[] stringArray = sessionFactoryHelper.getCollectionElementColumns(string, string3);
            JoinSequence joinSequence = this.createJoinSequence(string3, n);
            joinSequence.addJoin(sessionFactoryHelper.getElementAssociationType(this.collectionType), string4, n, stringArray);
            fromElement = this.createJoin(string2, string4, joinSequence, entityType, false);
            fromElement.setUseFromFragment(true);
        }
        return fromElement;
    }

    private JoinSequence createJoinSequence(String string, int n) {
        SessionFactoryHelper sessionFactoryHelper = this.fromClause.getSessionFactoryHelper();
        String[] stringArray = this.getColumns();
        if (this.collectionType == null) {
            throw new IllegalStateException("collectionType is null!");
        }
        return sessionFactoryHelper.createJoinSequence(this.implied, this.collectionType, string, n, stringArray);
    }

    private FromElement createAndAddFromElement(String string, String string2, EntityPersister entityPersister, EntityType entityType, String string3) {
        if (!(entityPersister instanceof Joinable)) {
            throw new IllegalArgumentException("EntityPersister " + entityPersister + " does not implement Joinable!");
        }
        FromElement fromElement = this.createFromElement(entityPersister);
        this.initializeAndAddFromElement(fromElement, string, string2, entityPersister, entityType, string3);
        return fromElement;
    }

    private void initializeAndAddFromElement(FromElement fromElement, String string, String string2, EntityPersister entityPersister, EntityType entityType, String string3) {
        if (string3 == null) {
            AliasGenerator aliasGenerator = this.fromClause.getAliasGenerator();
            string3 = aliasGenerator.createName(entityPersister.getEntityName());
        }
        fromElement.initializeEntity(this.fromClause, string, entityPersister, entityType, string2, string3);
    }

    private FromElement createFromElement(EntityPersister entityPersister) {
        Joinable joinable = (Joinable)((Object)entityPersister);
        String string = joinable.getTableName();
        AST aST = this.createFromElement(string);
        FromElement fromElement = (FromElement)aST;
        return fromElement;
    }

    private AST createFromElement(String string) {
        AST aST = ASTUtil.create(this.fromClause.getASTFactory(), this.implied ? 135 : 134, string);
        aST.setType(134);
        return aST;
    }

    private FromElement initializeJoin(String string, FromElement fromElement, JoinSequence joinSequence, String[] stringArray, FromElement fromElement2, boolean bl) {
        fromElement.setType(136);
        fromElement.setJoinSequence(joinSequence);
        fromElement.setColumns(stringArray);
        fromElement.setOrigin(fromElement2, bl);
        this.fromClause.addJoinByPathMap(string, fromElement);
        return fromElement;
    }

    private String[] getColumns() {
        if (this.columns == null) {
            throw new IllegalStateException("No foriegn key columns were supplied!");
        }
        return this.columns;
    }
}

