/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.io.Serializable;
import java.util.ArrayList;
import org.hibernate.engine.Mapping;
import org.hibernate.hql.ast.tree.BinaryLogicOperatorNode;
import org.hibernate.hql.ast.tree.BinaryOperatorNode;
import org.hibernate.hql.ast.tree.ExpectedTypeAwareNode;
import org.hibernate.hql.ast.tree.LiteralNode;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.ParameterNode;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class InLogicOperatorNode
extends BinaryLogicOperatorNode
implements BinaryOperatorNode {
    public Node getInList() {
        return this.getRightHandOperand();
    }

    public void initialize() throws SemanticException {
        Object object;
        Serializable serializable;
        Node node = this.getLeftHandOperand();
        if (node == null) {
            throw new SemanticException("left-hand operand of in operator was null");
        }
        Node node2 = this.getInList();
        if (node2 == null) {
            throw new SemanticException("right-hand operand of in operator was null");
        }
        if (SqlNode.class.isAssignableFrom(node.getClass())) {
            serializable = ((SqlNode)node).getDataType();
            for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (!ExpectedTypeAwareNode.class.isAssignableFrom(object.getClass())) continue;
                ((ExpectedTypeAwareNode)object).setExpectedType((Type)serializable);
            }
        }
        if ((serializable = this.getSessionFactoryHelper().getFactory()).getDialect().supportsRowValueConstructorSyntaxInInList()) {
            return;
        }
        object = this.extractDataType(node);
        if (object == null) {
            return;
        }
        int n = object.getColumnSpan((Mapping)((Object)serializable));
        Node node3 = (Node)node2.getFirstChild();
        if (!this.isNodeAcceptable(node3)) {
            return;
        }
        int n2 = 0;
        if (node3.getType() == 92) {
            n2 = node3.getNumberOfChildren();
        } else {
            Type type = this.extractDataType(node3);
            if (type == null) {
                return;
            }
            n2 = type.getColumnSpan((Mapping)((Object)serializable));
        }
        if (n > 1 && n2 > 1) {
            this.mutateRowValueConstructorSyntaxInInListSyntax(n, n2);
        }
    }

    private boolean isNodeAcceptable(Node node) {
        return node instanceof LiteralNode || node instanceof ParameterNode || node.getType() == 92;
    }

    private void mutateRowValueConstructorSyntaxInInListSyntax(int n, int n2) {
        Node node;
        ParameterSpecification parameterSpecification;
        String[] stringArray = InLogicOperatorNode.extractMutationTexts(this.getLeftHandOperand(), n);
        ParameterSpecification parameterSpecification2 = parameterSpecification = this.getLeftHandOperand() == null || !ParameterNode.class.isInstance(this.getLeftHandOperand()) ? null : ((ParameterNode)this.getLeftHandOperand()).getHqlParameterSpecification();
        if (node != null && node.getNextSibling() == null) {
            String[] stringArray2 = InLogicOperatorNode.extractMutationTexts(node, n2);
            this.setType(6);
            this.setText("AND");
            ParameterSpecification parameterSpecification3 = node == null || !ParameterNode.class.isInstance(node) ? null : ((ParameterNode)node).getHqlParameterSpecification();
            this.translate(n, 102, "=", stringArray, stringArray2, parameterSpecification, parameterSpecification3, this);
        } else {
            Object object;
            Object object2;
            ArrayList<AST> arrayList = new ArrayList<AST>();
            for (node = (Node)this.getInList().getFirstChild(); node != null; node = (Node)node.getNextSibling()) {
                object2 = InLogicOperatorNode.extractMutationTexts(node, n2);
                AST aST = this.getASTFactory().create(6, "AND");
                object = node == null || !ParameterNode.class.isInstance(node) ? null : ((ParameterNode)node).getHqlParameterSpecification();
                this.translate(n, 102, "=", stringArray, (String[])object2, parameterSpecification, (ParameterSpecification)object, aST);
                arrayList.add(aST);
            }
            this.setType(40);
            this.setText("OR");
            object2 = this;
            for (int i = arrayList.size() - 1; i > 1; --i) {
                object = this.getASTFactory().create(40, "OR");
                object2.setFirstChild((AST)object);
                object2 = object;
                AST aST = (AST)arrayList.get(i);
                object.setNextSibling(aST);
            }
            AST aST = (AST)arrayList.get(0);
            object = (AST)arrayList.get(1);
            aST.setNextSibling((AST)object);
            object2.setFirstChild(aST);
        }
    }
}

