/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromElementFactory;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.util.SessionFactoryHelper;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexNode
extends FromReferenceNode {
    private static final Logger log = LoggerFactory.getLogger(IndexNode.class);

    public void setScalarColumnText(int n) throws SemanticException {
        throw new UnsupportedOperationException("An IndexNode cannot generate column text!");
    }

    public void prepareForDot(String string) throws SemanticException {
        FromElement fromElement = this.getFromElement();
        if (fromElement == null) {
            throw new IllegalStateException("No FROM element for index operator!");
        }
        QueryableCollection queryableCollection = fromElement.getQueryableCollection();
        if (queryableCollection != null && !queryableCollection.isOneToMany()) {
            FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
            String string2 = fromReferenceNode.getPath() + "[]." + string;
            if (log.isDebugEnabled()) {
                log.debug("Creating join for many-to-many elements for " + string2);
            }
            FromElementFactory fromElementFactory = new FromElementFactory(fromElement.getFromClause(), fromElement, string2);
            FromElement fromElement2 = fromElementFactory.createElementJoin(queryableCollection);
            this.setFromElement(fromElement2);
        }
    }

    public void resolveIndex(AST aST) throws SemanticException {
        throw new UnsupportedOperationException();
    }

    public void resolve(boolean bl, boolean bl2, String string, AST aST) throws SemanticException {
        Object object;
        Object object2;
        String string2;
        if (this.isResolved()) {
            return;
        }
        FromReferenceNode fromReferenceNode = (FromReferenceNode)this.getFirstChild();
        SessionFactoryHelper sessionFactoryHelper = this.getSessionFactoryHelper();
        fromReferenceNode.resolveIndex(this);
        Type type = fromReferenceNode.getDataType();
        if (!type.isCollectionType()) {
            throw new SemanticException("The [] operator cannot be applied to type " + type.toString());
        }
        String string3 = ((CollectionType)type).getRole();
        QueryableCollection queryableCollection = sessionFactoryHelper.requireQueryableCollection(string3);
        if (!queryableCollection.hasIndex()) {
            throw new QueryException("unindexed fromElement before []: " + fromReferenceNode.getPath());
        }
        FromElement fromElement = fromReferenceNode.getFromElement();
        String string4 = fromElement.getTableAlias();
        FromClause fromClause = fromElement.getFromClause();
        FromElement fromElement2 = fromClause.findCollectionJoin(string2 = fromReferenceNode.getPath());
        if (fromElement2 == null) {
            object2 = new FromElementFactory(fromClause, fromElement, string2);
            fromElement2 = ((FromElementFactory)object2).createCollectionElementsJoin(queryableCollection, string4);
            if (log.isDebugEnabled()) {
                log.debug("No FROM element found for the elements of collection join path " + string2 + ", created " + fromElement2);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("FROM element found for collection join path " + string2);
        }
        this.setFromElement(fromElement);
        object2 = fromReferenceNode.getNextSibling();
        if (object2 == null) {
            throw new QueryException("No index value!");
        }
        String string5 = string4;
        if (fromElement2.getCollectionTableAlias() != null) {
            string5 = fromElement2.getCollectionTableAlias();
        }
        JoinSequence joinSequence = fromElement.getJoinSequence();
        String[] stringArray = queryableCollection.getIndexColumnNames();
        if (stringArray.length != 1) {
            throw new QueryException("composite-index appears in []: " + fromReferenceNode.getPath());
        }
        SqlGenerator sqlGenerator = new SqlGenerator(this.getSessionFactoryHelper().getFactory());
        try {
            sqlGenerator.simpleExpr((AST)object2);
        }
        catch (RecognitionException recognitionException) {
            throw new QueryException(recognitionException.getMessage(), recognitionException);
        }
        String string6 = sqlGenerator.getSQL();
        joinSequence.addCondition(string5 + '.' + stringArray[0] + " = " + string6);
        List list = sqlGenerator.getCollectedParameters();
        if (list != null) {
            switch (list.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    object = (ParameterSpecification)list.get(0);
                    object.setExpectedType(queryableCollection.getIndexType());
                    fromElement.setIndexCollectionSelectorParamSpec((ParameterSpecification)object);
                    break;
                }
                default: {
                    fromElement.setIndexCollectionSelectorParamSpec(new AggregatedIndexCollectionSelectorParameterSpecifications(list));
                }
            }
        }
        object = queryableCollection.getElementColumnNames(string4);
        this.setText(object[0]);
        this.setResolved();
    }

    private static class AggregatedIndexCollectionSelectorParameterSpecifications
    implements ParameterSpecification {
        private final List paramSpecs;

        public AggregatedIndexCollectionSelectorParameterSpecifications(List list) {
            this.paramSpecs = list;
        }

        public int bind(PreparedStatement preparedStatement, QueryParameters queryParameters, SessionImplementor sessionImplementor, int n) throws SQLException {
            int n2 = 0;
            for (ParameterSpecification parameterSpecification : this.paramSpecs) {
                n2 += parameterSpecification.bind(preparedStatement, queryParameters, sessionImplementor, n + n2);
            }
            return n2;
        }

        public Type getExpectedType() {
            return null;
        }

        public void setExpectedType(Type type) {
        }

        public String renderDisplayInfo() {
            return "index-selector [" + this.collectDisplayInfo() + "]";
        }

        private String collectDisplayInfo() {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this.paramSpecs.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((ParameterSpecification)iterator.next()).renderDisplayInfo());
            }
            return stringBuffer.toString();
        }
    }
}

