/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.ast.tree.HqlSqlWalkerNode;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.util.StringHelper;

public class ResultVariableRefNode
extends HqlSqlWalkerNode {
    private SelectExpression selectExpression;

    public void setSelectExpression(SelectExpression selectExpression) throws SemanticException {
        if (selectExpression == null || selectExpression.getAlias() == null) {
            throw new SemanticException("A ResultVariableRefNode must refer to a non-null alias.");
        }
        this.selectExpression = selectExpression;
    }

    public String getRenderText(SessionFactoryImplementor sessionFactoryImplementor) {
        int n = this.selectExpression.getScalarColumnIndex();
        if (n < 0) {
            throw new IllegalStateException("selectExpression.getScalarColumnIndex() must be >= 0; actual = " + n);
        }
        return sessionFactoryImplementor.getDialect().replaceResultVariableInOrderByClauseWithPosition() ? this.getColumnPositionsString(n) : this.getColumnNamesString(n);
    }

    private String getColumnPositionsString(int n) {
        int n2 = this.getWalker().getSelectClause().getColumnNamesStartPosition(n);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = this.getWalker().getSelectClause().getColumnNames()[n].length;
        for (int i = n2; i < n2 + n3; ++i) {
            if (i > n2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(i);
        }
        return stringBuffer.toString();
    }

    private String getColumnNamesString(int n) {
        return StringHelper.join(", ", this.getWalker().getSelectClause().getColumnNames()[n]);
    }
}

