/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.collections.AST;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import org.hibernate.hql.ast.tree.DisplayableNode;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.util.StringHelper;

public class ASTPrinter {
    private final Map tokenTypeNameCache;
    private final boolean showClassNames;

    public ASTPrinter(Class clazz) {
        this(ASTUtil.generateTokenNameCache(clazz), true);
    }

    public ASTPrinter(boolean bl) {
        this((Map)null, bl);
    }

    public ASTPrinter(Class clazz, boolean bl) {
        this(ASTUtil.generateTokenNameCache(clazz), bl);
    }

    private ASTPrinter(Map map, boolean bl) {
        this.tokenTypeNameCache = map;
        this.showClassNames = bl;
    }

    public boolean isShowClassNames() {
        return this.showClassNames;
    }

    public String showAsString(AST aST, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.println(string);
        this.showAst(aST, printStream);
        printStream.flush();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public void showAst(AST aST, PrintStream printStream) {
        this.showAst(aST, new PrintWriter(printStream));
    }

    public void showAst(AST aST, PrintWriter printWriter) {
        ArrayList arrayList = new ArrayList();
        this.showAst(arrayList, printWriter, aST);
        printWriter.flush();
    }

    public String getTokenTypeName(int n) {
        Integer n2 = new Integer(n);
        String string = null;
        if (this.tokenTypeNameCache != null) {
            string = (String)this.tokenTypeNameCache.get(n2);
        }
        if (string == null) {
            string = n2.toString();
        }
        return string;
    }

    private void showAst(ArrayList arrayList, PrintWriter printWriter, AST aST) {
        AST aST2;
        if (aST == null) {
            printWriter.println("AST is null!");
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            aST2 = (AST)arrayList.get(i);
            if (aST2.getNextSibling() == null) {
                printWriter.print("   ");
                continue;
            }
            printWriter.print(" | ");
        }
        if (aST.getNextSibling() == null) {
            printWriter.print(" \\-");
        } else {
            printWriter.print(" +-");
        }
        this.showNode(printWriter, aST);
        ArrayList<AST> arrayList2 = new ArrayList<AST>(arrayList);
        arrayList2.add(aST);
        for (aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            this.showAst(arrayList2, printWriter, aST2);
        }
        arrayList2.clear();
    }

    private void showNode(PrintWriter printWriter, AST aST) {
        String string = this.nodeToString(aST, this.isShowClassNames());
        printWriter.println(string);
    }

    public String nodeToString(AST aST, boolean bl) {
        if (aST == null) {
            return "{node:null}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(this.getTokenTypeName(aST.getType())).append("] ");
        if (bl) {
            stringBuffer.append(StringHelper.unqualify(aST.getClass().getName())).append(": ");
        }
        stringBuffer.append("'");
        String string = aST.getText();
        if (string == null) {
            string = "{text:null}";
        }
        ASTPrinter.appendEscapedMultibyteChars(string, stringBuffer);
        stringBuffer.append("'");
        if (aST instanceof DisplayableNode) {
            DisplayableNode displayableNode = (DisplayableNode)((Object)aST);
            stringBuffer.append(" ").append(displayableNode.getDisplayText());
        }
        return stringBuffer.toString();
    }

    public static void appendEscapedMultibyteChars(String string, StringBuffer stringBuffer) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c > '\u0100') {
                stringBuffer.append("\\u");
                stringBuffer.append(Integer.toHexString(c));
                continue;
            }
            stringBuffer.append(c);
        }
    }

    public static String escapeMultibyteChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        ASTPrinter.appendEscapedMultibyteChars(string, stringBuffer);
        return stringBuffer.toString();
    }
}

