/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.ASTFactory;
import antlr.collections.AST;
import org.hibernate.hql.NameGenerator;
import org.hibernate.hql.ast.tree.HqlSqlWalkerNode;
import org.hibernate.hql.ast.util.ASTUtil;

public final class ColumnHelper {
    private ColumnHelper() {
    }

    public static void generateSingleScalarColumn(HqlSqlWalkerNode hqlSqlWalkerNode, int n) {
        ASTFactory aSTFactory = hqlSqlWalkerNode.getASTFactory();
        ASTUtil.createSibling(aSTFactory, 143, " as " + NameGenerator.scalarName(n, 0), hqlSqlWalkerNode);
    }

    public static void generateScalarColumns(HqlSqlWalkerNode hqlSqlWalkerNode, String[] stringArray, int n) {
        if (stringArray.length == 1) {
            ColumnHelper.generateSingleScalarColumn(hqlSqlWalkerNode, n);
        } else {
            ASTFactory aSTFactory = hqlSqlWalkerNode.getASTFactory();
            AST aST = hqlSqlWalkerNode;
            aST.setText(stringArray[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    aST = ASTUtil.createSibling(aSTFactory, 142, stringArray[i], aST);
                }
                aST = ASTUtil.createSibling(aSTFactory, 143, " as " + NameGenerator.scalarName(n, i), aST);
            }
        }
    }
}

