/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.SemanticException;
import antlr.collections.AST;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.InvalidPathException;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.IdentNode;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.LiteralType;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteralProcessor
implements HqlSqlTokenTypes {
    public static final int EXACT = 0;
    public static final int APPROXIMATE = 1;
    public static int DECIMAL_LITERAL_FORMAT = 0;
    private static final Logger log = LoggerFactory.getLogger(LiteralProcessor.class);
    private HqlSqlWalker walker;
    private static final DecimalFormatter[] formatters = new DecimalFormatter[]{new ExactDecimalFormatter(), new ApproximateDecimalFormatter()};

    public LiteralProcessor(HqlSqlWalker hqlSqlWalker) {
        this.walker = hqlSqlWalker;
    }

    public boolean isAlias(String string) {
        FromClause fromClause = this.walker.getCurrentFromClause();
        while (fromClause.isSubQuery()) {
            if (fromClause.containsClassAlias(string)) {
                return true;
            }
            fromClause = fromClause.getParentFromClause();
        }
        return fromClause.containsClassAlias(string);
    }

    public void processConstant(AST aST, boolean bl) throws SemanticException {
        boolean bl2;
        boolean bl3 = bl2 = aST.getType() == 126 || aST.getType() == 93;
        if (bl && bl2 && this.isAlias(aST.getText())) {
            IdentNode identNode = (IdentNode)aST;
            identNode.resolve(false, true);
        } else {
            Queryable queryable = this.walker.getSessionFactoryHelper().findQueryableUsingImports(aST.getText());
            if (bl2 && queryable != null) {
                aST.setText(queryable.getDiscriminatorSQLValue());
            } else {
                this.processLiteral(aST);
            }
        }
    }

    public void lookupConstant(DotNode dotNode) throws SemanticException {
        String string = ASTUtil.getPathText(dotNode);
        Queryable queryable = this.walker.getSessionFactoryHelper().findQueryableUsingImports(string);
        if (queryable != null) {
            String string2 = queryable.getDiscriminatorSQLValue();
            dotNode.setDataType(queryable.getDiscriminatorType());
            if ("null".equals(string2) || "not null".equals(string2)) {
                throw new InvalidPathException("subclass test not allowed for null or not null discriminator: '" + string + "'");
            }
            this.setSQLValue(dotNode, string, string2);
        } else {
            Object object = ReflectHelper.getConstantValue(string);
            if (object == null) {
                throw new InvalidPathException("Invalid path: '" + string + "'");
            }
            this.setConstantValue(dotNode, string, object);
        }
    }

    private void setSQLValue(DotNode dotNode, String string, String string2) {
        if (log.isDebugEnabled()) {
            log.debug("setSQLValue() " + string + " -> " + string2);
        }
        dotNode.setFirstChild(null);
        dotNode.setType(142);
        dotNode.setText(string2);
        dotNode.setResolvedConstant(string);
    }

    private void setConstantValue(DotNode dotNode, String string, Object object) {
        Type type;
        if (log.isDebugEnabled()) {
            log.debug("setConstantValue() " + string + " -> " + object + " " + object.getClass().getName());
        }
        dotNode.setFirstChild(null);
        if (object instanceof String) {
            dotNode.setType(125);
        } else if (object instanceof Character) {
            dotNode.setType(125);
        } else if (object instanceof Byte) {
            dotNode.setType(124);
        } else if (object instanceof Short) {
            dotNode.setType(124);
        } else if (object instanceof Integer) {
            dotNode.setType(124);
        } else if (object instanceof Long) {
            dotNode.setType(97);
        } else if (object instanceof Double) {
            dotNode.setType(95);
        } else if (object instanceof Float) {
            dotNode.setType(96);
        } else {
            dotNode.setType(94);
        }
        try {
            type = this.walker.getSessionFactoryHelper().getFactory().getTypeResolver().heuristicType(object.getClass().getName());
        }
        catch (MappingException mappingException) {
            throw new QueryException(mappingException);
        }
        if (type == null) {
            throw new QueryException("Could not determine type of: " + dotNode.getText());
        }
        try {
            LiteralType literalType = (LiteralType)((Object)type);
            Dialect dialect = this.walker.getSessionFactoryHelper().getFactory().getDialect();
            dotNode.setText(literalType.objectToSQLString(object, dialect));
        }
        catch (Exception exception) {
            throw new QueryException("Could not format constant value to SQL literal: " + dotNode.getText(), exception);
        }
        dotNode.setDataType(type);
        dotNode.setResolvedConstant(string);
    }

    public void processBoolean(AST aST) {
        String string = (String)this.walker.getTokenReplacements().get(aST.getText());
        if (string != null) {
            aST.setText(string);
        } else {
            boolean bl = "true".equals(aST.getText().toLowerCase());
            Dialect dialect = this.walker.getSessionFactoryHelper().getFactory().getDialect();
            aST.setText(dialect.toBooleanValueString(bl));
        }
    }

    private void processLiteral(AST aST) {
        String string = (String)this.walker.getTokenReplacements().get(aST.getText());
        if (string != null) {
            if (log.isDebugEnabled()) {
                log.debug("processConstant() : Replacing '" + aST.getText() + "' with '" + string + "'");
            }
            aST.setText(string);
        }
    }

    public void processNumeric(AST aST) {
        if (aST.getType() == 124 || aST.getType() == 97 || aST.getType() == 98) {
            aST.setText(this.determineIntegerRepresentation(aST.getText(), aST.getType()));
        } else if (aST.getType() == 96 || aST.getType() == 95 || aST.getType() == 99) {
            aST.setText(this.determineDecimalRepresentation(aST.getText(), aST.getType()));
        } else {
            log.warn("Unexpected literal token type [" + aST.getType() + "] passed for numeric processing");
        }
    }

    private String determineIntegerRepresentation(String string, int n) {
        try {
            String string2;
            if (n == 98) {
                String string3 = string;
                if (string3.endsWith("bi") || string3.endsWith("BI")) {
                    string3 = string3.substring(0, string3.length() - 2);
                }
                return new BigInteger(string3).toString();
            }
            if (n == 124) {
                try {
                    return Integer.valueOf(string).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    log.trace("could not format incoming text [" + string + "] as a NUM_INT; assuming numeric overflow and attempting as NUM_LONG");
                }
            }
            if ((string2 = string).endsWith("l") || string2.endsWith("L")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return Long.valueOf(string2).toString();
        }
        catch (Throwable throwable) {
            throw new HibernateException("Could not parse literal [" + string + "] as integer", throwable);
        }
    }

    public String determineDecimalRepresentation(String string, int n) {
        String string2 = string;
        if (n == 96) {
            if (string2.endsWith("f") || string2.endsWith("F")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else if (n == 95) {
            if (string2.endsWith("d") || string2.endsWith("D")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else if (n == 99 && (string2.endsWith("bd") || string2.endsWith("BD"))) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string2);
        }
        catch (Throwable throwable) {
            throw new HibernateException("Could not parse literal [" + string + "] as big-decimal", throwable);
        }
        return formatters[DECIMAL_LITERAL_FORMAT].format(bigDecimal);
    }

    private static class ApproximateDecimalFormatter
    implements DecimalFormatter {
        private static final String FORMAT_STRING = "#0.0E0";

        private ApproximateDecimalFormatter() {
        }

        public String format(BigDecimal bigDecimal) {
            try {
                DecimalFormat decimalFormat = new DecimalFormat(FORMAT_STRING);
                decimalFormat.setMinimumIntegerDigits(1);
                decimalFormat.setMaximumFractionDigits(Integer.MAX_VALUE);
                return decimalFormat.format(bigDecimal);
            }
            catch (Throwable throwable) {
                throw new HibernateException("Unable to format decimal literal in approximate format [" + bigDecimal.toString() + "]", throwable);
            }
        }
    }

    private static class ExactDecimalFormatter
    implements DecimalFormatter {
        private ExactDecimalFormatter() {
        }

        public String format(BigDecimal bigDecimal) {
            return bigDecimal.toString();
        }
    }

    private static interface DecimalFormatter {
        public String format(BigDecimal var1);
    }
}

