/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.ASTFactory;
import antlr.collections.AST;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PathHelper {
    private static final Logger log = LoggerFactory.getLogger(PathHelper.class);

    private PathHelper() {
    }

    public static AST parsePath(String string, ASTFactory aSTFactory) {
        String[] stringArray = StringHelper.split(".", string);
        AST aST = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            AST aST2 = ASTUtil.create(aSTFactory, 126, string2);
            aST = i == 0 ? aST2 : ASTUtil.createBinarySubtree(aSTFactory, 15, ".", aST, aST2);
        }
        if (log.isDebugEnabled()) {
            log.debug("parsePath() : " + string + " -> " + ASTUtil.getDebugString(aST));
        }
        return aST;
    }

    public static String getAlias(String string) {
        return StringHelper.root(string);
    }
}

