/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.collections.AST;
import java.util.Map;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.Node;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.RestrictableStatement;
import org.hibernate.hql.ast.tree.SqlFragment;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.hql.ast.util.JoinProcessor;
import org.hibernate.param.CollectionFilterKeyParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntheticAndFactory
implements HqlSqlTokenTypes {
    private static final Logger log = LoggerFactory.getLogger(SyntheticAndFactory.class);
    private HqlSqlWalker hqlSqlWalker;
    private AST thetaJoins;
    private AST filters;

    public SyntheticAndFactory(HqlSqlWalker hqlSqlWalker) {
        this.hqlSqlWalker = hqlSqlWalker;
    }

    private Node create(int n, String string) {
        return (Node)ASTUtil.create(this.hqlSqlWalker.getASTFactory(), n, string);
    }

    public void addWhereFragment(JoinFragment joinFragment, String string, QueryNode queryNode, FromElement fromElement, HqlSqlWalker hqlSqlWalker) {
        Object object;
        if (string == null) {
            return;
        }
        if (!fromElement.useWhereFragment() && !joinFragment.hasThetaJoins()) {
            return;
        }
        if (StringHelper.isEmpty(string = string.trim())) {
            return;
        }
        if (string.startsWith("and")) {
            string = string.substring(4);
        }
        log.debug("Using unprocessed WHERE-fragment [{}]", (Object)string);
        SqlFragment sqlFragment = (SqlFragment)this.create(142, string);
        sqlFragment.setJoinFragment(joinFragment);
        sqlFragment.setFromElement(fromElement);
        if (fromElement.getIndexCollectionSelectorParamSpec() != null) {
            sqlFragment.addEmbeddedParameter(fromElement.getIndexCollectionSelectorParamSpec());
            fromElement.setIndexCollectionSelectorParamSpec(null);
        }
        if (hqlSqlWalker.isFilter() && string.indexOf(63) >= 0) {
            object = hqlSqlWalker.getSessionFactoryHelper().requireQueryableCollection(hqlSqlWalker.getCollectionFilterRole()).getKeyType();
            CollectionFilterKeyParameterSpecification collectionFilterKeyParameterSpecification = new CollectionFilterKeyParameterSpecification(hqlSqlWalker.getCollectionFilterRole(), (Type)object, 0);
            sqlFragment.addEmbeddedParameter(collectionFilterKeyParameterSpecification);
        }
        JoinProcessor.processDynamicFilterParameters(string, sqlFragment, hqlSqlWalker);
        log.debug("Using processed WHERE-fragment [{}]", (Object)sqlFragment.getText());
        if (sqlFragment.getFromElement().isFilter() || sqlFragment.hasFilterCondition()) {
            if (this.filters == null) {
                object = queryNode.getWhereClause();
                this.filters = this.create(146, "{filter conditions}");
                ASTUtil.insertChild((AST)object, this.filters);
            }
            this.filters.addChild(sqlFragment);
        } else {
            if (this.thetaJoins == null) {
                object = queryNode.getWhereClause();
                this.thetaJoins = this.create(145, "{theta joins}");
                if (this.filters == null) {
                    ASTUtil.insertChild((AST)object, this.thetaJoins);
                } else {
                    ASTUtil.insertSibling(this.thetaJoins, this.filters);
                }
            }
            this.thetaJoins.addChild(sqlFragment);
        }
    }

    public void addDiscriminatorWhereFragment(RestrictableStatement restrictableStatement, Queryable queryable, Map map, String string) {
        String string2 = queryable.filterFragment(string, map).trim();
        if ("".equals(string2)) {
            return;
        }
        if (string2.startsWith("and")) {
            string2 = string2.substring(4);
        }
        string2 = StringHelper.replace(string2, queryable.generateFilterConditionAlias(string) + ".", "");
        SqlFragment sqlFragment = (SqlFragment)this.create(142, string2);
        JoinProcessor.processDynamicFilterParameters(string2, sqlFragment, this.hqlSqlWalker);
        if (restrictableStatement.getWhereClause().getNumberOfChildren() == 0) {
            restrictableStatement.getWhereClause().setFirstChild(sqlFragment);
        } else {
            Node node = this.create(6, "{and}");
            AST aST = restrictableStatement.getWhereClause().getFirstChild();
            node.setFirstChild(sqlFragment);
            node.addChild(aST);
            restrictableStatement.getWhereClause().setFirstChild(node);
        }
    }
}

