/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.classic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.hql.classic.FromParser;
import org.hibernate.hql.classic.GroupByParser;
import org.hibernate.hql.classic.HavingParser;
import org.hibernate.hql.classic.OrderByParser;
import org.hibernate.hql.classic.Parser;
import org.hibernate.hql.classic.QueryTranslatorImpl;
import org.hibernate.hql.classic.SelectParser;
import org.hibernate.hql.classic.WhereParser;

public class ClauseParser
implements Parser {
    private Parser child;
    private List selectTokens;
    private boolean cacheSelectTokens = false;
    private boolean byExpected = false;
    private int parenCount = 0;

    public void token(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        boolean bl;
        String string2 = string.toLowerCase();
        if ("(".equals(string)) {
            ++this.parenCount;
        } else if (")".equals(string)) {
            --this.parenCount;
        }
        if (this.byExpected && !string2.equals("by")) {
            throw new QueryException("BY expected after GROUP or ORDER: " + string);
        }
        boolean bl2 = bl = this.parenCount == 0;
        if (bl) {
            if (string2.equals("select")) {
                this.selectTokens = new ArrayList();
                this.cacheSelectTokens = true;
            } else if (string2.equals("from")) {
                this.child = new FromParser();
                this.child.start(queryTranslatorImpl);
                this.cacheSelectTokens = false;
            } else if (string2.equals("where")) {
                this.endChild(queryTranslatorImpl);
                this.child = new WhereParser();
                this.child.start(queryTranslatorImpl);
            } else if (string2.equals("order")) {
                this.endChild(queryTranslatorImpl);
                this.child = new OrderByParser();
                this.byExpected = true;
            } else if (string2.equals("having")) {
                this.endChild(queryTranslatorImpl);
                this.child = new HavingParser();
                this.child.start(queryTranslatorImpl);
            } else if (string2.equals("group")) {
                this.endChild(queryTranslatorImpl);
                this.child = new GroupByParser();
                this.byExpected = true;
            } else if (string2.equals("by")) {
                if (!this.byExpected) {
                    throw new QueryException("GROUP or ORDER expected before BY");
                }
                this.child.start(queryTranslatorImpl);
                this.byExpected = false;
            } else {
                bl = false;
            }
        }
        if (!bl) {
            if (this.cacheSelectTokens) {
                this.selectTokens.add(string);
            } else {
                if (this.child == null) {
                    throw new QueryException("query must begin with SELECT or FROM: " + string);
                }
                this.child.token(string, queryTranslatorImpl);
            }
        }
    }

    private void endChild(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        if (this.child == null) {
            this.cacheSelectTokens = false;
        } else {
            this.child.end(queryTranslatorImpl);
        }
    }

    public void start(QueryTranslatorImpl queryTranslatorImpl) {
    }

    public void end(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        this.endChild(queryTranslatorImpl);
        if (this.selectTokens != null) {
            this.child = new SelectParser();
            this.child.start(queryTranslatorImpl);
            Iterator iterator = this.selectTokens.iterator();
            while (iterator.hasNext()) {
                this.token((String)iterator.next(), queryTranslatorImpl);
            }
            this.child.end(queryTranslatorImpl);
        }
        this.byExpected = false;
        this.parenCount = 0;
        this.cacheSelectTokens = false;
    }
}

