/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.classic;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.QueryException;
import org.hibernate.hql.classic.FromPathExpressionParser;
import org.hibernate.hql.classic.Parser;
import org.hibernate.hql.classic.ParserHelper;
import org.hibernate.hql.classic.PathExpressionParser;
import org.hibernate.hql.classic.QueryTranslatorImpl;
import org.hibernate.persister.entity.Queryable;

public class FromParser
implements Parser {
    private final PathExpressionParser peParser = new FromPathExpressionParser();
    private String entityName;
    private String alias;
    private boolean afterIn;
    private boolean afterAs;
    private boolean afterClass;
    private boolean expectingJoin;
    private boolean expectingIn;
    private boolean expectingAs;
    private boolean afterJoinType;
    private int joinType;
    private boolean afterFetch;
    private static final int NONE = -666;
    private static final Map JOIN_TYPES = new HashMap();

    public void token(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        String string2 = string.toLowerCase();
        if (string2.equals(",")) {
            if (!(this.expectingJoin | this.expectingAs)) {
                throw new QueryException("unexpected token: ,");
            }
            this.expectingJoin = false;
            this.expectingAs = false;
        } else if (string2.equals("join")) {
            if (!this.afterJoinType) {
                if (!(this.expectingJoin | this.expectingAs)) {
                    throw new QueryException("unexpected token: join");
                }
                this.joinType = 0;
                this.expectingJoin = false;
                this.expectingAs = false;
            } else {
                this.afterJoinType = false;
            }
        } else if (string2.equals("fetch")) {
            if (queryTranslatorImpl.isShallowQuery()) {
                throw new QueryException("fetch may not be used with scroll() or iterate()");
            }
            if (this.joinType == -666) {
                throw new QueryException("unexpected token: fetch");
            }
            if (this.joinType == 4 || this.joinType == 2) {
                throw new QueryException("fetch may only be used with inner join or left outer join");
            }
            this.afterFetch = true;
        } else if (string2.equals("outer")) {
            if (!this.afterJoinType || this.joinType != 1 && this.joinType != 2) {
                throw new QueryException("unexpected token: outer");
            }
        } else if (JOIN_TYPES.containsKey(string2)) {
            if (!(this.expectingJoin | this.expectingAs)) {
                throw new QueryException("unexpected token: " + string);
            }
            this.joinType = (Integer)JOIN_TYPES.get(string2);
            this.afterJoinType = true;
            this.expectingJoin = false;
            this.expectingAs = false;
        } else if (string2.equals("class")) {
            if (!this.afterIn) {
                throw new QueryException("unexpected token: class");
            }
            if (this.joinType != -666) {
                throw new QueryException("outer or full join must be followed by path expression");
            }
            this.afterClass = true;
        } else if (string2.equals("in")) {
            if (!this.expectingIn) {
                throw new QueryException("unexpected token: in");
            }
            this.afterIn = true;
            this.expectingIn = false;
        } else if (string2.equals("as")) {
            if (!this.expectingAs) {
                throw new QueryException("unexpected token: as");
            }
            this.afterAs = true;
            this.expectingAs = false;
        } else {
            if (this.afterJoinType) {
                throw new QueryException("join expected: " + string);
            }
            if (this.expectingJoin) {
                throw new QueryException("unexpected token: " + string);
            }
            if (this.expectingIn) {
                throw new QueryException("in expected: " + string);
            }
            if (this.afterAs || this.expectingAs) {
                if (this.entityName == null) {
                    throw new QueryException("unexpected: as " + string);
                }
                queryTranslatorImpl.setAliasName(string, this.entityName);
                this.afterAs = false;
                this.expectingJoin = true;
                this.expectingAs = false;
                this.entityName = null;
            } else if (this.afterIn) {
                if (this.alias == null) {
                    throw new QueryException("alias not specified for: " + string);
                }
                if (this.joinType != -666) {
                    throw new QueryException("outer or full join must be followed by path expression");
                }
                if (this.afterClass) {
                    Queryable queryable = queryTranslatorImpl.getEntityPersisterUsingImports(string);
                    if (queryable == null) {
                        throw new QueryException("persister not found: " + string);
                    }
                    queryTranslatorImpl.addFromClass(this.alias, queryable);
                } else {
                    this.peParser.setJoinType(0);
                    this.peParser.setUseThetaStyleJoin(true);
                    ParserHelper.parse(this.peParser, queryTranslatorImpl.unalias(string), ".", queryTranslatorImpl);
                    if (!this.peParser.isCollectionValued()) {
                        throw new QueryException("path expression did not resolve to collection: " + string);
                    }
                    String string3 = this.peParser.addFromCollection(queryTranslatorImpl);
                    queryTranslatorImpl.setAliasName(this.alias, string3);
                }
                this.alias = null;
                this.afterIn = false;
                this.afterClass = false;
                this.expectingJoin = true;
            } else {
                Queryable queryable = queryTranslatorImpl.getEntityPersisterUsingImports(string);
                if (queryable != null) {
                    if (this.joinType != -666) {
                        throw new QueryException("outer or full join must be followed by path expression");
                    }
                    this.entityName = queryTranslatorImpl.createNameFor(queryable.getEntityName());
                    queryTranslatorImpl.addFromClass(this.entityName, queryable);
                    this.expectingAs = true;
                } else if (string.indexOf(46) < 0) {
                    this.alias = string;
                    this.expectingIn = true;
                } else {
                    if (this.joinType != -666) {
                        this.peParser.setJoinType(this.joinType);
                    } else {
                        this.peParser.setJoinType(0);
                    }
                    this.peParser.setUseThetaStyleJoin(queryTranslatorImpl.isSubquery());
                    ParserHelper.parse(this.peParser, queryTranslatorImpl.unalias(string), ".", queryTranslatorImpl);
                    this.entityName = this.peParser.addFromAssociation(queryTranslatorImpl);
                    this.joinType = -666;
                    this.peParser.setJoinType(0);
                    if (this.afterFetch) {
                        this.peParser.fetch(queryTranslatorImpl, this.entityName);
                        this.afterFetch = false;
                    }
                    this.expectingAs = true;
                }
            }
        }
    }

    public void start(QueryTranslatorImpl queryTranslatorImpl) {
        this.entityName = null;
        this.alias = null;
        this.afterIn = false;
        this.afterAs = false;
        this.afterClass = false;
        this.expectingJoin = false;
        this.expectingIn = false;
        this.expectingAs = false;
        this.joinType = -666;
    }

    public void end(QueryTranslatorImpl queryTranslatorImpl) {
    }

    static {
        JOIN_TYPES.put("left", new Integer(1));
        JOIN_TYPES.put("right", new Integer(2));
        JOIN_TYPES.put("full", new Integer(4));
        JOIN_TYPES.put("inner", new Integer(0));
    }
}

