/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.classic;

import java.util.LinkedList;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.CollectionSubqueryFactory;
import org.hibernate.hql.classic.Parser;
import org.hibernate.hql.classic.QueryTranslatorImpl;
import org.hibernate.persister.collection.CollectionPropertyMapping;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class PathExpressionParser
implements Parser {
    private int dotcount;
    private String currentName;
    private String currentProperty;
    private String oneToOneOwnerName;
    private AssociationType ownerAssociationType;
    private String[] columns;
    private String collectionName;
    private String collectionOwnerName;
    private String collectionRole;
    private final StringBuffer componentPath = new StringBuffer();
    private Type type;
    private final StringBuffer path = new StringBuffer();
    private boolean ignoreInitialJoin;
    private boolean continuation;
    private int joinType = 0;
    private boolean useThetaStyleJoin = true;
    private PropertyMapping currentPropertyMapping;
    private JoinSequence joinSequence;
    private boolean expectingCollectionIndex;
    private LinkedList collectionElements = new LinkedList();

    void setJoinType(int n) {
        this.joinType = n;
    }

    void setUseThetaStyleJoin(boolean bl) {
        this.useThetaStyleJoin = bl;
    }

    private void addJoin(String string, AssociationType associationType) throws QueryException {
        try {
            this.joinSequence.addJoin(associationType, string, this.joinType, this.currentColumns());
        }
        catch (MappingException mappingException) {
            throw new QueryException(mappingException);
        }
    }

    private void addJoin(String string, AssociationType associationType, String[] stringArray) throws QueryException {
        try {
            this.joinSequence.addJoin(associationType, string, this.joinType, stringArray);
        }
        catch (MappingException mappingException) {
            throw new QueryException(mappingException);
        }
    }

    String continueFromManyToMany(String string, String[] stringArray, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        this.start(queryTranslatorImpl);
        this.continuation = true;
        this.currentName = queryTranslatorImpl.createNameFor(string);
        queryTranslatorImpl.addType(this.currentName, string);
        Queryable queryable = queryTranslatorImpl.getEntityPersister(string);
        this.addJoin(this.currentName, queryTranslatorImpl.getFactory().getTypeResolver().getTypeFactory().manyToOne(string), stringArray);
        this.currentPropertyMapping = queryable;
        return this.currentName;
    }

    public void ignoreInitialJoin() {
        this.ignoreInitialJoin = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void token(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        String string2;
        if (string != null) {
            this.path.append(string);
        }
        if ((string2 = queryTranslatorImpl.getPathAlias(this.path.toString())) != null) {
            this.reset(queryTranslatorImpl);
            this.currentName = string2;
            this.currentPropertyMapping = queryTranslatorImpl.getPropertyMapping(this.currentName);
            if (this.ignoreInitialJoin) return;
            JoinSequence joinSequence = queryTranslatorImpl.getPathJoin(this.path.toString());
            try {
                this.joinSequence.addCondition(joinSequence.toJoinFragment(queryTranslatorImpl.getEnabledFilters(), true).toWhereFragmentString());
                return;
            }
            catch (MappingException mappingException) {
                throw new QueryException(mappingException);
            }
        } else if (".".equals(string)) {
            ++this.dotcount;
            return;
        } else if (this.dotcount == 0) {
            if (this.continuation) return;
            if (!queryTranslatorImpl.isName(string)) {
                throw new QueryException("undefined alias: " + string);
            }
            this.currentName = string;
            this.currentPropertyMapping = queryTranslatorImpl.getPropertyMapping(this.currentName);
            return;
        } else if (this.dotcount == 1) {
            if (this.currentName != null) {
                this.currentProperty = string;
                return;
            } else {
                if (this.collectionName == null) throw new QueryException("unexpected");
                this.continuation = false;
            }
            return;
        } else {
            Type type = this.getPropertyType();
            if (type == null) {
                throw new QueryException("unresolved property: " + this.path);
            }
            if (type.isComponentType()) {
                this.dereferenceComponent(string);
                return;
            } else if (type.isEntityType()) {
                if (this.isCollectionValued()) return;
                this.dereferenceEntity(string, (EntityType)type, queryTranslatorImpl);
                return;
            } else if (type.isCollectionType()) {
                this.dereferenceCollection(string, ((CollectionType)type).getRole(), queryTranslatorImpl);
                return;
            } else {
                if (string == null) return;
                throw new QueryException("dereferenced: " + this.path);
            }
        }
    }

    private void dereferenceEntity(String string, EntityType entityType, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        boolean bl;
        String string2;
        boolean bl2 = "id".equals(string) && entityType.isReferenceToPrimaryKey();
        try {
            string2 = entityType.getIdentifierOrUniqueKeyPropertyName(queryTranslatorImpl.getFactory());
        }
        catch (MappingException mappingException) {
            throw new QueryException(mappingException);
        }
        boolean bl3 = bl = string2 != null && string2.equals(string) && entityType.isReferenceToPrimaryKey();
        if (bl2 || bl) {
            if (this.componentPath.length() > 0) {
                this.componentPath.append('.');
            }
            this.componentPath.append(string);
        } else {
            String string3 = entityType.getAssociatedEntityName();
            String string4 = queryTranslatorImpl.createNameFor(string3);
            queryTranslatorImpl.addType(string4, string3);
            this.addJoin(string4, entityType);
            if (entityType.isOneToOne()) {
                this.oneToOneOwnerName = this.currentName;
            }
            this.ownerAssociationType = entityType;
            this.currentName = string4;
            this.currentProperty = string;
            queryTranslatorImpl.addPathAliasAndJoin(this.path.substring(0, this.path.toString().lastIndexOf(46)), string4, this.joinSequence.copy());
            this.componentPath.setLength(0);
            this.currentPropertyMapping = queryTranslatorImpl.getEntityPersister(string3);
        }
    }

    private void dereferenceComponent(String string) {
        if (string != null) {
            if (this.componentPath.length() > 0) {
                this.componentPath.append('.');
            }
            this.componentPath.append(string);
        }
    }

    private void dereferenceCollection(String string, String string2, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        this.collectionRole = string2;
        QueryableCollection queryableCollection = queryTranslatorImpl.getCollectionPersister(string2);
        String string3 = queryTranslatorImpl.createNameForCollection(string2);
        this.addJoin(string3, queryableCollection.getCollectionType());
        this.collectionName = string3;
        this.collectionOwnerName = this.currentName;
        this.currentName = string3;
        this.currentProperty = string;
        this.componentPath.setLength(0);
        this.currentPropertyMapping = new CollectionPropertyMapping(queryableCollection);
    }

    private String getPropertyPath() {
        if (this.currentProperty == null) {
            return "id";
        }
        if (this.componentPath.length() > 0) {
            return new StringBuffer().append(this.currentProperty).append('.').append(this.componentPath.toString()).toString();
        }
        return this.currentProperty;
    }

    private PropertyMapping getPropertyMapping() {
        return this.currentPropertyMapping;
    }

    private void setType() throws QueryException {
        this.type = this.currentProperty == null ? this.getPropertyMapping().getType() : this.getPropertyType();
    }

    protected Type getPropertyType() throws QueryException {
        String string = this.getPropertyPath();
        Type type = this.getPropertyMapping().toType(string);
        if (type == null) {
            throw new QueryException("could not resolve property type: " + string);
        }
        return type;
    }

    protected String[] currentColumns() throws QueryException {
        String string = this.getPropertyPath();
        String[] stringArray = this.getPropertyMapping().toColumns(this.currentName, string);
        if (stringArray == null) {
            throw new QueryException("could not resolve property columns: " + string);
        }
        return stringArray;
    }

    private void reset(QueryTranslatorImpl queryTranslatorImpl) {
        this.dotcount = 0;
        this.currentName = null;
        this.currentProperty = null;
        this.collectionName = null;
        this.collectionRole = null;
        this.componentPath.setLength(0);
        this.type = null;
        this.collectionName = null;
        this.columns = null;
        this.expectingCollectionIndex = false;
        this.continuation = false;
        this.currentPropertyMapping = null;
    }

    public void start(QueryTranslatorImpl queryTranslatorImpl) {
        if (!this.continuation) {
            this.reset(queryTranslatorImpl);
            this.path.setLength(0);
            this.joinSequence = new JoinSequence(queryTranslatorImpl.getFactory()).setUseThetaStyle(this.useThetaStyleJoin);
        }
    }

    public void end(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        this.ignoreInitialJoin = false;
        Type type = this.getPropertyType();
        if (type != null && type.isCollectionType()) {
            this.collectionRole = ((CollectionType)type).getRole();
            this.collectionName = queryTranslatorImpl.createNameForCollection(this.collectionRole);
            this.prepareForIndex(queryTranslatorImpl);
        } else {
            this.columns = this.currentColumns();
            this.setType();
        }
        this.continuation = false;
    }

    private void prepareForIndex(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        QueryableCollection queryableCollection = queryTranslatorImpl.getCollectionPersister(this.collectionRole);
        if (!queryableCollection.hasIndex()) {
            throw new QueryException("unindexed collection before []: " + this.path);
        }
        String[] stringArray = queryableCollection.getIndexColumnNames();
        if (stringArray.length != 1) {
            throw new QueryException("composite-index appears in []: " + this.path);
        }
        JoinSequence joinSequence = new JoinSequence(queryTranslatorImpl.getFactory()).setUseThetaStyle(this.useThetaStyleJoin).setRoot(queryableCollection, this.collectionName).setNext(this.joinSequence.copy());
        if (!this.continuation) {
            this.addJoin(this.collectionName, queryableCollection.getCollectionType());
        }
        this.joinSequence.addCondition(this.collectionName + '.' + stringArray[0] + " = ");
        CollectionElement collectionElement = new CollectionElement();
        collectionElement.elementColumns = queryableCollection.getElementColumnNames(this.collectionName);
        collectionElement.elementType = queryableCollection.getElementType();
        collectionElement.isOneToMany = queryableCollection.isOneToMany();
        collectionElement.alias = this.collectionName;
        collectionElement.joinSequence = this.joinSequence;
        this.collectionElements.addLast(collectionElement);
        this.setExpectingCollectionIndex();
        queryTranslatorImpl.addCollection(this.collectionName, this.collectionRole);
        queryTranslatorImpl.addFromJoinOnly(this.collectionName, joinSequence);
    }

    public CollectionElement lastCollectionElement() {
        return (CollectionElement)this.collectionElements.removeLast();
    }

    public void setLastCollectionElementIndexValue(String string) {
        ((CollectionElement)this.collectionElements.getLast()).indexValue.append(string);
    }

    public boolean isExpectingCollectionIndex() {
        return this.expectingCollectionIndex;
    }

    protected void setExpectingCollectionIndex() throws QueryException {
        this.expectingCollectionIndex = true;
    }

    public JoinSequence getWhereJoin() {
        return this.joinSequence;
    }

    public String getWhereColumn() throws QueryException {
        if (this.columns.length != 1) {
            throw new QueryException("path expression ends in a composite value: " + this.path);
        }
        return this.columns[0];
    }

    public String[] getWhereColumns() {
        return this.columns;
    }

    public Type getWhereColumnType() {
        return this.type;
    }

    public String getName() {
        return this.currentName == null ? this.collectionName : this.currentName;
    }

    public String getCollectionSubquery(Map map) throws QueryException {
        return CollectionSubqueryFactory.createCollectionSubquery(this.joinSequence, map, this.currentColumns());
    }

    public boolean isCollectionValued() throws QueryException {
        return this.collectionName != null && !this.getPropertyType().isCollectionType();
    }

    public void addAssociation(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        queryTranslatorImpl.addJoin(this.getName(), this.joinSequence);
    }

    public String addFromAssociation(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        if (this.isCollectionValued()) {
            return this.addFromCollection(queryTranslatorImpl);
        }
        queryTranslatorImpl.addFrom(this.currentName, this.joinSequence);
        return this.currentName;
    }

    public String addFromCollection(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        Type type = this.getPropertyType();
        if (type == null) {
            throw new QueryException("must specify 'elements' for collection valued property in from clause: " + this.path);
        }
        if (type.isEntityType()) {
            String string;
            QueryableCollection queryableCollection = queryTranslatorImpl.getCollectionPersister(this.collectionRole);
            Queryable queryable = (Queryable)queryableCollection.getElementPersister();
            String string2 = queryable.getEntityName();
            if (queryableCollection.isOneToMany()) {
                string = this.collectionName;
                queryTranslatorImpl.decoratePropertyMapping(string, queryableCollection);
            } else {
                queryTranslatorImpl.addCollection(this.collectionName, this.collectionRole);
                string = queryTranslatorImpl.createNameFor(string2);
                this.addJoin(string, (AssociationType)type);
            }
            queryTranslatorImpl.addFrom(string, string2, this.joinSequence);
            this.currentPropertyMapping = new CollectionPropertyMapping(queryableCollection);
            return string;
        }
        queryTranslatorImpl.addFromCollection(this.collectionName, this.collectionRole, this.joinSequence);
        return this.collectionName;
    }

    String getCollectionName() {
        return this.collectionName;
    }

    String getCollectionRole() {
        return this.collectionRole;
    }

    String getCollectionOwnerName() {
        return this.collectionOwnerName;
    }

    String getOneToOneOwnerName() {
        return this.oneToOneOwnerName;
    }

    AssociationType getOwnerAssociationType() {
        return this.ownerAssociationType;
    }

    String getCurrentProperty() {
        return this.currentProperty;
    }

    String getCurrentName() {
        return this.currentName;
    }

    public void fetch(QueryTranslatorImpl queryTranslatorImpl, String string) throws QueryException {
        if (this.isCollectionValued()) {
            queryTranslatorImpl.setCollectionToFetch(this.getCollectionRole(), this.getCollectionName(), this.getCollectionOwnerName(), string);
        } else {
            queryTranslatorImpl.addEntityToFetch(string, this.getOneToOneOwnerName(), this.getOwnerAssociationType());
        }
    }

    static final class CollectionElement {
        Type elementType;
        boolean isOneToMany;
        String alias;
        String[] elementColumns;
        JoinSequence joinSequence;
        StringBuffer indexValue = new StringBuffer();

        CollectionElement() {
        }
    }
}

