/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.classic;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.QueryException;
import org.hibernate.hql.CollectionProperties;
import org.hibernate.hql.classic.ClauseParser;
import org.hibernate.hql.classic.Parser;
import org.hibernate.hql.classic.ParserHelper;
import org.hibernate.hql.classic.QueryTranslatorImpl;
import org.hibernate.util.StringHelper;

public class PreprocessingParser
implements Parser {
    private static final Set HQL_OPERATORS = new HashSet();
    private Map replacements;
    private boolean quoted;
    private StringBuffer quotedString;
    private ClauseParser parser = new ClauseParser();
    private String lastToken;
    private String currentCollectionProp;

    public PreprocessingParser(Map map) {
        this.replacements = map;
    }

    public void token(String string, QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        String string2;
        if (this.quoted) {
            this.quotedString.append(string);
        }
        if ("'".equals(string)) {
            if (this.quoted) {
                string = this.quotedString.toString();
            } else {
                this.quotedString = new StringBuffer(20).append(string);
            }
            boolean bl = this.quoted = !this.quoted;
        }
        if (this.quoted) {
            return;
        }
        if (ParserHelper.isWhitespace(string)) {
            return;
        }
        String string3 = (String)this.replacements.get(string);
        String string4 = string = string3 == null ? string : string3;
        if (this.currentCollectionProp != null) {
            if ("(".equals(string)) {
                return;
            }
            if (")".equals(string)) {
                this.currentCollectionProp = null;
                return;
            }
            string = StringHelper.qualify(string, this.currentCollectionProp);
        } else {
            string2 = CollectionProperties.getNormalizedPropertyName(string.toLowerCase());
            if (string2 != null) {
                this.currentCollectionProp = string2;
                return;
            }
        }
        if (this.lastToken == null) {
            this.lastToken = string;
        } else {
            String string5 = string2 = string.length() > 1 ? this.lastToken + ' ' + string : this.lastToken + string;
            if (HQL_OPERATORS.contains(string2.toLowerCase())) {
                this.parser.token(string2, queryTranslatorImpl);
                this.lastToken = null;
            } else {
                this.parser.token(this.lastToken, queryTranslatorImpl);
                this.lastToken = string;
            }
        }
    }

    public void start(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        this.quoted = false;
        this.parser.start(queryTranslatorImpl);
    }

    public void end(QueryTranslatorImpl queryTranslatorImpl) throws QueryException {
        if (this.lastToken != null) {
            this.parser.token(this.lastToken, queryTranslatorImpl);
        }
        this.parser.end(queryTranslatorImpl);
        this.lastToken = null;
        this.currentCollectionProp = null;
    }

    static {
        HQL_OPERATORS.add("<=");
        HQL_OPERATORS.add(">=");
        HQL_OPERATORS.add("=>");
        HQL_OPERATORS.add("=<");
        HQL_OPERATORS.add("!=");
        HQL_OPERATORS.add("<>");
        HQL_OPERATORS.add("!#");
        HQL_OPERATORS.add("!~");
        HQL_OPERATORS.add("!<");
        HQL_OPERATORS.add("!>");
        HQL_OPERATORS.add("is not");
        HQL_OPERATORS.add("not like");
        HQL_OPERATORS.add("not in");
        HQL_OPERATORS.add("not between");
        HQL_OPERATORS.add("not exists");
    }
}

