/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.classic;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.JoinSequence;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.FilterTranslator;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.hql.NameGenerator;
import org.hibernate.hql.ParameterTranslations;
import org.hibernate.hql.classic.ParserHelper;
import org.hibernate.hql.classic.PreprocessingParser;
import org.hibernate.impl.IteratorImpl;
import org.hibernate.loader.BasicLoader;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.QuerySelect;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTranslatorImpl
extends BasicLoader
implements FilterTranslator {
    private static final String[] NO_RETURN_ALIASES = new String[0];
    private final String queryIdentifier;
    private final String queryString;
    private final Map typeMap = new LinkedHashMap();
    private final Map collections = new LinkedHashMap();
    private List returnedTypes = new ArrayList();
    private final List fromTypes = new ArrayList();
    private final List scalarTypes = new ArrayList();
    private final Map namedParameters = new HashMap();
    private final Map aliasNames = new HashMap();
    private final Map oneToOneOwnerNames = new HashMap();
    private final Map uniqueKeyOwnerReferences = new HashMap();
    private final Map decoratedPropertyMappings = new HashMap();
    private final List scalarSelectTokens = new ArrayList();
    private final List whereTokens = new ArrayList();
    private final List havingTokens = new ArrayList();
    private final Map joins = new LinkedHashMap();
    private final List orderByTokens = new ArrayList();
    private final List groupByTokens = new ArrayList();
    private final Set querySpaces = new HashSet();
    private final Set entitiesToFetch = new HashSet();
    private final Map pathAliases = new HashMap();
    private final Map pathJoins = new HashMap();
    private Queryable[] persisters;
    private int[] owners;
    private EntityType[] ownerAssociationTypes;
    private String[] names;
    private boolean[] includeInSelect;
    private int selectLength;
    private Type[] returnTypes;
    private Type[] actualReturnTypes;
    private String[][] scalarColumnNames;
    private Map tokenReplacements;
    private int nameCount = 0;
    private int parameterCount = 0;
    private boolean distinct = false;
    private boolean compiled;
    private String sqlString;
    private Class holderClass;
    private Constructor holderConstructor;
    private boolean hasScalars;
    private boolean shallowQuery;
    private QueryTranslatorImpl superQuery;
    private QueryableCollection collectionPersister;
    private int collectionOwnerColumn = -1;
    private String collectionOwnerName;
    private String fetchName;
    private String[] suffixes;
    private Map enabledFilters;
    private static final Logger log = LoggerFactory.getLogger(QueryTranslatorImpl.class);

    public QueryTranslatorImpl(String string, String string2, Map map, SessionFactoryImplementor sessionFactoryImplementor) {
        super(sessionFactoryImplementor);
        this.queryIdentifier = string;
        this.queryString = string2;
        this.enabledFilters = map;
    }

    public QueryTranslatorImpl(String string, Map map, SessionFactoryImplementor sessionFactoryImplementor) {
        this(string, string, map, sessionFactoryImplementor);
    }

    void compile(QueryTranslatorImpl queryTranslatorImpl) throws QueryException, MappingException {
        this.tokenReplacements = queryTranslatorImpl.tokenReplacements;
        this.superQuery = queryTranslatorImpl;
        this.shallowQuery = true;
        this.enabledFilters = queryTranslatorImpl.getEnabledFilters();
        this.compile();
    }

    public synchronized void compile(Map map, boolean bl) throws QueryException, MappingException {
        if (!this.compiled) {
            this.tokenReplacements = map;
            this.shallowQuery = bl;
            this.compile();
        }
    }

    public synchronized void compile(String string, Map map, boolean bl) throws QueryException, MappingException {
        if (!this.isCompiled()) {
            this.addFromAssociation("this", string);
            this.compile(map, bl);
        }
    }

    private void compile() throws QueryException, MappingException {
        log.trace("compiling query");
        try {
            ParserHelper.parse(new PreprocessingParser(this.tokenReplacements), this.queryString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", this);
            this.renderSQL();
        }
        catch (QueryException queryException) {
            queryException.setQueryString(this.queryString);
            throw queryException;
        }
        catch (MappingException mappingException) {
            throw mappingException;
        }
        catch (Exception exception) {
            log.debug("unexpected query compilation problem", exception);
            exception.printStackTrace();
            QueryException queryException = new QueryException("Incorrect query syntax", exception);
            queryException.setQueryString(this.queryString);
            throw queryException;
        }
        this.postInstantiate();
        this.compiled = true;
    }

    public String getSQLString() {
        return this.sqlString;
    }

    public List collectSqlStrings() {
        return ArrayHelper.toList(new String[]{this.sqlString});
    }

    public String getQueryString() {
        return this.queryString;
    }

    protected Loadable[] getEntityPersisters() {
        return this.persisters;
    }

    public Type[] getReturnTypes() {
        return this.actualReturnTypes;
    }

    public String[] getReturnAliases() {
        return NO_RETURN_ALIASES;
    }

    public String[][] getColumnNames() {
        return this.scalarColumnNames;
    }

    private static void logQuery(String string, String string2) {
        if (log.isDebugEnabled()) {
            log.debug("HQL: " + string);
            log.debug("SQL: " + string2);
        }
    }

    void setAliasName(String string, String string2) {
        this.aliasNames.put(string, string2);
    }

    public String getAliasName(String string) {
        String string2 = (String)this.aliasNames.get(string);
        if (string2 == null) {
            string2 = this.superQuery != null ? this.superQuery.getAliasName(string) : string;
        }
        return string2;
    }

    String unalias(String string) {
        String string2 = StringHelper.root(string);
        String string3 = this.getAliasName(string2);
        if (string3 != null) {
            return string3 + string.substring(string2.length());
        }
        return string;
    }

    void addEntityToFetch(String string, String string2, AssociationType associationType) {
        this.addEntityToFetch(string);
        if (string2 != null) {
            this.oneToOneOwnerNames.put(string, string2);
        }
        if (associationType != null) {
            this.uniqueKeyOwnerReferences.put(string, associationType);
        }
    }

    private void addEntityToFetch(String string) {
        this.entitiesToFetch.add(string);
    }

    private int nextCount() {
        int n;
        if (this.superQuery == null) {
            int n2 = this.nameCount;
            n = n2;
            this.nameCount = n2 + 1;
        } else {
            int n3 = this.superQuery.nameCount;
            n = n3;
            this.superQuery.nameCount = n3 + 1;
        }
        return n;
    }

    String createNameFor(String string) {
        return StringHelper.generateAlias(string, this.nextCount());
    }

    String createNameForCollection(String string) {
        return StringHelper.generateAlias(string, this.nextCount());
    }

    private String getType(String string) {
        String string2 = (String)this.typeMap.get(string);
        if (string2 == null && this.superQuery != null) {
            string2 = this.superQuery.getType(string);
        }
        return string2;
    }

    private String getRole(String string) {
        String string2 = (String)this.collections.get(string);
        if (string2 == null && this.superQuery != null) {
            string2 = this.superQuery.getRole(string);
        }
        return string2;
    }

    boolean isName(String string) {
        return this.aliasNames.containsKey(string) || this.typeMap.containsKey(string) || this.collections.containsKey(string) || this.superQuery != null && this.superQuery.isName(string);
    }

    PropertyMapping getPropertyMapping(String string) throws QueryException {
        PropertyMapping propertyMapping = this.getDecoratedPropertyMapping(string);
        if (propertyMapping != null) {
            return propertyMapping;
        }
        String string2 = this.getType(string);
        if (string2 == null) {
            String string3 = this.getRole(string);
            if (string3 == null) {
                throw new QueryException("alias not found: " + string);
            }
            return this.getCollectionPersister(string3);
        }
        Queryable queryable = this.getEntityPersister(string2);
        if (queryable == null) {
            throw new QueryException("persistent class not found: " + string2);
        }
        return queryable;
    }

    private PropertyMapping getDecoratedPropertyMapping(String string) {
        return (PropertyMapping)this.decoratedPropertyMappings.get(string);
    }

    void decoratePropertyMapping(String string, PropertyMapping propertyMapping) {
        this.decoratedPropertyMappings.put(string, propertyMapping);
    }

    private Queryable getEntityPersisterForName(String string) throws QueryException {
        String string2 = this.getType(string);
        Queryable queryable = this.getEntityPersister(string2);
        if (queryable == null) {
            throw new QueryException("persistent class not found: " + string2);
        }
        return queryable;
    }

    Queryable getEntityPersisterUsingImports(String string) {
        String string2 = this.getFactory().getImportedClassName(string);
        if (string2 == null) {
            return null;
        }
        try {
            return (Queryable)this.getFactory().getEntityPersister(string2);
        }
        catch (MappingException mappingException) {
            return null;
        }
    }

    Queryable getEntityPersister(String string) throws QueryException {
        try {
            return (Queryable)this.getFactory().getEntityPersister(string);
        }
        catch (Exception exception) {
            throw new QueryException("persistent class not found: " + string);
        }
    }

    QueryableCollection getCollectionPersister(String string) throws QueryException {
        try {
            return (QueryableCollection)this.getFactory().getCollectionPersister(string);
        }
        catch (ClassCastException classCastException) {
            throw new QueryException("collection role is not queryable: " + string);
        }
        catch (Exception exception) {
            throw new QueryException("collection role not found: " + string);
        }
    }

    void addType(String string, String string2) {
        this.typeMap.put(string, string2);
    }

    void addCollection(String string, String string2) {
        this.collections.put(string, string2);
    }

    void addFrom(String string, String string2, JoinSequence joinSequence) throws QueryException {
        this.addType(string, string2);
        this.addFrom(string, joinSequence);
    }

    void addFromCollection(String string, String string2, JoinSequence joinSequence) throws QueryException {
        this.addCollection(string, string2);
        this.addJoin(string, joinSequence);
    }

    void addFrom(String string, JoinSequence joinSequence) throws QueryException {
        this.fromTypes.add(string);
        this.addJoin(string, joinSequence);
    }

    void addFromClass(String string, Queryable queryable) throws QueryException {
        JoinSequence joinSequence = new JoinSequence(this.getFactory()).setRoot(queryable, string);
        this.addFrom(string, queryable.getEntityName(), joinSequence);
    }

    void addSelectClass(String string) {
        this.returnedTypes.add(string);
    }

    void addSelectScalar(Type type) {
        this.scalarTypes.add(type);
    }

    void appendWhereToken(String string) {
        this.whereTokens.add(string);
    }

    void appendHavingToken(String string) {
        this.havingTokens.add(string);
    }

    void appendOrderByToken(String string) {
        this.orderByTokens.add(string);
    }

    void appendGroupByToken(String string) {
        this.groupByTokens.add(string);
    }

    void appendScalarSelectToken(String string) {
        this.scalarSelectTokens.add(string);
    }

    void appendScalarSelectTokens(String[] stringArray) {
        this.scalarSelectTokens.add(stringArray);
    }

    void addFromJoinOnly(String string, JoinSequence joinSequence) throws QueryException {
        this.addJoin(string, joinSequence.getFromPart());
    }

    void addJoin(String string, JoinSequence joinSequence) throws QueryException {
        if (!this.joins.containsKey(string)) {
            this.joins.put(string, joinSequence);
        }
    }

    void addNamedParameter(String string) {
        if (this.superQuery != null) {
            this.superQuery.addNamedParameter(string);
        }
        Integer n = new Integer(this.parameterCount++);
        Object v = this.namedParameters.get(string);
        if (v == null) {
            this.namedParameters.put(string, n);
        } else if (v instanceof Integer) {
            ArrayList<Object> arrayList = new ArrayList<Object>(4);
            arrayList.add(v);
            arrayList.add(n);
            this.namedParameters.put(string, arrayList);
        } else {
            ((ArrayList)v).add(n);
        }
    }

    public int[] getNamedParameterLocs(String string) throws QueryException {
        Object v = this.namedParameters.get(string);
        if (v == null) {
            QueryException queryException = new QueryException("Named parameter does not appear in Query: " + string);
            queryException.setQueryString(this.queryString);
            throw queryException;
        }
        if (v instanceof Integer) {
            return new int[]{(Integer)v};
        }
        return ArrayHelper.toIntArray((ArrayList)v);
    }

    private void renderSQL() throws QueryException, MappingException {
        Joinable joinable;
        int n;
        if (this.returnedTypes.size() == 0 && this.scalarTypes.size() == 0) {
            this.returnedTypes = this.fromTypes;
            n = this.returnedTypes.size();
        } else {
            n = this.returnedTypes.size();
            Iterator iterator = this.entitiesToFetch.iterator();
            while (iterator.hasNext()) {
                this.returnedTypes.add(iterator.next());
            }
        }
        int n2 = this.returnedTypes.size();
        this.persisters = new Queryable[n2];
        this.names = new String[n2];
        this.owners = new int[n2];
        this.ownerAssociationTypes = new EntityType[n2];
        this.suffixes = new String[n2];
        this.includeInSelect = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            String string;
            String string2 = (String)this.returnedTypes.get(i);
            this.persisters[i] = this.getEntityPersisterForName(string2);
            this.suffixes[i] = n2 == 1 ? "" : Integer.toString(i) + '_';
            this.names[i] = string2;
            boolean bl = this.includeInSelect[i] = !this.entitiesToFetch.contains(string2);
            if (this.includeInSelect[i]) {
                ++this.selectLength;
            }
            if (string2.equals(this.collectionOwnerName)) {
                this.collectionOwnerColumn = i;
            }
            this.owners[i] = (string = (String)this.oneToOneOwnerNames.get(string2)) == null ? -1 : this.returnedTypes.indexOf(string);
            this.ownerAssociationTypes[i] = (EntityType)this.uniqueKeyOwnerReferences.get(string2);
        }
        if (ArrayHelper.isAllNegative(this.owners)) {
            this.owners = null;
        }
        String string = this.renderScalarSelect();
        int n3 = this.scalarTypes.size();
        this.hasScalars = this.scalarTypes.size() != n;
        this.returnTypes = new Type[n3];
        for (int i = 0; i < n3; ++i) {
            this.returnTypes[i] = (Type)this.scalarTypes.get(i);
        }
        QuerySelect querySelect = new QuerySelect(this.getFactory().getDialect());
        querySelect.setDistinct(this.distinct);
        if (!this.shallowQuery) {
            this.renderIdentifierSelect(querySelect);
            this.renderPropertiesSelect(querySelect);
        }
        if (this.collectionPersister != null) {
            querySelect.addSelectFragmentString(this.collectionPersister.selectFragment(this.fetchName, "__"));
        }
        if (this.hasScalars || this.shallowQuery) {
            querySelect.addSelectFragmentString(string);
        }
        this.mergeJoins(querySelect.getJoinFragment());
        querySelect.setWhereTokens(this.whereTokens.iterator());
        querySelect.setGroupByTokens(this.groupByTokens.iterator());
        querySelect.setHavingTokens(this.havingTokens.iterator());
        querySelect.setOrderByTokens(this.orderByTokens.iterator());
        if (this.collectionPersister != null && this.collectionPersister.hasOrdering()) {
            querySelect.addOrderBy(this.collectionPersister.getSQLOrderByString(this.fetchName));
        }
        this.scalarColumnNames = NameGenerator.generateColumnNames(this.returnTypes, this.getFactory());
        Iterator<Object> iterator = this.collections.values().iterator();
        while (iterator.hasNext()) {
            joinable = this.getCollectionPersister((String)iterator.next());
            this.addQuerySpaces(joinable.getCollectionSpaces());
        }
        iterator = this.typeMap.keySet().iterator();
        while (iterator.hasNext()) {
            joinable = this.getEntityPersisterForName((String)iterator.next());
            this.addQuerySpaces(joinable.getQuerySpaces());
        }
        this.sqlString = querySelect.toQueryString();
        if (this.holderClass != null) {
            this.holderConstructor = ReflectHelper.getConstructor(this.holderClass, this.returnTypes);
        }
        if (this.hasScalars) {
            this.actualReturnTypes = this.returnTypes;
        } else {
            this.actualReturnTypes = new Type[this.selectLength];
            int n4 = 0;
            for (int i = 0; i < this.persisters.length; ++i) {
                if (!this.includeInSelect[i]) continue;
                this.actualReturnTypes[n4++] = this.getFactory().getTypeResolver().getTypeFactory().manyToOne(this.persisters[i].getEntityName(), this.shallowQuery);
            }
        }
    }

    private void renderIdentifierSelect(QuerySelect querySelect) {
        int n = this.returnedTypes.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.returnedTypes.get(i);
            String string2 = n == 1 ? "" : Integer.toString(i) + '_';
            querySelect.addSelectFragmentString(this.persisters[i].identifierSelectFragment(string, string2));
        }
    }

    private void renderPropertiesSelect(QuerySelect querySelect) {
        int n = this.returnedTypes.size();
        for (int i = 0; i < n; ++i) {
            String string = n == 1 ? "" : Integer.toString(i) + '_';
            String string2 = (String)this.returnedTypes.get(i);
            querySelect.addSelectFragmentString(this.persisters[i].propertySelectFragment(string2, string, false));
        }
    }

    private String renderScalarSelect() {
        boolean bl = this.superQuery != null;
        StringBuffer stringBuffer = new StringBuffer(20);
        if (this.scalarTypes.size() == 0) {
            int n = this.returnedTypes.size();
            for (int i = 0; i < n; ++i) {
                this.scalarTypes.add(this.getFactory().getTypeResolver().getTypeFactory().manyToOne(this.persisters[i].getEntityName(), this.shallowQuery));
                String[] stringArray = this.persisters[i].getIdentifierColumnNames();
                for (int j = 0; j < stringArray.length; ++j) {
                    stringBuffer.append(this.returnedTypes.get(i)).append('.').append(stringArray[j]);
                    if (!bl) {
                        stringBuffer.append(" as ").append(NameGenerator.scalarName(i, j));
                    }
                    if (j == stringArray.length - 1 && i == n - 1) continue;
                    stringBuffer.append(", ");
                }
            }
        } else {
            Iterator iterator = this.scalarSelectTokens.iterator();
            int n = 0;
            boolean bl2 = false;
            int n2 = 0;
            while (iterator.hasNext()) {
                String[] stringArray;
                Object e = iterator.next();
                if (e instanceof String) {
                    stringArray = (String[])e;
                    if ("(".equals(stringArray)) {
                        ++n2;
                    } else if (")".equals(stringArray)) {
                        --n2;
                    }
                    String string = stringArray.toLowerCase();
                    if (string.equals(", ")) {
                        if (bl2) {
                            bl2 = false;
                        } else if (!bl && n2 == 0) {
                            int n3 = n++;
                            stringBuffer.append(" as ").append(NameGenerator.scalarName(n3, 0));
                        }
                    }
                    stringBuffer.append((String)stringArray);
                    if (!string.equals("distinct") && !string.equals("all")) continue;
                    stringBuffer.append(' ');
                    continue;
                }
                bl2 = true;
                stringArray = (String[])e;
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append(stringArray[i]);
                    if (!bl) {
                        stringBuffer.append(" as ").append(NameGenerator.scalarName(n, i));
                    }
                    if (i == stringArray.length - 1) continue;
                    stringBuffer.append(", ");
                }
                ++n;
            }
            if (!bl && !bl2) {
                int n4 = n++;
                stringBuffer.append(" as ").append(NameGenerator.scalarName(n4, 0));
            }
        }
        return stringBuffer.toString();
    }

    private void mergeJoins(JoinFragment joinFragment) throws MappingException, QueryException {
        for (Map.Entry entry : this.joins.entrySet()) {
            String string = (String)entry.getKey();
            JoinSequence joinSequence = (JoinSequence)entry.getValue();
            joinSequence.setSelector(new JoinSequence.Selector(){

                public boolean includeSubclasses(String string) {
                    boolean bl = QueryTranslatorImpl.this.returnedTypes.contains(string) && !QueryTranslatorImpl.this.isShallowQuery();
                    return bl;
                }
            });
            if (this.typeMap.containsKey(string)) {
                joinFragment.addFragment(joinSequence.toJoinFragment(this.enabledFilters, true));
                continue;
            }
            if (!this.collections.containsKey(string)) continue;
            joinFragment.addFragment(joinSequence.toJoinFragment(this.enabledFilters, true));
        }
    }

    public final Set getQuerySpaces() {
        return this.querySpaces;
    }

    boolean isShallowQuery() {
        return this.shallowQuery;
    }

    void addQuerySpaces(Serializable[] serializableArray) {
        for (int i = 0; i < serializableArray.length; ++i) {
            this.querySpaces.add(serializableArray[i]);
        }
        if (this.superQuery != null) {
            this.superQuery.addQuerySpaces(serializableArray);
        }
    }

    void setDistinct(boolean bl) {
        this.distinct = bl;
    }

    boolean isSubquery() {
        return this.superQuery != null;
    }

    public CollectionPersister[] getCollectionPersisters() {
        CollectionPersister[] collectionPersisterArray;
        if (this.collectionPersister == null) {
            collectionPersisterArray = null;
        } else {
            CollectionPersister[] collectionPersisterArray2 = new CollectionPersister[1];
            collectionPersisterArray = collectionPersisterArray2;
            collectionPersisterArray2[0] = this.collectionPersister;
        }
        return collectionPersisterArray;
    }

    protected String[] getCollectionSuffixes() {
        String[] stringArray;
        if (this.collectionPersister == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "__";
        }
        return stringArray;
    }

    void setCollectionToFetch(String string, String string2, String string3, String string4) throws QueryException {
        this.fetchName = string2;
        this.collectionPersister = this.getCollectionPersister(string);
        this.collectionOwnerName = string3;
        if (this.collectionPersister.getElementType().isEntityType()) {
            this.addEntityToFetch(string4);
        }
    }

    protected String[] getSuffixes() {
        return this.suffixes;
    }

    protected String[] getAliases() {
        return this.names;
    }

    private void addFromAssociation(String string, String string2) throws QueryException {
        QueryableCollection queryableCollection = this.getCollectionPersister(string2);
        Type type = queryableCollection.getElementType();
        if (!type.isEntityType()) {
            throw new QueryException("collection of values in filter: " + string);
        }
        String[] stringArray = queryableCollection.getKeyColumnNames();
        JoinSequence joinSequence = new JoinSequence(this.getFactory());
        String string3 = queryableCollection.isOneToMany() ? string : this.createNameForCollection(string2);
        joinSequence.setRoot(queryableCollection, string3);
        if (!queryableCollection.isOneToMany()) {
            this.addCollection(string3, string2);
            try {
                joinSequence.addJoin((AssociationType)queryableCollection.getElementType(), string, 0, queryableCollection.getElementColumnNames(string3));
            }
            catch (MappingException mappingException) {
                throw new QueryException(mappingException);
            }
        }
        joinSequence.addCondition(string3, stringArray, " = ?");
        EntityType entityType = (EntityType)type;
        this.addFrom(string, entityType.getAssociatedEntityName(), joinSequence);
    }

    String getPathAlias(String string) {
        return (String)this.pathAliases.get(string);
    }

    JoinSequence getPathJoin(String string) {
        return (JoinSequence)this.pathJoins.get(string);
    }

    void addPathAliasAndJoin(String string, String string2, JoinSequence joinSequence) {
        this.pathAliases.put(string, string2);
        this.pathJoins.put(string, joinSequence);
    }

    public List list(SessionImplementor sessionImplementor, QueryParameters queryParameters) throws HibernateException {
        return this.list(sessionImplementor, queryParameters, this.getQuerySpaces(), this.actualReturnTypes);
    }

    public Iterator iterate(QueryParameters queryParameters, EventSource eventSource) throws HibernateException {
        boolean bl = eventSource.getFactory().getStatistics().isStatisticsEnabled();
        long l = 0L;
        if (bl) {
            l = System.currentTimeMillis();
        }
        try {
            PreparedStatement preparedStatement = this.prepareQueryStatement(queryParameters, false, eventSource);
            ResultSet resultSet = this.getResultSet(preparedStatement, queryParameters.hasAutoDiscoverScalarTypes(), false, queryParameters.getRowSelection(), eventSource);
            HolderInstantiator holderInstantiator = HolderInstantiator.createClassicHolderInstantiator(this.holderConstructor, queryParameters.getResultTransformer());
            IteratorImpl iteratorImpl = new IteratorImpl(resultSet, preparedStatement, eventSource, queryParameters.isReadOnly(eventSource), this.returnTypes, this.getColumnNames(), holderInstantiator);
            if (bl) {
                eventSource.getFactory().getStatisticsImplementor().queryExecuted("HQL: " + this.queryString, 0, System.currentTimeMillis() - l);
            }
            return iteratorImpl;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not execute query using iterate", this.getSQLString());
        }
    }

    public int executeUpdate(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        throw new UnsupportedOperationException("Not supported!  Use the AST translator...");
    }

    protected ResultTransformer resolveResultTransformer(ResultTransformer resultTransformer) {
        return HolderInstantiator.resolveClassicResultTransformer(this.holderConstructor, resultTransformer);
    }

    protected Object getResultColumnOrRow(Object[] objectArray, ResultTransformer resultTransformer, ResultSet resultSet, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        objectArray = this.toResultRow(objectArray);
        if (this.hasScalars) {
            String[][] stringArray = this.getColumnNames();
            int n = this.returnTypes.length;
            if (this.holderClass == null && n == 1) {
                return this.returnTypes[0].nullSafeGet(resultSet, stringArray[0], sessionImplementor, null);
            }
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = this.returnTypes[i].nullSafeGet(resultSet, stringArray[i], sessionImplementor, null);
            }
            return objectArray;
        }
        if (this.holderClass == null) {
            return objectArray.length == 1 ? objectArray[0] : objectArray;
        }
        return objectArray;
    }

    protected List getResultList(List list, ResultTransformer resultTransformer) throws QueryException {
        if (this.holderClass != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object[] objectArray = (Object[])list.get(i);
                try {
                    list.set(i, this.holderConstructor.newInstance(objectArray));
                    continue;
                }
                catch (Exception exception) {
                    throw new QueryException("could not instantiate: " + this.holderClass, exception);
                }
            }
        }
        return list;
    }

    private Object[] toResultRow(Object[] objectArray) {
        if (this.selectLength == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[this.selectLength];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.includeInSelect[i]) continue;
            objectArray2[n++] = objectArray[i];
        }
        return objectArray2;
    }

    void setHolderClass(Class clazz) {
        this.holderClass = clazz;
    }

    protected LockMode[] getLockModes(LockOptions lockOptions) {
        LockMode[] lockModeArray;
        HashMap hashMap = new HashMap();
        if (lockOptions == null) {
            lockOptions = LockOptions.NONE;
        }
        if (lockOptions.getAliasLockCount() > 0) {
            lockModeArray = lockOptions.getAliasLockIterator();
            while (lockModeArray.hasNext()) {
                Map.Entry entry = (Map.Entry)lockModeArray.next();
                hashMap.put(this.getAliasName((String)entry.getKey()), entry.getValue());
            }
        }
        lockModeArray = new LockMode[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            LockMode lockMode = (LockMode)hashMap.get(this.names[i]);
            if (lockMode == null) {
                lockMode = lockOptions.getLockMode();
            }
            lockModeArray[i] = lockMode;
        }
        return lockModeArray;
    }

    protected String applyLocks(String string, LockOptions lockOptions, Dialect dialect) throws QueryException {
        Object object;
        if (lockOptions == null || lockOptions.getLockMode() == LockMode.NONE && lockOptions.getAliasLockCount() == 0) {
            return string;
        }
        LockOptions lockOptions2 = new LockOptions();
        lockOptions2.setLockMode(lockOptions.getLockMode());
        lockOptions2.setTimeOut(lockOptions.getTimeOut());
        lockOptions2.setScope(lockOptions.getScope());
        Iterator iterator = lockOptions.getAliasLockIterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            lockOptions2.setAliasSpecificLockMode(this.getAliasName((String)object.getKey()), (LockMode)object.getValue());
        }
        object = null;
        if (dialect.forUpdateOfColumns()) {
            object = new HashMap();
            for (int i = 0; i < this.names.length; ++i) {
                object.put(this.names[i], this.persisters[i].getIdentifierColumnNames());
            }
        }
        String string2 = dialect.applyLocksToSql(string, lockOptions2, (Map)object);
        QueryTranslatorImpl.logQuery(this.queryString, string2);
        return string2;
    }

    protected boolean upgradeLocks() {
        return true;
    }

    protected int[] getCollectionOwners() {
        return new int[]{this.collectionOwnerColumn};
    }

    protected boolean isCompiled() {
        return this.compiled;
    }

    public String toString() {
        return this.queryString;
    }

    protected int[] getOwners() {
        return this.owners;
    }

    protected EntityType[] getOwnerAssociationTypes() {
        return this.ownerAssociationTypes;
    }

    public Class getHolderClass() {
        return this.holderClass;
    }

    public Map getEnabledFilters() {
        return this.enabledFilters;
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        HolderInstantiator holderInstantiator = HolderInstantiator.createClassicHolderInstantiator(this.holderConstructor, queryParameters.getResultTransformer());
        return this.scroll(queryParameters, this.returnTypes, holderInstantiator, sessionImplementor);
    }

    public String getQueryIdentifier() {
        return this.queryIdentifier;
    }

    protected boolean isSubselectLoadingEnabled() {
        return this.hasSubselectLoadableCollections();
    }

    public void validateScrollability() throws HibernateException {
        if (this.getCollectionPersisters() != null) {
            throw new HibernateException("Cannot scroll queries which initialize collections");
        }
    }

    public boolean containsCollectionFetches() {
        return false;
    }

    public boolean isManipulationStatement() {
        return false;
    }

    public ParameterTranslations getParameterTranslations() {
        return new ParameterTranslations(){

            public boolean supportsOrdinalParameterMetadata() {
                return false;
            }

            public int getOrdinalParameterCount() {
                return 0;
            }

            public int getOrdinalParameterSqlLocation(int n) {
                return 0;
            }

            public Type getOrdinalParameterExpectedType(int n) {
                return null;
            }

            public Set getNamedParameterNames() {
                return QueryTranslatorImpl.this.namedParameters.keySet();
            }

            public int[] getNamedParameterSqlLocations(String string) {
                return QueryTranslatorImpl.this.getNamedParameterLocs(string);
            }

            public Type getNamedParameterExpectedType(String string) {
                return null;
            }
        };
    }
}

