/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class ForeignGenerator
implements IdentifierGenerator,
Configurable {
    private String entityName;
    private String propertyName;

    public String getEntityName() {
        return this.entityName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getRole() {
        return this.getEntityName() + '.' + this.getPropertyName();
    }

    public void configure(Type type, Properties properties, Dialect dialect) {
        this.propertyName = properties.getProperty("property");
        this.entityName = properties.getProperty("entity_name");
        if (this.propertyName == null) {
            throw new MappingException("param named \"property\" is required for foreign id generation strategy");
        }
    }

    public Serializable generate(SessionImplementor sessionImplementor, Object object) {
        Serializable serializable;
        Session session = (Session)((Object)sessionImplementor);
        EntityPersister entityPersister = sessionImplementor.getFactory().getEntityPersister(this.entityName);
        Object object2 = entityPersister.getPropertyValue(object, this.propertyName, session.getEntityMode());
        if (object2 == null) {
            throw new IdentifierGenerationException("attempted to assign id from null one-to-one property [" + this.getRole() + "]");
        }
        Type type = entityPersister.getPropertyType(this.propertyName);
        EntityType entityType = type.isEntityType() ? (EntityType)type : (EntityType)entityPersister.getPropertyType("_identifierMapper." + this.propertyName);
        try {
            serializable = ForeignKeys.getEntityIdentifierIfNotUnsaved(entityType.getAssociatedEntityName(), object2, sessionImplementor);
        }
        catch (TransientObjectException transientObjectException) {
            serializable = session.save(entityType.getAssociatedEntityName(), object2);
        }
        if (session.contains(object)) {
            return IdentifierGeneratorHelper.SHORT_CIRCUIT_INDICATOR;
        }
        return serializable;
    }
}

