/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIDGenerator
implements IdentifierGenerator {
    private static final Logger log = LoggerFactory.getLogger(GUIDGenerator.class);
    private static boolean warned = false;

    public GUIDGenerator() {
        if (!warned) {
            warned = true;
            log.warn("DEPRECATED : use {} instead with custom {} implementation", (Object)UUIDGenerator.class.getName(), (Object)UUIDGenerationStrategy.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        String string;
        String string2 = sessionImplementor.getFactory().getDialect().getSelectGUIDString();
        PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(string2);
        try {
            String string3;
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                resultSet.next();
                string3 = resultSet.getString(1);
            }
            finally {
                resultSet.close();
            }
            log.debug("GUID identifier generated: " + string3);
            string = string3;
        }
        catch (Throwable throwable) {
            try {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not retrieve GUID", string2);
            }
        }
        sessionImplementor.getBatcher().closeStatement(preparedStatement);
        return string;
    }
}

