/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementGenerator
implements IdentifierGenerator,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(IncrementGenerator.class);
    private Class returnClass;
    private String sql;
    private IntegralDataTypeHolder previousValueHolder;

    public synchronized Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        if (this.sql != null) {
            this.initializePreviousValueHolder(sessionImplementor);
        }
        return this.previousValueHolder.makeValueThenIncrement();
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.returnClass = type.getReturnedClass();
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        String string = properties.getProperty("column");
        if (string == null) {
            string = properties.getProperty("target_column");
        }
        string = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(string));
        String string2 = properties.getProperty("tables");
        if (string2 == null) {
            string2 = properties.getProperty("identity_tables");
        }
        String[] stringArray = StringHelper.split(", ", string2);
        String string3 = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("schema")));
        String string4 = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("catalog")));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(stringArray[i]));
            if (stringArray.length > 1) {
                stringBuffer.append("select ").append(string).append(" from ");
            }
            stringBuffer.append(Table.qualify(string4, string3, string5));
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(" union ");
        }
        if (stringArray.length > 1) {
            stringBuffer.insert(0, "( ").append(" ) ids_");
            string = "ids_." + string;
        }
        this.sql = "select max(" + string + ") from " + stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePreviousValueHolder(SessionImplementor sessionImplementor) {
        this.previousValueHolder = IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.returnClass);
        log.debug("fetching initial value: " + this.sql);
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.sql);
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (resultSet.next()) {
                        this.previousValueHolder.initialize(resultSet, 0L).increment();
                    } else {
                        this.previousValueHolder.initialize(1L);
                    }
                    this.sql = null;
                    log.debug("first free id: " + this.previousValueHolder.makeValue());
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not fetch initial value for increment generator", this.sql);
        }
    }
}

