/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.ValueInclusion;
import org.hibernate.id.AbstractPostInsertGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.AbstractSelectingDelegate;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.type.Type;

public class SelectGenerator
extends AbstractPostInsertGenerator
implements Configurable {
    private String uniqueKeyPropertyName;

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.uniqueKeyPropertyName = properties.getProperty("key");
    }

    public InsertGeneratedIdentifierDelegate getInsertGeneratedIdentifierDelegate(PostInsertIdentityPersister postInsertIdentityPersister, Dialect dialect, boolean bl) throws HibernateException {
        return new SelectGeneratorDelegate(postInsertIdentityPersister, dialect, this.uniqueKeyPropertyName);
    }

    private static String determineNameOfPropertyToUse(PostInsertIdentityPersister postInsertIdentityPersister, String string) {
        if (string != null) {
            return string;
        }
        int[] nArray = postInsertIdentityPersister.getNaturalIdentifierProperties();
        if (nArray == null) {
            throw new IdentifierGenerationException("no natural-id property defined; need to specify [key] in generator parameters");
        }
        if (nArray.length > 1) {
            throw new IdentifierGenerationException("select generator does not currently support composite natural-id properties; need to specify [key] in generator parameters");
        }
        ValueInclusion valueInclusion = postInsertIdentityPersister.getPropertyInsertGenerationInclusions()[nArray[0]];
        if (valueInclusion != ValueInclusion.NONE) {
            throw new IdentifierGenerationException("natural-id also defined as insert-generated; need to specify [key] in generator parameters");
        }
        return postInsertIdentityPersister.getPropertyNames()[nArray[0]];
    }

    public static class SelectGeneratorDelegate
    extends AbstractSelectingDelegate
    implements InsertGeneratedIdentifierDelegate {
        private final PostInsertIdentityPersister persister;
        private final Dialect dialect;
        private final String uniqueKeyPropertyName;
        private final Type uniqueKeyType;
        private final Type idType;
        private final String idSelectString;

        private SelectGeneratorDelegate(PostInsertIdentityPersister postInsertIdentityPersister, Dialect dialect, String string) {
            super(postInsertIdentityPersister);
            this.persister = postInsertIdentityPersister;
            this.dialect = dialect;
            this.uniqueKeyPropertyName = SelectGenerator.determineNameOfPropertyToUse(postInsertIdentityPersister, string);
            this.idSelectString = postInsertIdentityPersister.getSelectByUniqueKeyString(this.uniqueKeyPropertyName);
            this.uniqueKeyType = postInsertIdentityPersister.getPropertyType(this.uniqueKeyPropertyName);
            this.idType = postInsertIdentityPersister.getIdentifierType();
        }

        public IdentifierGeneratingInsert prepareIdentifierGeneratingInsert() {
            return new IdentifierGeneratingInsert(this.dialect);
        }

        protected String getSelectSQL() {
            return this.idSelectString;
        }

        protected void bindParameters(SessionImplementor sessionImplementor, PreparedStatement preparedStatement, Object object) throws SQLException {
            Object object2 = this.persister.getPropertyValue(object, this.uniqueKeyPropertyName, sessionImplementor.getEntityMode());
            this.uniqueKeyType.nullSafeSet(preparedStatement, object2, 1, sessionImplementor);
        }

        protected Serializable getResult(SessionImplementor sessionImplementor, ResultSet resultSet, Object object) throws SQLException {
            if (!resultSet.next()) {
                throw new IdentifierGenerationException("the inserted row could not be located by the unique key: " + this.uniqueKeyPropertyName);
            }
            return (Serializable)this.idType.nullSafeGet(resultSet, this.persister.getRootTableKeyColumnNames(), sessionImplementor, object);
        }
    }
}

