/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(SequenceGenerator.class);
    public static final String SEQUENCE = "sequence";
    public static final String PARAMETERS = "parameters";
    private String sequenceName;
    private String parameters;
    private Type identifierType;
    private String sql;

    protected Type getIdentifierType() {
        return this.identifierType;
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        this.sequenceName = objectNameNormalizer.normalizeIdentifierQuoting(PropertiesHelper.getString(SEQUENCE, properties, "hibernate_sequence"));
        this.parameters = properties.getProperty(PARAMETERS);
        if (this.sequenceName.indexOf(46) < 0) {
            String string = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("schema"));
            String string2 = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("catalog"));
            this.sequenceName = Table.qualify(dialect.quote(string2), dialect.quote(string), dialect.quote(this.sequenceName));
        }
        this.identifierType = type;
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    public Serializable generate(SessionImplementor sessionImplementor, Object object) {
        return this.generateHolder(sessionImplementor).makeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected IntegralDataTypeHolder generateHolder(SessionImplementor sessionImplementor) {
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.sql);
            try {
                IntegralDataTypeHolder integralDataTypeHolder;
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    IntegralDataTypeHolder integralDataTypeHolder2 = this.buildHolder();
                    integralDataTypeHolder2.initialize(resultSet, 1L);
                    if (log.isDebugEnabled()) {
                        log.debug("Sequence identifier generated: " + integralDataTypeHolder2);
                    }
                    integralDataTypeHolder = integralDataTypeHolder2;
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return integralDataTypeHolder;
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not get next sequence value", this.sql);
        }
    }

    protected IntegralDataTypeHolder buildHolder() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String[] stringArray = dialect.getCreateSequenceStrings(this.sequenceName);
        if (this.parameters != null) {
            int n = stringArray.length - 1;
            stringArray[n] = stringArray[n] + ' ' + this.parameters;
        }
        return stringArray;
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    public Object generatorKey() {
        return this.sequenceName;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }
}

