/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class SequenceHiLoGenerator
extends SequenceGenerator {
    public static final String MAX_LO = "max_lo";
    private int maxLo;
    private OptimizerFactory.LegacyHiLoAlgorithmOptimizer hiloOptimizer;

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        super.configure(type, properties, dialect);
        this.maxLo = PropertiesHelper.getInt(MAX_LO, properties, 9);
        if (this.maxLo >= 1) {
            this.hiloOptimizer = new OptimizerFactory.LegacyHiLoAlgorithmOptimizer(this.getIdentifierType().getReturnedClass(), this.maxLo);
        }
    }

    public synchronized Serializable generate(final SessionImplementor sessionImplementor, Object object) {
        if (this.maxLo < 1) {
            IntegralDataTypeHolder integralDataTypeHolder = null;
            while (integralDataTypeHolder == null || integralDataTypeHolder.lt(0L)) {
                integralDataTypeHolder = super.generateHolder(sessionImplementor);
            }
            return integralDataTypeHolder.makeValue();
        }
        return this.hiloOptimizer.generate(new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return SequenceHiLoGenerator.this.generateHolder(sessionImplementor);
            }
        });
    }

    OptimizerFactory.LegacyHiLoAlgorithmOptimizer getHiloOptimizer() {
        return this.hiloOptimizer;
    }
}

